/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.AbortException;
import hudson.FilePath;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClearToolExec
implements ClearTool {
    private transient Pattern viewListPattern;
    protected ClearToolLauncher launcher;
    protected VariableResolver variableResolver;

    public ClearToolExec(VariableResolver variableResolver, ClearToolLauncher launcher) {
        this.variableResolver = variableResolver;
        this.launcher = launcher;
    }

    public ClearToolLauncher getLauncher() {
        return this.launcher;
    }

    protected abstract FilePath getRootViewPath(ClearToolLauncher var1);

    public Reader lshistory(String format, Date lastBuildDate, String viewName, String branch, String[] viewPaths) throws IOException, InterruptedException {
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy.HH:mm:ss'UTC'Z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lshistory");
        cmd.add("-all");
        cmd.add(new String[]{"-since", formatter.format(lastBuildDate).toLowerCase()});
        cmd.add(new String[]{"-fmt", format});
        if (branch != null && branch.length() > 0) {
            cmd.add(new String[]{"-branch", "brtype:" + branch});
        }
        cmd.add("-nco");
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewName);
        for (String path : viewPaths) {
            if ((path = path.replace("\n", "").replace("\r", "")).matches(".*\\s.*")) {
                cmd.addQuoted(path);
                continue;
            }
            cmd.add(path);
        }
        InputStreamReader returnReader = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, viewPath)) {
            returnReader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        }
        baos.close();
        return returnReader;
    }

    public Reader lsactivity(String activity, String commandFormat, String viewname) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsactivity");
        cmd.add(new String[]{"-fmt", commandFormat});
        cmd.add(activity);
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewname);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, viewPath);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        baos.close();
        return reader;
    }

    public void mklabel(String viewName, String label) throws IOException, InterruptedException {
        throw new AbortException();
    }

    public List<String> lsview(boolean onlyActiveDynamicViews) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null)) {
            return this.parseListOutput((Reader)new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyActiveDynamicViews);
        }
        return new ArrayList<String>();
    }

    public boolean doesViewExist(String viewName) throws IOException, InterruptedException {
        List views = this.lsview(false);
        for (String v : views) {
            if (!v.equals(viewName)) continue;
            return true;
        }
        return false;
    }

    public List<String> lsvob(boolean onlyMounted) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsvob");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null)) {
            return this.parseListOutput((Reader)new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyMounted);
        }
        return new ArrayList<String>();
    }

    public String pwv(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("pwv");
        cmd.add("-root");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String retString = "";
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewName);
        if (this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, viewPath)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
            retString = reader.readLine();
            reader.close();
        }
        baos.close();
        return retString;
    }

    public String catcs(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("catcs");
        cmd.add(new String[]{"-tag", viewName});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String retString = "";
        if (this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
            String line = reader.readLine();
            StringBuilder builder = new StringBuilder();
            while (line != null) {
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(line);
                line = reader.readLine();
            }
            reader.close();
            retString = builder.toString();
        }
        baos.close();
        return retString;
    }

    private List<String> parseListOutput(Reader consoleReader, boolean onlyStarMarked) throws IOException {
        ArrayList<String> views = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(consoleReader);
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = this.viewListPattern.matcher(line);
            if (matcher.find() && matcher.groupCount() == 3 && (!onlyStarMarked || onlyStarMarked && matcher.group(1).equals("*"))) {
                String vob = matcher.group(2);
                int pos = Math.max(vob.lastIndexOf(92), vob.lastIndexOf(47));
                if (pos != -1) {
                    vob = vob.substring(pos + 1);
                }
                views.add(vob);
            }
            line = reader.readLine();
        }
        reader.close();
        return views;
    }

    private Pattern getListPattern() {
        if (this.viewListPattern == null) {
            this.viewListPattern = Pattern.compile("(.)\\s*(\\S*)\\s*(\\S*)");
        }
        return this.viewListPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mountVobs() throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mount");
        cmd.add("-all");
        try {
            this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        }
        catch (IOException ex) {
            this.logRedundantCleartoolError(cmd.toCommandArray(), (Exception)ex);
        }
        finally {
            baos.close();
        }
    }

    public String getViewUuid(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        cmd.add(new String[]{"-l", viewName});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String retString = "";
        Pattern uuidPattern = Pattern.compile("View uuid: (.*)");
        boolean res = true;
        IOException exception = null;
        try {
            res = this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        }
        catch (IOException ex) {
            exception = ex;
        }
        String output = this.getOutputString(baos);
        baos.close();
        if (exception != null && !output.contains("No matching entries found for view")) {
            throw exception;
        }
        if (res && exception == null) {
            String[] lines;
            for (String line : lines = output.split("\n")) {
                Matcher matcher = uuidPattern.matcher(line);
                if (!matcher.find() || matcher.groupCount() != 1) continue;
                retString = matcher.group(1);
                break;
            }
        }
        return retString;
    }

    public void rmviewtag(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmtag");
        cmd.add("-view");
        cmd.add(viewName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        if (builder.toString().contains("cleartool: Error")) {
            throw new IOException("Failed to remove view tag: " + builder.toString());
        }
    }

    public void unregisterView(String uuid) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("unregister");
        cmd.add("-view");
        cmd.add("-uuid");
        cmd.add(uuid);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        if (builder.toString().contains("cleartool: Error")) {
            throw new IOException("Failed to unregister view: " + builder.toString());
        }
    }

    public void rmviewUuid(String viewUuid) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add("-avobs");
        cmd.add("-uuid");
        cmd.add(viewUuid);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        if (builder.toString().contains("cleartool: Error")) {
            throw new IOException("Failed to remove view: " + builder.toString());
        }
    }

    private String getOutputString(ByteArrayOutputStream baos) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
        }
        reader.close();
        return builder.toString();
    }

    public void logRedundantCleartoolError(String[] cmd, Exception ex) {
        this.getLauncher().getListener().getLogger().println("Redundant Cleartool Error ");
        if (cmd != null) {
            this.getLauncher().getListener().getLogger().println("command: " + this.getLauncher().getCmdString(cmd));
        }
        this.getLauncher().getListener().getLogger().println(ex.getMessage());
    }
}

