/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import java.io.IOException;

public class UcmDynamicCheckoutAction
implements CheckOutAction {
    private ClearTool cleartool;
    private String stream;
    private boolean createDynView;

    public UcmDynamicCheckoutAction(ClearTool cleartool, String stream, boolean createDynView) {
        this.cleartool = cleartool;
        this.stream = stream;
        this.createDynView = createDynView;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        if (this.createDynView) {
            workspace.deleteContents();
            this.cleartool.mountVobs();
            String uuid = this.cleartool.getViewUuid(viewName);
            if (!uuid.equals("")) {
                this.cleartool.rmviewUuid(uuid);
                this.cleartool.unregisterView(uuid);
                this.cleartool.rmviewtag(viewName);
            }
            this.cleartool.mkview(viewName, this.stream);
        }
        this.cleartool.startView(viewName);
        this.cleartool.syncronizeViewWithStream(viewName, this.stream);
        return true;
    }
}

