/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import hudson.plugins.clearcase.util.PathUtil;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmSnapshotCheckoutAction
extends AbstractCheckoutAction {
    private ClearTool cleartool;
    private String stream;
    private String[] loadRules;
    private boolean useUpdate;

    public UcmSnapshotCheckoutAction(ClearTool cleartool, String stream, String[] loadRules, boolean useUpdate) {
        this.cleartool = cleartool;
        this.stream = stream;
        this.loadRules = loadRules;
        this.useUpdate = useUpdate;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        boolean localViewPathExists = new FilePath(workspace, viewName).exists();
        boolean viewTagExists = this.cleartool.doesViewExist(viewName);
        boolean updateLoadRules = true;
        if (localViewPathExists) {
            if (this.useUpdate) {
                String configSpec = PathUtil.convertPathForOS((String)this.cleartool.catcs(viewName), (Launcher)launcher);
                Set configSpecLoadRules = this.extractLoadRules(configSpec);
                if (this.configSpecNeedsUpdating(configSpecLoadRules)) {
                    String newConfigSpec = this.getLoadRuleFreeConfigSpec(configSpec) + "\n";
                    for (String loadRule : this.loadRules) {
                        if (!loadRule.startsWith("\\") && !loadRule.startsWith("/")) {
                            loadRule = PathUtil.fileSepForOS((boolean)launcher.isUnix()) + loadRule;
                        }
                        newConfigSpec = newConfigSpec + "load " + loadRule.trim() + "\n";
                    }
                    try {
                        this.cleartool.setcs(viewName, PathUtil.convertPathForOS((String)newConfigSpec, (Launcher)launcher));
                    }
                    catch (IOException e) {
                        launcher.getListener().fatalError(e.toString());
                        return false;
                    }
                    updateLoadRules = false;
                }
            } else {
                this.cleartool.rmview(viewName);
                this.cleartool.mkview(viewName, this.stream);
            }
        } else {
            if (viewTagExists) {
                launcher.getListener().fatalError("View path for " + viewName + " does not exist, but the view tag does.\n" + "View cannot be created - build aborting.");
                return false;
            }
            this.cleartool.mkview(viewName, this.stream);
        }
        if (updateLoadRules) {
            for (String loadRule : this.loadRules) {
                if (!loadRule.startsWith("\\") && !loadRule.startsWith("/")) {
                    loadRule = PathUtil.fileSepForOS((boolean)launcher.isUnix()) + loadRule;
                }
                try {
                    this.cleartool.update(viewName, loadRule.trim());
                }
                catch (IOException e) {
                    launcher.getListener().fatalError(e.toString());
                    return false;
                }
            }
        }
        return true;
    }

    private boolean configSpecNeedsUpdating(Set<String> configSpecLoadRules) {
        boolean recreate = false;
        for (String loadRule : this.loadRules) {
            if (configSpecLoadRules.contains(loadRule)) continue;
            System.out.println("Load rule: " + loadRule + " not found in current config spec, resetting config spec or recreating view");
            recreate = true;
        }
        return recreate;
    }
}

