/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.history.AbstractHistoryAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.ucm.UcmActivity;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmHistoryAction
extends AbstractHistoryAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%u", "%En", "%Vn", "%e", "%o", "%[activity]p"};
    private static final String[] ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u"};
    private static final String[] INTEGRATION_ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u", "%[contrib_acts]p"};
    private ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);

    public UcmHistoryAction(ClearTool cleartool, boolean useDynamicView, List<Filter> filters) {
        super(cleartool, useDynamicView, filters);
    }

    protected ClearToolFormatHandler getHistoryFormatHandler() {
        return this.historyHandler;
    }

    protected HistoryEntry parseEventLine(Matcher matcher, String line) throws ParseException {
        HistoryEntry entry = new HistoryEntry();
        entry.setLine(line);
        entry.setDateText(matcher.group(1));
        entry.setUser(matcher.group(2).trim());
        entry.setElement(matcher.group(3).trim());
        entry.setVersionId(matcher.group(4).trim());
        entry.setEvent(matcher.group(5).trim());
        entry.setOperation(matcher.group(6).trim());
        entry.setActivityName(matcher.group(7).trim());
        return entry;
    }

    protected List<? extends ChangeLogSet.Entry> buildChangelog(String viewName, List<HistoryEntry> entries) throws IOException, InterruptedException {
        ArrayList<UcmActivity> result = new ArrayList<UcmActivity>();
        HashMap<String, UcmActivity> activityMap = new HashMap<String, UcmActivity>();
        for (HistoryEntry entry : entries) {
            UcmActivity activity = (UcmActivity)activityMap.get(entry.getActivityName());
            if (activity == null) {
                activity = new UcmActivity();
                activity.setName(entry.getActivityName());
                activity.setUser(entry.getUser());
                activityMap.put(entry.getActivityName(), activity);
                result.add(activity);
            }
            UcmActivity.File currentFile = new UcmActivity.File();
            currentFile.setComment(entry.getComment());
            currentFile.setDate(entry.getDate());
            currentFile.setDateStr(entry.getDateText());
            currentFile.setEvent(entry.getEvent());
            currentFile.setName(entry.getElement());
            currentFile.setOperation(entry.getOperation());
            currentFile.setVersion(entry.getVersionId());
            activity.addFile(currentFile);
        }
        for (UcmActivity activity : result) {
            this.callLsActivity(activityMap, activity, viewName, 3);
        }
        return result;
    }

    private void callLsActivity(Map<String, UcmActivity> activityMap, UcmActivity activity, String viewname, int numberOfContributingActivitiesToFollow) throws IOException, InterruptedException {
        BufferedReader reader;
        String line;
        ClearToolFormatHandler handler = null;
        handler = activity.isIntegrationActivity() ? new ClearToolFormatHandler(INTEGRATION_ACTIVITY_FORMAT) : new ClearToolFormatHandler(ACTIVITY_FORMAT);
        Matcher matcher = handler.checkLine(line = (reader = new BufferedReader(this.cleartool.lsactivity(activity.getName(), handler.getFormat(), viewname))).readLine());
        if (matcher != null) {
            activity.setHeadline(matcher.group(1));
            activity.setStream(matcher.group(2));
            activity.setUser(matcher.group(3));
            if (activity.isIntegrationActivity() && numberOfContributingActivitiesToFollow > 0) {
                String contributingActivities = matcher.group(4);
                for (String contributing : contributingActivities.split(" ")) {
                    UcmActivity subActivity = null;
                    UcmActivity cachedActivity = activityMap.get(contributing);
                    if (cachedActivity == null) {
                        subActivity = new UcmActivity();
                        subActivity.setName(contributing);
                        this.callLsActivity(activityMap, subActivity, viewname, --numberOfContributingActivitiesToFollow);
                        activityMap.put(contributing, subActivity);
                    } else {
                        subActivity = new UcmActivity(cachedActivity);
                    }
                    activity.addSubActivity(subActivity);
                }
            }
        }
        reader.close();
    }
}

