/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.util.PathUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DynamicCheckoutAction
implements CheckOutAction {
    private ClearTool cleartool;
    private String configSpec;
    private boolean doNotUpdateConfigSpec;
    private boolean useTimeRule;
    private boolean createDynView;
    private String winDynStorageDir;
    private String unixDynStorageDir;

    public DynamicCheckoutAction(ClearTool cleartool, String configSpec, boolean doNotUpdateConfigSpec, boolean useTimeRule, boolean createDynView, String winDynStorageDir, String unixDynStorageDir) {
        this.cleartool = cleartool;
        this.configSpec = configSpec;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
        this.useTimeRule = useTimeRule;
        this.createDynView = createDynView;
        this.winDynStorageDir = winDynStorageDir;
        this.unixDynStorageDir = unixDynStorageDir;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        if (this.createDynView) {
            workspace.deleteContents();
            this.cleartool.mountVobs();
            String uuid = this.cleartool.getViewUuid(viewName);
            if (!uuid.equals("")) {
                try {
                    this.cleartool.rmviewUuid(uuid);
                }
                catch (Exception ex) {
                    this.cleartool.logRedundantCleartoolError(null, ex);
                }
                try {
                    this.cleartool.unregisterView(uuid);
                }
                catch (Exception ex) {
                    this.cleartool.logRedundantCleartoolError(null, ex);
                }
                this.cleartool.rmviewtag(viewName);
            }
            String dynStorageDir = this.cleartool.getLauncher().getLauncher().isUnix() ? this.unixDynStorageDir : this.winDynStorageDir;
            this.cleartool.mkview(viewName, null, dynStorageDir);
        }
        this.cleartool.startView(viewName);
        String currentConfigSpec = this.cleartool.catcs(viewName).trim();
        String tempConfigSpec = this.useTimeRule ? PathUtil.convertPathForOS("time " + this.getTimeRule() + "\n" + this.configSpec + "\nend time\n", launcher) : PathUtil.convertPathForOS(this.configSpec, launcher);
        if (!this.doNotUpdateConfigSpec) {
            if (!tempConfigSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                this.cleartool.setcs(viewName, tempConfigSpec);
            } else {
                this.cleartool.setcs(viewName, null);
            }
        }
        return true;
    }

    public String getTimeRule() {
        return this.getTimeRule(new Date());
    }

    public String getTimeRule(Date nowDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy.HH:mm:ss'UTC'Z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(nowDate).toLowerCase();
    }
}

