/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.history.DefaultFilter;
import hudson.plugins.clearcase.history.DestroySubBranchFilter;
import hudson.plugins.clearcase.history.FieldFilter;
import hudson.plugins.clearcase.history.FileFilter;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClearCaseScm
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    public static final String CLEARCASE_VIEWPATH_ENVSTR = "CLEARCASE_VIEWPATH";
    private final String viewName;
    private final String mkviewOptionalParam;
    private final boolean filteringOutDestroySubBranchEvent;
    private transient String normalizedViewName;
    private final boolean useUpdate;
    private final boolean removeViewOnRename;
    private String excludedRegions;
    private final String loadRules;
    private final boolean useDynamicView;
    private final String viewDrive;
    private int multiSitePollBuffer;
    private boolean createDynView;
    private String winDynStorageDir;
    private String unixDynStorageDir;

    protected void setNormalizedViewName(String normalizedViewName) {
        this.normalizedViewName = normalizedViewName;
    }

    protected String getNormalizedViewName() {
        return this.normalizedViewName;
    }

    public AbstractClearCaseScm(String viewName, String mkviewOptionalParam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions, boolean useDynamicView, String viewDrive, String loadRules, String multiSitePollBuffer, boolean createDynView, String winDynStorageDir, String unixDynStorageDir) {
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
        this.filteringOutDestroySubBranchEvent = filterOutDestroySubBranchEvent;
        this.useUpdate = useUpdate;
        this.removeViewOnRename = rmviewonrename;
        this.excludedRegions = excludedRegions;
        this.useDynamicView = useDynamicView;
        this.viewDrive = viewDrive;
        this.loadRules = loadRules;
        if (multiSitePollBuffer != null) {
            try {
                this.multiSitePollBuffer = DecimalFormat.getIntegerInstance().parse(multiSitePollBuffer).intValue();
            }
            catch (ParseException e) {
                this.multiSitePollBuffer = 0;
            }
        } else {
            this.multiSitePollBuffer = 0;
        }
        this.createDynView = createDynView;
        this.winDynStorageDir = winDynStorageDir;
        this.unixDynStorageDir = unixDynStorageDir;
    }

    protected abstract CheckOutAction createCheckOutAction(VariableResolver var1, ClearToolLauncher var2);

    protected abstract HistoryAction createHistoryAction(VariableResolver var1, ClearToolLauncher var2);

    protected abstract SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher var1);

    public abstract String[] getBranchNames();

    public String[] getViewPaths() {
        String[] rules = this.getLoadRules().split("[\\r\\n]+");
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i];
            if (rule.startsWith("load ")) {
                rule = rule.substring(5);
            }
            while (rule.startsWith("\\") || rule.startsWith("/")) {
                rule = rule.substring(1);
            }
            rules[i] = rule;
        }
        return rules;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public int getMultiSitePollBuffer() {
        return this.multiSitePollBuffer;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public boolean isCreateDynView() {
        return this.createDynView;
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.useDynamicView) {
            return new FilePath(workspace.getChannel(), this.viewDrive + File.separator + this.getNormalizedViewName());
        }
        if (this.getNormalizedViewName() == null) {
            return super.getModuleRoot(workspace);
        }
        return workspace.child(this.getNormalizedViewName());
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "${USER_NAME}_${JOB_NAME}_${NODE_NAME}_view";
        }
        return this.viewName;
    }

    public String getWinDynStorageDir() {
        return this.winDynStorageDir;
    }

    public String getNormalizedWinDynStorageDir(VariableResolver variableResolver) {
        String res = Util.replaceMacro((String)this.getWinDynStorageDir(), (VariableResolver)variableResolver);
        return res;
    }

    public String getUnixDynStorageDir() {
        return this.unixDynStorageDir;
    }

    public String getNormalizedUnixDynStorageDir(VariableResolver variableResolver) {
        String res = Util.replaceMacro((String)this.getUnixDynStorageDir(), (VariableResolver)variableResolver);
        return res;
    }

    public Computer getCurrentComputer() {
        return Computer.currentComputer();
    }

    public String generateNormalizedViewName(AbstractBuild<?, ?> build) {
        return this.generateNormalizedViewName(new BuildVariableResolver(build, this.getCurrentComputer()));
    }

    public String generateNormalizedViewName(BuildVariableResolver variableResolver) {
        String generatedNormalizedViewName = Util.replaceMacro((String)this.viewName, (VariableResolver)variableResolver);
        this.normalizedViewName = generatedNormalizedViewName = generatedNormalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
        return generatedNormalizedViewName;
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public boolean isFilteringOutDestroySubBranchEvent() {
        return this.filteringOutDestroySubBranchEvent;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.getNormalizedViewName() != null) {
            env.put(CLEARCASE_VIEWNAME_ENVSTR, this.getNormalizedViewName());
            String workspace = env.get("WORKSPACE");
            if (workspace != null) {
                env.put(CLEARCASE_VIEWPATH_ENVSTR, workspace + File.separator + this.getNormalizedViewName());
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List<? extends ChangeLogSet.Entry> changelogEntries;
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build, this.getCurrentComputer());
        CheckOutAction checkoutAction = this.createCheckOutAction(variableResolver, clearToolLauncher);
        HistoryAction historyAction = this.createHistoryAction(variableResolver, clearToolLauncher);
        SaveChangeLogAction saveChangeLogAction = this.createSaveChangeLogAction(clearToolLauncher);
        String normalizedViewName = this.generateNormalizedViewName(build);
        if (checkoutAction.checkout(launcher, workspace, normalizedViewName)) {
            changelogEntries = null;
            if (build.getPreviousBuild() != null) {
                Run prevBuild = build.getPreviousBuild();
                Date lastBuildTime = prevBuild.getTimestamp().getTime();
                if (this.getMultiSitePollBuffer() != 0) {
                    long lastBuildMilliSecs = prevBuild.getTimestamp().getTimeInMillis();
                    lastBuildTime = new Date(lastBuildMilliSecs - (long)(60000 * this.getMultiSitePollBuffer()));
                }
                changelogEntries = historyAction.getChanges(lastBuildTime, normalizedViewName, this.getBranchNames(), this.getViewPaths());
            }
            if (changelogEntries == null || changelogEntries.isEmpty()) {
                return this.createEmptyChangeLog(changelogFile, listener, "changelog");
            }
        } else {
            throw new AbortException();
        }
        saveChangeLogAction.saveChangeLog(changelogFile, changelogEntries);
        return true;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Date buildTime = lastBuild.getTimestamp().getTime();
        if (this.getMultiSitePollBuffer() != 0) {
            long lastBuildMilliSecs = lastBuild.getTimestamp().getTimeInMillis();
            buildTime = new Date(lastBuildMilliSecs - (long)(60000 * this.getMultiSitePollBuffer()));
        }
        BuildVariableResolver variableResolver = new BuildVariableResolver((AbstractBuild)lastBuild, this.getCurrentComputer());
        HistoryAction historyAction = this.createHistoryAction(variableResolver, this.createClearToolLauncher(listener, workspace, launcher));
        String normalizedViewName = this.generateNormalizedViewName((AbstractBuild)lastBuild);
        return historyAction.hasChanges(buildTime, normalizedViewName, this.getBranchNames(), this.getViewPaths());
    }

    protected ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
        return new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), listener, workspace, launcher);
    }

    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        return new ClearToolSnapshot(variableResolver, launcher, this.mkviewOptionalParam);
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) throws IOException, InterruptedException {
        StreamTaskListener listener = new StreamTaskListener(System.out);
        Launcher launcher = Hudson.getInstance().createLauncher((TaskListener)listener);
        ClearTool ct = this.createClearTool(null, this.createClearToolLauncher((TaskListener)listener, project.getSomeWorkspace().getParent().getParent(), launcher));
        try {
            String uuid = ct.getViewUuid(this.generateNormalizedViewName((AbstractBuild)project.getLastBuild()));
            ct.rmviewUuid(uuid);
            ct.unregisterView(uuid);
            ct.rmviewtag(this.generateNormalizedViewName((AbstractBuild)project.getLastBuild()));
        }
        catch (Exception e) {
            Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.WARNING, "Failed to remove ClearCase view", e);
        }
        return true;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public boolean isRemoveViewOnRename() {
        return this.removeViewOnRename;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    protected List<Filter> configureFilters(ClearToolLauncher ctLauncher) {
        String filterRegexp;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new DefaultFilter());
        String[] excludedStrings = this.getExcludedRegionsNormalized();
        if (excludedStrings != null && excludedStrings.length > 0) {
            for (String s : excludedStrings) {
                if (s.equals("")) continue;
                filters.add(new FileFilter(FieldFilter.Type.DoesNotContainRegxp, s));
            }
        }
        if (!(filterRegexp = AbstractClearCaseScm.getViewPathsRegexp(this.getViewPaths(), ctLauncher.getLauncher().isUnix())).equals("")) {
            filters.add(new FileFilter(FieldFilter.Type.ContainsRegxp, filterRegexp));
        }
        if (this.isFilteringOutDestroySubBranchEvent()) {
            filters.add(new DestroySubBranchFilter());
        }
        return filters;
    }

    public static String getViewPathsRegexp(String[] loadRules, boolean isUnix) {
        String tempFilterRules = "";
        String filterRegexp = "";
        for (String loadRule : loadRules) {
            if (loadRule.equals("")) continue;
            tempFilterRules = tempFilterRules + Pattern.quote(PathUtil.convertPathForOS(loadRule + "/", isUnix)) + "\n";
            tempFilterRules = tempFilterRules + Pattern.quote(PathUtil.convertPathForOS(loadRule, isUnix)) + "$\n";
        }
        if (!tempFilterRules.equals("")) {
            filterRegexp = "^(?:\\W?|\\w\\:\\\\)(" + tempFilterRules.trim().replaceAll("\\n", "|") + ")";
        }
        return filterRegexp;
    }

    public static class ItemListenerImpl
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            AbstractProject project = (AbstractProject)item;
            if (project.getScm() instanceof AbstractClearCaseScm && ((AbstractClearCaseScm)project.getScm()).isRemoveViewOnRename()) {
                this.onDeleted(item);
            }
        }

        public void onDeleted(Item item) {
            AbstractProject project;
            Hudson hudson = Hudson.getInstance();
            if (hudson == null) {
                Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.INFO, "Failed to get Hudson instance");
                return;
            }
            if (item instanceof AbstractProject && (project = (AbstractProject)item).getScm() instanceof AbstractClearCaseScm) {
                try {
                    String uuid;
                    AbstractClearCaseScm ccScm = (AbstractClearCaseScm)project.getScm();
                    StreamTaskListener listener = new StreamTaskListener(System.out);
                    Launcher launcher = Hudson.getInstance().createLauncher((TaskListener)listener);
                    ClearTool ct = ccScm.createClearTool(null, ccScm.createClearToolLauncher((TaskListener)listener, project.getSomeWorkspace().getParent().getParent(), launcher));
                    if (project.getLastBuild() != null && (uuid = ct.getViewUuid(ccScm.generateNormalizedViewName((AbstractBuild)project.getLastBuild()))) != null && !uuid.equals("")) {
                        ct.rmviewUuid(uuid);
                        ct.unregisterView(uuid);
                        ct.rmviewtag(ccScm.generateNormalizedViewName((AbstractBuild)project.getLastBuild()));
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.WARNING, "Failed to remove ClearCase view", e);
                }
            }
        }
    }
}

