/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamicUCM;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogParser;
import hudson.plugins.clearcase.ucm.UcmHistoryAction;
import hudson.plugins.clearcase.ucm.UcmSaveChangeLogAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.VariableResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private final String stream;
    private final String overrideBranchName;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions, String multiSitePollBuffer, String overrideBranchName, boolean createDynView) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, loadrules, multiSitePollBuffer, createDynView, "", "");
        this.stream = this.shortenStreamName(stream);
        this.overrideBranchName = overrideBranchName != null && !overrideBranchName.equals("") ? overrideBranchName : "";
    }

    @Deprecated
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename) {
        this(stream, loadrules, viewname, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, "", null, "", false);
    }

    public String getStream() {
        return this.stream;
    }

    public String getOverrideBranchName() {
        return this.overrideBranchName;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new UcmChangeLogParser();
    }

    public String[] getBranchNames() {
        if (!this.overrideBranchName.equals("")) {
            return new String[]{this.overrideBranchName};
        }
        String branch = this.stream;
        if (this.stream.contains("@")) {
            branch = this.stream.substring(0, this.stream.indexOf("@"));
        }
        return new String[]{branch};
    }

    protected CheckOutAction createCheckOutAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        CheckOutAction action = this.isUseDynamicView() ? new UcmDynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(), this.isCreateDynView()) : new UcmSnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(), this.getViewPaths(), this.isUseUpdate());
        return action;
    }

    protected HistoryAction createHistoryAction(VariableResolver variableResolver, ClearToolLauncher launcher) {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        UcmHistoryAction action = new UcmHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(launcher));
        try {
            String pwv = ct.pwv(this.generateNormalizedViewName((BuildVariableResolver)variableResolver));
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new UcmSaveChangeLogAction();
    }

    protected ClearTool createClearTool(VariableResolver variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamicUCM(variableResolver, launcher, this.getViewDrive(), this.getMkviewOptionalParam());
        }
        return super.createClearTool(variableResolver, launcher);
    }

    private String shortenStreamName(String longStream) {
        if (longStream.startsWith("stream:")) {
            return longStream.substring("stream:".length());
        }
        return longStream;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearCaseUcmScmDescriptor
    extends SCMDescriptor<ClearCaseUcmSCM>
    implements ModelObject {
        public ClearCaseUcmScmDescriptor() {
            super(ClearCaseUcmSCM.class, null);
            this.load();
        }

        public String getDefaultViewName() {
            return PluginImpl.BASE_DESCRIPTOR.getDefaultViewName();
        }

        public String getDisplayName() {
            return "UCM ClearCase";
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            return true;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ClearCaseUcmSCM scm = new ClearCaseUcmSCM(req.getParameter("ucm.stream"), req.getParameter("ucm.loadrules"), req.getParameter("ucm.viewname"), req.getParameter("ucm.usedynamicview") != null, req.getParameter("ucm.viewdrive"), req.getParameter("ucm.mkviewoptionalparam"), req.getParameter("ucm.filterOutDestroySubBranchEvent") != null, req.getParameter("ucm.useupdate") != null, req.getParameter("ucm.rmviewonrename") != null, req.getParameter("ucm.excludedRegions"), Util.fixEmpty((String)req.getParameter("ucm.multiSitePollBuffer")), req.getParameter("ucm.overrideBranchName"), req.getParameter("ucm.createDynView") != null);
            return scm;
        }
    }
}

