/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class ClearToolDynamicUCM
extends ClearToolExec {
    private transient String viewDrive;
    private String optionalMkviewParameters;

    public ClearToolDynamicUCM(VariableResolver variableResolver, ClearToolLauncher launcher, String viewDrive, String optionalMkviewParameters) {
        super(variableResolver, launcher);
        this.viewDrive = viewDrive;
        this.optionalMkviewParameters = optionalMkviewParameters;
    }

    protected FilePath getRootViewPath(ClearToolLauncher launcher) {
        return new FilePath(launcher.getWorkspace().getChannel(), this.viewDrive);
    }

    public void setcs(String viewName, String configSpec) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support setcs with a config spec");
    }

    public void syncronizeViewWithStream(String viewName, String stream) throws IOException, InterruptedException {
        this.setcs(viewName);
    }

    private void chstream(String viewName, String stream) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chstream");
        cmd.add("-generate");
        cmd.add("stream:" + stream);
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewName);
        this.launcher.run(cmd.toCommandArray(), null, null, viewPath);
    }

    private void setcs(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        cmd.add("-tag");
        cmd.add(viewName);
        cmd.add("-stream");
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void mkview(String viewName, String streamSelector) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkview");
        if (streamSelector != null) {
            cmd.add("-stream");
            cmd.add(streamSelector);
        }
        cmd.add("-tag");
        cmd.add(viewName);
        if (this.optionalMkviewParameters != null && this.optionalMkviewParameters.length() > 0) {
            String variabledResolvedParams = Util.replaceMacro((String)this.optionalMkviewParameters, (VariableResolver)this.variableResolver);
            cmd.addTokenized(variabledResolvedParams);
        }
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void mkview(String viewName, String streamSelector, String defaultStorageDir) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support mkview (String, String, String)");
    }

    public void rmview(String viewName) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support rmview");
    }

    public void rmviewtag(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmtag");
        cmd.add("-view");
        cmd.add(viewName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, baos, null);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        if (builder.toString().contains("cleartool: Error")) {
            throw new IOException("Failed to remove view tag: " + builder.toString());
        }
    }

    public void update(String viewName, String loadRules) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support update");
    }

    public void startView(String viewTags) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("startview");
        cmd.addTokenized(viewTags);
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }
}

