/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import hudson.plugins.clearcase.util.PathUtil;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotCheckoutAction
extends AbstractCheckoutAction {
    private final String configSpec;
    private final boolean useUpdate;
    private final ClearTool cleartool;
    private final String[] loadRules;

    public SnapshotCheckoutAction(ClearTool clearTool, String configSpec, String[] loadRules, boolean useUpdate) {
        this.cleartool = clearTool;
        this.configSpec = configSpec;
        this.loadRules = loadRules;
        this.useUpdate = useUpdate;
    }

    @Override
    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        boolean updateView = this.useUpdate;
        boolean localViewPathExists = new FilePath(workspace, viewName).exists();
        String jobConfigSpec = PathUtil.convertPathForOS(this.configSpec, launcher);
        boolean viewTagExists = this.cleartool.doesViewExist(viewName);
        if (localViewPathExists) {
            if (updateView) {
                Set<String> configSpecLoadRules;
                String currentConfigSpec = this.getLoadRuleFreeConfigSpec(this.cleartool.catcs(viewName).trim());
                if (!jobConfigSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                    updateView = false;
                }
                if (this.loadRulesNeedUpdating(configSpecLoadRules = this.extractLoadRules(this.cleartool.catcs(viewName).trim()))) {
                    updateView = false;
                }
            } else {
                this.cleartool.rmview(viewName);
                localViewPathExists = false;
                viewTagExists = false;
            }
        }
        if (!localViewPathExists) {
            if (viewTagExists) {
                launcher.getListener().fatalError("View path for " + viewName + " does not exist, but the view tag does.\n" + "View cannot be created - build aborting.");
                return false;
            }
            this.cleartool.mkview(viewName, null);
            updateView = false;
        }
        if (updateView) {
            try {
                this.cleartool.setcs(viewName, null);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        String newConfigSpec = jobConfigSpec + "\n";
        for (String loadRule : this.loadRules) {
            if (!loadRule.startsWith("\\") && !loadRule.startsWith("/")) {
                loadRule = PathUtil.fileSepForOS(launcher.isUnix()) + loadRule;
            }
            newConfigSpec = newConfigSpec + "load " + loadRule.trim() + "\n";
        }
        newConfigSpec = PathUtil.convertPathForOS(newConfigSpec, launcher);
        try {
            this.cleartool.setcs(viewName, PathUtil.convertPathForOS(newConfigSpec, launcher));
        }
        catch (IOException e) {
            launcher.getListener().fatalError(e.toString());
            return false;
        }
        return true;
    }

    private boolean loadRulesNeedUpdating(Set<String> configSpecLoadRules) {
        boolean recreate = false;
        for (String loadRule : this.loadRules) {
            if (configSpecLoadRules.contains(loadRule)) continue;
            System.out.println("Load rule: " + loadRule + " not found in current config spec, resetting config spec or recreating view");
            recreate = true;
        }
        return recreate;
    }
}

