/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import hudson.util.VariableResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildVariableResolver
implements VariableResolver<String> {
    private static final Logger LOGGER = Logger.getLogger(BuildVariableResolver.class.getName());
    private AbstractBuild<?, ?> build;
    private Computer computer;

    public BuildVariableResolver(AbstractBuild<?, ?> build, Computer computer) {
        this.build = build;
        this.computer = computer;
    }

    public String resolve(String key) {
        try {
            LogTaskListener ltl = new LogTaskListener(LOGGER, Level.INFO);
            if ("JOB_NAME".equals(key) && this.build != null && this.build.getProject() != null) {
                return this.build.getProject().getName();
            }
            if ("HOST".equals(key)) {
                return Util.fixEmpty((String)this.computer.getHostName());
            }
            if ("OS".equals(key)) {
                return System.getProperty("os.name");
            }
            if ("NODE_NAME".equals(key)) {
                return Util.fixEmpty((String)(StringUtils.isEmpty((String)this.computer.getName()) ? "master" : this.computer.getName()));
            }
            if ("USER_NAME".equals(key)) {
                return (String)this.computer.getSystemProperties().get("user.name");
            }
            EnvVars env = this.build.getEnvironment((TaskListener)ltl);
            if (env.containsKey((Object)key)) {
                return (String)env.get((Object)key);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Variable name '" + key + "' look up failed because of " + e);
        }
        return null;
    }
}

