/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseDataAction;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.history.DefaultFilter;
import hudson.plugins.clearcase.history.DestroySubBranchFilter;
import hudson.plugins.clearcase.history.FieldFilter;
import hudson.plugins.clearcase.history.FileFilter;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractClearCaseScm
extends SCM {
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    public static final String CLEARCASE_VIEWPATH_ENVSTR = "CLEARCASE_VIEWPATH";
    private String viewName;
    private final String mkviewOptionalParam;
    private final boolean filteringOutDestroySubBranchEvent;
    private transient ThreadLocal<String> normalizedViewName;
    private final boolean useUpdate;
    private final boolean removeViewOnRename;
    private String excludedRegions;
    private final String loadRules;
    private final boolean useDynamicView;
    private final String viewDrive;
    private int multiSitePollBuffer;
    private final boolean createDynView;
    private final String winDynStorageDir;
    private final String unixDynStorageDir;
    private final boolean freezeCode;
    private final boolean recreateView;

    private synchronized ThreadLocal<String> getNormalizedViewNameThreadLocalWrapper() {
        if (null == this.normalizedViewName) {
            this.normalizedViewName = new ThreadLocal();
        }
        return this.normalizedViewName;
    }

    protected void setNormalizedViewName(String normalizedViewName) {
        this.getNormalizedViewNameThreadLocalWrapper().set(normalizedViewName);
    }

    protected String getNormalizedViewName() {
        return (String)this.getNormalizedViewNameThreadLocalWrapper().get();
    }

    public AbstractClearCaseScm(String viewName, String mkviewOptionalParam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions, boolean useDynamicView, String viewDrive, String loadRules, String multiSitePollBuffer, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, boolean freezeCode, boolean recreateView) {
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
        this.filteringOutDestroySubBranchEvent = filterOutDestroySubBranchEvent;
        this.useUpdate = useUpdate;
        this.removeViewOnRename = rmviewonrename;
        this.excludedRegions = excludedRegions;
        this.useDynamicView = useDynamicView;
        this.viewDrive = viewDrive;
        this.loadRules = loadRules;
        if (multiSitePollBuffer != null) {
            try {
                this.multiSitePollBuffer = DecimalFormat.getIntegerInstance().parse(multiSitePollBuffer).intValue();
            }
            catch (ParseException e) {
                this.multiSitePollBuffer = 0;
            }
        } else {
            this.multiSitePollBuffer = 0;
        }
        this.createDynView = createDynView;
        this.winDynStorageDir = winDynStorageDir;
        this.unixDynStorageDir = unixDynStorageDir;
        this.freezeCode = freezeCode;
        this.recreateView = recreateView;
    }

    protected abstract CheckOutAction createCheckOutAction(VariableResolver<String> var1, ClearToolLauncher var2, AbstractBuild<?, ?> var3);

    protected abstract HistoryAction createHistoryAction(VariableResolver<String> var1, ClearToolLauncher var2, AbstractBuild<?, ?> var3);

    protected abstract SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher var1);

    public abstract String[] getBranchNames();

    public String[] getViewPaths() {
        if (this.getLoadRules().trim().length() == 0) {
            return null;
        }
        String[] rules = this.getLoadRules().split("[\\r\\n]+");
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i];
            if (rule.startsWith("load ")) {
                rule = rule.substring(5);
            }
            while (rule.startsWith("\\") || rule.startsWith("/")) {
                rule = rule.substring(1);
            }
            rules[i] = rule;
        }
        return rules;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public int getMultiSitePollBuffer() {
        return this.multiSitePollBuffer;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public boolean isCreateDynView() {
        return this.createDynView;
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        String normViewName = this.getNormalizedViewName();
        if (this.useDynamicView) {
            return new FilePath(workspace.getChannel(), this.viewDrive).child(normViewName);
        }
        if (normViewName == null) {
            return super.getModuleRoot(workspace);
        }
        return workspace.child(normViewName);
    }

    public String getViewName() {
        return StringUtils.defaultString((String)this.viewName, (String)"${USER_NAME}_${JOB_NAME}_${NODE_NAME}_view");
    }

    public String getWinDynStorageDir() {
        return this.winDynStorageDir;
    }

    public String getNormalizedWinDynStorageDir(VariableResolver<String> variableResolver) {
        return Util.replaceMacro((String)this.getWinDynStorageDir(), variableResolver);
    }

    public String getUnixDynStorageDir() {
        return this.unixDynStorageDir;
    }

    public String getNormalizedUnixDynStorageDir(VariableResolver<String> variableResolver) {
        return Util.replaceMacro((String)this.getUnixDynStorageDir(), variableResolver);
    }

    public boolean isFreezeCode() {
        return this.freezeCode;
    }

    public boolean isRecreateView() {
        return this.recreateView;
    }

    public Computer getCurrentComputer() {
        return Computer.currentComputer();
    }

    public Computer getBuildComputer(AbstractBuild<?, ?> build) {
        return build.getBuiltOn().toComputer();
    }

    public String generateNormalizedViewName(AbstractBuild<?, ?> build) {
        return this.generateNormalizedViewName((VariableResolver)new BuildVariableResolver(build, this.getCurrentComputer()));
    }

    public String generateNormalizedViewName(VariableResolver<String> variableResolver, String modViewName) {
        String generatedNormalizedViewName = Util.replaceMacro((String)modViewName, variableResolver);
        generatedNormalizedViewName = generatedNormalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
        this.setNormalizedViewName(generatedNormalizedViewName);
        return generatedNormalizedViewName;
    }

    public String generateNormalizedViewName(VariableResolver<String> variableResolver) {
        return this.generateNormalizedViewName(variableResolver, this.viewName);
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public boolean isFilteringOutDestroySubBranchEvent() {
        return this.filteringOutDestroySubBranchEvent;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        if (this.getNormalizedViewName() != null) {
            env.put("CLEARCASE_VIEWNAME", this.getNormalizedViewName());
            String workspace = env.get("WORKSPACE");
            if (workspace != null) {
                env.put("CLEARCASE_VIEWPATH", workspace + File.separator + this.getNormalizedViewName());
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List changelogEntries;
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build, this.getCurrentComputer());
        CheckOutAction checkoutAction = this.createCheckOutAction((VariableResolver)variableResolver, clearToolLauncher, build);
        HistoryAction historyAction = this.createHistoryAction((VariableResolver)variableResolver, clearToolLauncher, build);
        SaveChangeLogAction saveChangeLogAction = this.createSaveChangeLogAction(clearToolLauncher);
        String coNormalizedViewName = this.generateNormalizedViewName(build);
        build.addAction((Action)new ClearCaseDataAction());
        if (checkoutAction.checkout(launcher, workspace, coNormalizedViewName)) {
            changelogEntries = null;
            if (build.getPreviousBuild() != null) {
                Run prevBuild = build.getPreviousBuild();
                Date lastBuildTime = this.getBuildTime(prevBuild);
                changelogEntries = historyAction.getChanges(lastBuildTime, coNormalizedViewName, this.getBranchNames(), this.getViewPaths());
            }
            if (CollectionUtils.isEmpty(changelogEntries)) {
                return this.createEmptyChangeLog(changelogFile, listener, "changelog");
            }
        } else {
            throw new AbortException();
        }
        saveChangeLogAction.saveChangeLog(changelogFile, changelogEntries);
        return true;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Date buildTime = this.getBuildTime(lastBuild);
        BuildVariableResolver variableResolver = new BuildVariableResolver((AbstractBuild)lastBuild, this.getBuildComputer((AbstractBuild)lastBuild));
        HistoryAction historyAction = this.createHistoryAction((VariableResolver)variableResolver, this.createClearToolLauncher(listener, workspace, launcher), (AbstractBuild)lastBuild);
        String poNormalizedViewName = this.generateNormalizedViewName((VariableResolver)variableResolver);
        return historyAction.hasChanges(buildTime, poNormalizedViewName, this.getBranchNames(), this.getViewPaths());
    }

    private Date getBuildTime(Run<?, ?> lastBuild) {
        Date buildTime = lastBuild.getTimestamp().getTime();
        if (this.getMultiSitePollBuffer() != 0) {
            long lastBuildMilliSecs = lastBuild.getTimestamp().getTimeInMillis();
            buildTime = new Date(lastBuildMilliSecs - (long)(60000 * this.getMultiSitePollBuffer()));
        }
        return buildTime;
    }

    protected ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
        return new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), listener, workspace, launcher);
    }

    protected ClearTool createClearTool(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        return new ClearToolSnapshot(variableResolver, launcher, this.mkviewOptionalParam);
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) throws IOException, InterruptedException {
        StreamTaskListener listener = new StreamTaskListener(System.out);
        Launcher launcher = node.createLauncher((TaskListener)listener);
        ClearTool ct = this.createClearTool(null, this.createClearToolLauncher((TaskListener)listener, project.getSomeWorkspace().getParent().getParent(), launcher));
        try {
            ct.rmviewtag(this.generateNormalizedViewName((AbstractBuild)project.getLastBuild()));
        }
        catch (Exception e) {
            Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.WARNING, "Failed to remove ClearCase view", e);
        }
        return true;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public boolean isRemoveViewOnRename() {
        return this.removeViewOnRename;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    public List<Filter> configureFilters(ClearToolLauncher ctLauncher) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add((Filter)new DefaultFilter());
        String[] excludedStrings = this.getExcludedRegionsNormalized();
        if (excludedStrings != null && excludedStrings.length > 0) {
            for (String s : excludedStrings) {
                if (s.equals("")) continue;
                filters.add((Filter)new FileFilter(FieldFilter.Type.DoesNotContainRegxp, s));
            }
        }
        String filterRegexp = "";
        if (this.getViewPaths() != null) {
            filterRegexp = AbstractClearCaseScm.getViewPathsRegexp((String[])this.getViewPaths(), (boolean)ctLauncher.getLauncher().isUnix());
        }
        if (!filterRegexp.equals("")) {
            filters.add((Filter)new FileFilter(FieldFilter.Type.ContainsRegxp, filterRegexp));
        }
        if (this.isFilteringOutDestroySubBranchEvent()) {
            filters.add((Filter)new DestroySubBranchFilter());
        }
        return filters;
    }

    public static String getViewPathsRegexp(String[] loadRules, boolean isUnix) {
        String tempFilterRules = "";
        String filterRegexp = "";
        for (String loadRule : loadRules) {
            if (loadRule.equals("")) continue;
            if (loadRule.endsWith("/")) {
                loadRule = loadRule.substring(0, loadRule.lastIndexOf("/"));
            }
            if (loadRule.endsWith("\\")) {
                loadRule = loadRule.substring(0, loadRule.lastIndexOf("\\"));
            }
            tempFilterRules = tempFilterRules + Pattern.quote(PathUtil.convertPathForOS((String)(loadRule + "/"), (boolean)isUnix)) + "\n";
            tempFilterRules = tempFilterRules + Pattern.quote(PathUtil.convertPathForOS((String)loadRule, (boolean)isUnix)) + "$\n";
        }
        if (!tempFilterRules.equals("")) {
            filterRegexp = "^(?:\\W?|\\w\\:\\\\)(" + tempFilterRules.trim().replaceAll("\\n", "|") + ")";
        }
        return filterRegexp;
    }
}

