/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamicUCM;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogParser;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.plugins.clearcase.ucm.UcmHistoryAction;
import hudson.plugins.clearcase.ucm.UcmSaveChangeLogAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.util.VariableResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private static final String STREAM_PREFIX = "stream:";
    private static final String AUTO_ALLOCATE_VIEW_NAME = "${STREAM}_${JOB_NAME}_bs_hudson_view";
    private final String stream;
    private String paramStream;
    private final String overrideBranchName;
    private boolean allocateViewName;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions, String multiSitePollBuffer, String overrideBranchName, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, boolean freezeCode, boolean recreateView, boolean allocateViewName) {
        super(viewname, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, loadrules, multiSitePollBuffer, createDynView, winDynStorageDir, unixDynStorageDir, freezeCode, recreateView);
        this.stream = this.shortenStreamName(stream);
        this.allocateViewName = allocateViewName;
        this.paramStream = "";
        this.overrideBranchName = overrideBranchName;
    }

    @Deprecated
    public ClearCaseUcmSCM(String stream, String loadrules, String viewname, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename) {
        this(stream, loadrules, viewname, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, "", null, "", false, null, null, false, false, false);
    }

    public String getStream() {
        return StringUtils.defaultIfEmpty((String)this.paramStream, (String)this.stream);
    }

    public boolean isAllocateViewName() {
        return this.allocateViewName;
    }

    public void setAllocateViewName(boolean allocateViewName) {
        this.allocateViewName = allocateViewName;
    }

    public String getOverrideBranchName() {
        return this.overrideBranchName;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new UcmChangeLogParser();
    }

    public String[] getBranchNames() {
        if (StringUtils.isNotEmpty((String)this.overrideBranchName)) {
            return new String[]{this.overrideBranchName};
        }
        String branch = this.getStream();
        int indexOfAt = branch.indexOf("@");
        if (indexOfAt > -1) {
            branch = branch.substring(0, indexOfAt);
        }
        return new String[]{branch};
    }

    public String generateNormalizedViewName(VariableResolver<String> variableResolver, String modViewName) {
        if (this.allocateViewName) {
            modViewName = AUTO_ALLOCATE_VIEW_NAME.replace("${STREAM}", UcmCommon.getNoVob((String)this.getStream()));
        }
        return super.generateNormalizedViewName(variableResolver, modViewName);
    }

    protected CheckOutAction createCheckOutAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) {
        this.paramStream = (String)build.getBuildVariables().get("STREAM");
        Object action = this.isUseDynamicView() ? new UcmDynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(), this.isCreateDynView(), this.getNormalizedWinDynStorageDir(variableResolver), this.getNormalizedUnixDynStorageDir(variableResolver), build, this.isFreezeCode(), this.isRecreateView()) : new UcmSnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(), this.getViewPaths(), this.isUseUpdate());
        return action;
    }

    protected HistoryAction createHistoryAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        UcmHistoryAction action = new UcmHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(launcher), this.getStream(), this.getViewDrive(), build, this.isFreezeCode());
        try {
            String pwv = ct.pwv(this.generateNormalizedViewName((VariableResolver)((BuildVariableResolver)variableResolver)));
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new UcmSaveChangeLogAction();
    }

    protected ClearTool createClearTool(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamicUCM(variableResolver, launcher, this.getViewDrive(), this.getMkviewOptionalParam());
        }
        return super.createClearTool(variableResolver, launcher);
    }

    private String shortenStreamName(String longStream) {
        if (longStream.startsWith(STREAM_PREFIX)) {
            return longStream.substring(STREAM_PREFIX.length());
        }
        return longStream;
    }
}

