/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.plugins.clearcase.ClearCaseDataAction;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.ucm.UcmCommon;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

/*
 * Exception performing whole class analysis ignored.
 */
public class UcmDynamicCheckoutAction
implements CheckOutAction {
    private static final String CONFIGURED_STREAM_VIEW_SUFFIX = "_hudson_view";
    private static final String BUILD_STREAM_PREFIX = "hudson_stream.";
    private static final String BASELINE_NAME = "hudson_co_";
    private static final String BASELINE_COMMENT = "hudson_co_";
    private ClearTool cleartool;
    private String stream;
    private boolean createDynView;
    private String winDynStorageDir;
    private String unixDynStorageDir;
    private AbstractBuild build;
    private boolean freezeCode;
    private boolean recreateView;

    public UcmDynamicCheckoutAction(ClearTool cleartool, String stream, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, AbstractBuild build, boolean freezeCode, boolean recreateView) {
        this.cleartool = cleartool;
        this.stream = stream;
        this.createDynView = createDynView;
        this.winDynStorageDir = winDynStorageDir;
        this.unixDynStorageDir = unixDynStorageDir;
        this.build = build;
        this.freezeCode = freezeCode;
        this.recreateView = recreateView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        ClearCaseDataAction dataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (dataAction != null) {
            AbstractProject abstractProject = this.build.getProject();
            synchronized (abstractProject) {
                dataAction.setStream(this.stream);
            }
        }
        if (this.createDynView) {
            if (this.freezeCode) {
                this.checkoutCodeFreeze(viewName);
            } else {
                this.cleartool.mountVobs();
                this.recreateView(viewName);
                this.cleartool.startView(viewName);
                this.cleartool.syncronizeViewWithStream(viewName, this.stream);
            }
        } else {
            this.cleartool.startView(viewName);
            this.cleartool.syncronizeViewWithStream(viewName, this.stream);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkoutCodeFreeze(String viewName) throws IOException, InterruptedException {
        AbstractProject abstractProject = this.build.getProject();
        synchronized (abstractProject) {
            ClearCaseDataAction clearcaseDataAction = null;
            for (Run previousBuild = this.build.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
                clearcaseDataAction = (ClearCaseDataAction)previousBuild.getAction(ClearCaseDataAction.class);
                if (!previousBuild.isBuilding() || clearcaseDataAction == null || !clearcaseDataAction.getStream().equals(this.stream)) continue;
                throw new IOException("Can't run build on stream " + this.stream + " when build " + previousBuild.getNumber() + " is currently running on the same stream.");
            }
        }
        this.prepareBuildStreamAndViews(viewName, this.stream);
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy_HH_mm_ss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStr = formatter.format(this.build.getTimestamp().getTime()).toLowerCase();
        UcmCommon.makeBaseline((ClearToolLauncher)this.cleartool.getLauncher(), (boolean)true, (String)this.getConfiguredStreamViewName(), null, (String)("hudson_co_" + dateStr), (String)("hudson_co_" + dateStr), (boolean)false, (boolean)false, null);
        List latestBlsOnConfgiuredStream = UcmCommon.getLatestBlsWithCompOnStream((ClearToolLauncher)this.cleartool.getLauncher(), (String)this.stream, (String)this.getConfiguredStreamViewName());
        for (UcmCommon.BaselineDesc baseLineDesc : latestBlsOnConfgiuredStream) {
            if (!baseLineDesc.isNotLabeled() || !baseLineDesc.getComponentDesc().isModifiable()) continue;
            ArrayList<String> readWriteCompList = new ArrayList<String>();
            readWriteCompList.add(baseLineDesc.getComponentDesc().getName());
            List baseLineDescList = UcmCommon.makeBaseline((ClearToolLauncher)this.cleartool.getLauncher(), (boolean)true, (String)this.getConfiguredStreamViewName(), null, (String)("hudson_co_" + dateStr), (String)("hudson_co_" + dateStr), (boolean)true, (boolean)false, readWriteCompList);
            String newBaseline = ((UcmCommon.BaselineDesc)baseLineDescList.get(0)).getBaselineName() + "@" + UcmCommon.getVob((String)baseLineDesc.getComponentDesc().getName());
            baseLineDesc.setBaselineName(newBaseline);
        }
        UcmCommon.rebase((ClearToolLauncher)this.cleartool.getLauncher(), (String)viewName, (List)latestBlsOnConfgiuredStream);
        ClearCaseDataAction dataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (dataAction != null) {
            dataAction.setLatestBlsOnConfiguredStream(latestBlsOnConfgiuredStream);
        }
        return true;
    }

    private void prepareBuildStreamAndViews(String viewName, String stream) throws IOException, InterruptedException {
        this.cleartool.mountVobs();
        String uuid = this.cleartool.getViewData(this.getConfiguredStreamViewName()).getProperty("UUID");
        if (uuid == null || uuid.equals("")) {
            String dynStorageDir = this.cleartool.getLauncher().getLauncher().isUnix() ? this.unixDynStorageDir : this.winDynStorageDir;
            this.cleartool.mkview(this.getConfiguredStreamViewName(), stream, dynStorageDir);
        }
        this.cleartool.startView(this.getConfiguredStreamViewName());
        if (!UcmCommon.isStreamExists((ClearToolLauncher)this.cleartool.getLauncher(), (String)this.getBuildStream())) {
            UcmCommon.mkstream((ClearToolLauncher)this.cleartool.getLauncher(), (String)stream, (String)this.getBuildStream());
        }
        this.recreateView(viewName);
    }

    private void recreateView(String viewName) throws IOException, InterruptedException {
        Properties viewDataPrp = this.cleartool.getViewData(viewName);
        String uuid = viewDataPrp.getProperty("UUID");
        String storageDir = viewDataPrp.getProperty("STORAGE_DIR");
        if (uuid != null && !uuid.equals("") && this.recreateView) {
            try {
                this.cleartool.endView(viewName);
            }
            catch (Exception ex) {
                this.cleartool.logRedundantCleartoolError(null, ex);
            }
            try {
                this.cleartool.rmviewUuid(uuid);
            }
            catch (Exception ex) {
                this.cleartool.logRedundantCleartoolError(null, ex);
            }
            try {
                this.cleartool.unregisterView(uuid);
            }
            catch (Exception ex) {
                this.cleartool.logRedundantCleartoolError(null, ex);
            }
            try {
                FilePath storageDirFile = new FilePath(this.build.getWorkspace().getChannel(), storageDir);
                storageDirFile.deleteRecursive();
            }
            catch (Exception ex) {
                this.cleartool.logRedundantCleartoolError(null, ex);
            }
        }
        if (this.recreateView) {
            try {
                this.cleartool.rmviewtag(viewName);
            }
            catch (Exception ex) {
                this.cleartool.logRedundantCleartoolError(null, ex);
            }
        }
        if (this.recreateView || uuid == null || uuid.equals("")) {
            String dynStorageDir = this.cleartool.getLauncher().getLauncher().isUnix() ? this.unixDynStorageDir : this.winDynStorageDir;
            this.cleartool.mkview(viewName, this.getBuildStream(), dynStorageDir);
        }
    }

    public static String getConfiguredStreamViewName(String jobName, String stream) {
        jobName = jobName.replace(" ", "");
        return UcmCommon.getNoVob((String)stream) + "_" + jobName + "_" + "_hudson_view";
    }

    private String getConfiguredStreamViewName() {
        return UcmDynamicCheckoutAction.getConfiguredStreamViewName((String)this.build.getProject().getName(), (String)this.stream);
    }

    private String getBuildStream() {
        String jobName = this.build.getProject().getName().replace(" ", "");
        return "hudson_stream." + jobName + "." + this.stream;
    }
}

