/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.FilePath;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class UcmCommon {
    public static List<BaselineDesc> makeBaseline(ClearToolLauncher clearToolLauncher, boolean isUseDynamicView, String viewName, FilePath filePath, String baselineName, String baselineComment, boolean identical, boolean fullBaseline, List<String> readWriteComponents) throws IOException, InterruptedException {
        ArrayList<BaselineDesc> createdBaselinesList = new ArrayList<BaselineDesc>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkbl");
        if (identical) {
            cmd.add("-identical");
        }
        cmd.add("-comment");
        cmd.add(baselineComment);
        if (fullBaseline) {
            cmd.add("-full");
        } else {
            cmd.add("-incremental");
        }
        FilePath clearToolLauncherPath = filePath;
        if (isUseDynamicView) {
            cmd.add("-view");
            cmd.add(viewName);
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        if (readWriteComponents != null) {
            cmd.add("-comp");
            StringBuffer lstComp = new StringBuffer();
            for (String comp : readWriteComponents) {
                lstComp.append(",");
                lstComp.append(comp);
            }
            lstComp.delete(0, 1);
            cmd.add(lstComp.toString());
        }
        cmd.add(baselineName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            throw new IOException("Failed to make baseline, reason: " + cleartoolResult);
        }
        Pattern pattern = Pattern.compile("Created baseline \".+?\" .+? \".+?\"");
        Matcher matcher = pattern.matcher(cleartoolResult);
        while (matcher.find()) {
            String match = matcher.group();
            String[] parts = match.split("\"");
            String newBaseline = parts[1];
            String componentName = parts[3];
            createdBaselinesList.add(new BaselineDesc(newBaseline, componentName));
        }
        return createdBaselinesList;
    }

    public static List<String> getLatestBaselineNames(ClearToolLauncher clearToolLauncher, boolean isUseDynamicView, String viewName, FilePath filePath, List<String> readWriteComponents) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        FilePath clearToolLauncherPath = filePath;
        ArrayList<String> baselineNames = new ArrayList<String>();
        cmd.add("lsstream");
        if (isUseDynamicView) {
            cmd.add("-view");
            cmd.add(viewName);
            clearToolLauncherPath = clearToolLauncher.getWorkspace();
        }
        cmd.add("-fmt");
        cmd.add("%[latest_bls]Xp");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        String prefix = "baseline:";
        if (cleartoolResult != null && cleartoolResult.startsWith(prefix)) {
            String[] baselineNamesSplit;
            for (String baselineName : baselineNamesSplit = cleartoolResult.split("baseline:")) {
                String baselineNameTrimmed = baselineName.trim();
                if (baselineNameTrimmed.equals("")) continue;
                String blComp = UcmCommon.getDataforBaseline((ClearToolLauncher)clearToolLauncher, (FilePath)filePath, (String)baselineNameTrimmed).getBaselineName();
                if (readWriteComponents != null && !readWriteComponents.contains(blComp)) continue;
                baselineNames.add(baselineNameTrimmed);
            }
        }
        return baselineNames;
    }

    public static List<BaselineDesc> getComponentsForBaselines(ClearToolLauncher clearToolLauncher, List<ComponentDesc> componentsList, boolean isUseDynamicView, String viewName, FilePath filePath, List<String> baselinesNames) throws InterruptedException, IOException {
        ArrayList<BaselineDesc> baselinesDescList = new ArrayList<BaselineDesc>();
        for (String blName : baselinesNames) {
            BaselineDesc baseLineDesc = UcmCommon.getDataforBaseline((ClearToolLauncher)clearToolLauncher, (FilePath)filePath, (String)blName);
            ComponentDesc matchComponentDesc = null;
            for (ComponentDesc componentDesc : componentsList) {
                if (!UcmCommon.getNoVob((String)componentDesc.getName()).equals(UcmCommon.getNoVob((String)baseLineDesc.getComponentName()))) continue;
                matchComponentDesc = componentDesc;
                break;
            }
            baselinesDescList.add(new BaselineDesc(blName, matchComponentDesc, BaselineDesc.access$000((BaselineDesc)baseLineDesc)));
        }
        return baselinesDescList;
    }

    public static BaselineDesc getDataforBaseline(ClearToolLauncher clearToolLauncher, FilePath filePath, String blName) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        FilePath clearToolLauncherPath = filePath;
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[label_status]p|%[component]Xp");
        cmd.add(blName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        String[] arr = cleartoolResult.split("\\|");
        boolean isNotLabeled = arr[0].contains("Not Labeled");
        String prefix = "component:";
        String componentName = arr[1].substring(cleartoolResult.indexOf(cleartoolResult) + prefix.length());
        return new BaselineDesc(componentName, isNotLabeled);
    }

    public static void mkstream(ClearToolLauncher clearToolLauncher, String parentStream, String childStream) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkstream");
        cmd.add("-in");
        cmd.add(parentStream);
        cmd.add(childStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        baos.close();
    }

    public static boolean isStreamExists(ClearToolLauncher clearToolLauncher, String stream) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-short");
        cmd.add(stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        baos.close();
        String cleartoolResult = baos.toString();
        return !cleartoolResult.contains("stream not found");
    }

    public static List<ComponentDesc> getStreamComponentsDesc(ClearToolLauncher clearToolLauncher, String streamName) throws IOException, InterruptedException {
        ArrayList<ComponentDesc> componentsDescList = new ArrayList<ComponentDesc>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("desc");
        cmd.add("stream:" + streamName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        baos.close();
        String cleartoolResult = baos.toString();
        int idx = 0;
        String searchFor = "modifiable)";
        while (idx >= 0) {
            if ((idx = cleartoolResult.indexOf(searchFor, idx + 1)) <= 0) continue;
            int idx1 = cleartoolResult.lastIndexOf("(", idx - 1);
            int idx2 = cleartoolResult.indexOf(")", idx1);
            String componentState = cleartoolResult.substring(idx1 + 1, idx2);
            idx1 = cleartoolResult.lastIndexOf("(", idx1 - 1);
            idx2 = cleartoolResult.indexOf(")", idx1);
            ComponentDesc componentDesc = new ComponentDesc(cleartoolResult.substring(idx1 + 1, idx2), componentState.equals("modifiable"));
            componentsDescList.add(componentDesc);
        }
        return componentsDescList;
    }

    public static List<BaselineDesc> getLatestBlsWithCompOnStream(ClearToolLauncher clearToolLauncher, String stream, String view) throws IOException, InterruptedException {
        List componentsList = UcmCommon.getStreamComponentsDesc((ClearToolLauncher)clearToolLauncher, (String)stream);
        List latestBlsOnBuildStream = UcmCommon.getLatestBaselineNames((ClearToolLauncher)clearToolLauncher, (boolean)true, (String)view, null, null);
        List latestBlsWithComp = UcmCommon.getComponentsForBaselines((ClearToolLauncher)clearToolLauncher, (List)componentsList, (boolean)true, (String)view, null, (List)latestBlsOnBuildStream);
        return latestBlsWithComp;
    }

    public static List<String> getReadWriteComponents(List<ComponentDesc> componentsDesc) {
        ArrayList<String> res = new ArrayList<String>();
        for (ComponentDesc comp : componentsDesc) {
            res.add(comp.getName());
        }
        return res;
    }

    public static List<String> getDiffBlVersions(ClearToolLauncher clearToolLauncher, String viewRootDirectory, String bl1, String bl2) throws IOException, InterruptedException {
        String[] arr;
        ArrayList<String> versionList = new ArrayList<String>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        FilePath clearToolLauncherPath = new FilePath(clearToolLauncher.getLauncher().getChannel(), viewRootDirectory);
        cmd.add("diffbl");
        cmd.add("-versions");
        cmd.add(bl1);
        cmd.add(bl2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, clearToolLauncherPath);
        baos.close();
        String cleartoolResult = baos.toString();
        for (String line : arr = cleartoolResult.split("\n")) {
            if (!line.startsWith(">>")) continue;
            line = line.replaceAll(">>", "");
            versionList.add(line.trim());
        }
        return versionList;
    }

    public static String getVersionDescription(ClearToolLauncher clearToolLauncher, String version, String format) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("desc");
        cmd.add("-fmt");
        cmd.add(format);
        cmd.add(version);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        baos.close();
        String cleartoolResult = baos.toString();
        return cleartoolResult;
    }

    public static void rebase(ClearToolLauncher clearToolLauncher, String viewName, List<BaselineDesc> baselines) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rebase");
        cmd.add("-base");
        String baselineStr = "";
        for (BaselineDesc bl : baselines) {
            if (baselineStr.length() > 0) {
                baselineStr = baselineStr + ",";
            }
            baselineStr = baselineStr + bl.getBaselineName();
        }
        cmd.add(baselineStr);
        cmd.add("-view");
        cmd.add(viewName);
        cmd.add("-complete");
        cmd.add("-force");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        baos.close();
    }

    public static String getNoVob(String element) {
        return element.split("@")[0];
    }

    public static String getVob(String element) {
        return element.split("@")[1];
    }
}

