/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.clearcase.ClearCaseDataAction;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.history.AbstractHistoryAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.ucm.UcmActivity;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmHistoryAction
extends AbstractHistoryAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%u", "%En", "%Vn", "%e", "%o", "%[activity]p"};
    private static final String[] ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u"};
    private static final String[] INTEGRATION_ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u", "%[contrib_acts]p"};
    private static final String BASELINE_NAME = "hudson_poll_";
    private static final String BASELINE_COMMENT = "hudson_poll_";
    private ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);
    private String stream;
    private String viewDrive;
    private AbstractBuild<?, ?> build;
    private boolean freezeCode;

    public UcmHistoryAction(ClearTool cleartool, boolean useDynamicView, List<Filter> filters, String stream, String viewDrive, AbstractBuild<?, ?> build, boolean freezeCode) {
        super(cleartool, useDynamicView, filters);
        this.stream = stream;
        this.viewDrive = viewDrive;
        this.build = build;
        this.freezeCode = freezeCode;
    }

    protected ClearToolFormatHandler getHistoryFormatHandler() {
        return this.historyHandler;
    }

    public boolean hasChanges(Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        if (this.freezeCode) {
            return this.hasChangesCodeFreeze();
        }
        return super.hasChanges(time, viewName, branchNames, viewPaths);
    }

    public List<? extends ChangeLogSet.Entry> getChanges(Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        if (this.freezeCode) {
            List entries = this.getChangesCodeFreeze();
            List filtered = this.filterEntries(entries);
            List changelog = this.buildChangelog(viewName, filtered);
            return changelog;
        }
        return super.getChanges(time, viewName, branchNames, viewPaths);
    }

    protected HistoryEntry parseEventLine(Matcher matcher, String line) throws ParseException {
        HistoryEntry entry = new HistoryEntry();
        entry.setLine(line);
        entry.setDateText(matcher.group(1));
        entry.setUser(matcher.group(2).trim());
        entry.setElement(matcher.group(3).trim());
        entry.setVersionId(matcher.group(4).trim());
        entry.setEvent(matcher.group(5).trim());
        entry.setOperation(matcher.group(6).trim());
        entry.setActivityName(matcher.group(7).trim());
        return entry;
    }

    protected List<? extends ChangeLogSet.Entry> buildChangelog(String viewName, List<HistoryEntry> entries) throws IOException, InterruptedException {
        ArrayList<UcmActivity> result = new ArrayList<UcmActivity>();
        HashMap<String, UcmActivity> activityMap = new HashMap<String, UcmActivity>();
        for (HistoryEntry entry : entries) {
            UcmActivity activity = (UcmActivity)activityMap.get(entry.getActivityName());
            if (activity == null) {
                activity = new UcmActivity();
                activity.setName(entry.getActivityName());
                activity.setUser(entry.getUser());
                activityMap.put(entry.getActivityName(), activity);
                result.add(activity);
            }
            UcmActivity.File currentFile = new UcmActivity.File();
            currentFile.setComment(entry.getComment());
            currentFile.setDate(entry.getDate());
            currentFile.setDateStr(entry.getDateText());
            currentFile.setEvent(entry.getEvent());
            currentFile.setName(entry.getElement());
            currentFile.setOperation(entry.getOperation());
            currentFile.setVersion(entry.getVersionId());
            activity.addFile(currentFile);
        }
        for (UcmActivity activity : result) {
            this.callLsActivity(activityMap, activity, viewName, 3);
        }
        return result;
    }

    private void callLsActivity(Map<String, UcmActivity> activityMap, UcmActivity activity, String viewname, int numberOfContributingActivitiesToFollow) throws IOException, InterruptedException {
        ClearToolFormatHandler handler = null;
        handler = activity.isIntegrationActivity() ? new ClearToolFormatHandler(INTEGRATION_ACTIVITY_FORMAT) : new ClearToolFormatHandler(ACTIVITY_FORMAT);
        if (activity.getName() == null || activity.getName().trim().length() == 0) {
            activity.setName("Unable to get activity name");
            return;
        }
        BufferedReader reader = new BufferedReader(this.cleartool.lsactivity(activity.getName(), handler.getFormat(), viewname));
        String line = reader.readLine();
        Matcher matcher = handler.checkLine(line);
        if (matcher != null) {
            activity.setHeadline(matcher.group(1));
            activity.setStream(matcher.group(2));
            activity.setUser(matcher.group(3));
            if (activity.isIntegrationActivity() && numberOfContributingActivitiesToFollow > 0) {
                String contributingActivities = matcher.group(4);
                for (String contributing : contributingActivities.split(" ")) {
                    UcmActivity subActivity = null;
                    UcmActivity cachedActivity = activityMap.get(contributing);
                    if (cachedActivity == null) {
                        subActivity = new UcmActivity();
                        subActivity.setName(contributing);
                        this.callLsActivity(activityMap, subActivity, viewname, --numberOfContributingActivitiesToFollow);
                        activityMap.put(contributing, subActivity);
                    } else {
                        subActivity = new UcmActivity(cachedActivity);
                    }
                    activity.addSubActivity(subActivity);
                }
            }
        }
        reader.close();
    }

    public boolean hasChangesCodeFreeze() throws IOException, InterruptedException {
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy_HH_mm_ss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStr = formatter.format(new Date()).toLowerCase();
        UcmCommon.makeBaseline((ClearToolLauncher)this.cleartool.getLauncher(), (boolean)true, (String)UcmDynamicCheckoutAction.getConfiguredStreamViewName((String)this.build.getProject().getName(), (String)this.stream), null, (String)("hudson_poll_" + dateStr), (String)("hudson_poll_" + dateStr), (boolean)false, (boolean)false, null);
        List latestBlsOnConfgiuredStream = UcmCommon.getLatestBlsWithCompOnStream((ClearToolLauncher)this.cleartool.getLauncher(), (String)this.stream, (String)UcmDynamicCheckoutAction.getConfiguredStreamViewName((String)this.build.getProject().getName(), (String)this.stream));
        Run previousBuild = this.build.getPreviousBuild();
        ClearCaseDataAction clearcaseDataAction = (ClearCaseDataAction)previousBuild.getAction(ClearCaseDataAction.class);
        List previousBuildBls = null;
        if (clearcaseDataAction != null) {
            previousBuildBls = clearcaseDataAction.getLatestBlsOnConfiguredStream();
        }
        if (latestBlsOnConfgiuredStream != null && previousBuildBls != null) {
            if (latestBlsOnConfgiuredStream.size() != previousBuildBls.size()) {
                return true;
            }
            for (UcmCommon.BaselineDesc blCurr : latestBlsOnConfgiuredStream) {
                boolean foundBl = false;
                for (UcmCommon.BaselineDesc blPrev : previousBuildBls) {
                    if (!blCurr.getBaselineName().equals(blPrev.getBaselineName())) continue;
                    foundBl = true;
                    break;
                }
                if (foundBl) continue;
                return true;
            }
        }
        return false;
    }

    public List<HistoryEntry> getChangesCodeFreeze() throws IOException, InterruptedException {
        List<Object> entries = new ArrayList<HistoryEntry>();
        ClearCaseDataAction latestBaselinesAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        List latestBlsOnConfgiuredStream = latestBaselinesAction.getLatestBlsOnConfiguredStream();
        ClearCaseDataAction clearcaseDataAction = null;
        Run previousBuild = this.build.getPreviousBuild();
        while (previousBuild != null && clearcaseDataAction == null) {
            clearcaseDataAction = (ClearCaseDataAction)previousBuild.getAction(ClearCaseDataAction.class);
            if (clearcaseDataAction == null || clearcaseDataAction.getStream().equals(this.stream)) continue;
            clearcaseDataAction = null;
            previousBuild = previousBuild.getPreviousBuild();
        }
        List previousBuildBls = null;
        if (clearcaseDataAction != null) {
            this.cleartool.getLauncher().getListener().getLogger().println("Checking changes by comparing this build and the last build (" + previousBuild.getNumber() + ") that ran on stream " + this.stream);
            previousBuildBls = clearcaseDataAction.getLatestBlsOnConfiguredStream();
        } else {
            this.cleartool.getLauncher().getListener().getLogger().println("Found no previous build that ran on stream " + this.stream);
        }
        if (latestBlsOnConfgiuredStream != null && previousBuildBls != null) {
            List changedVerionsList = this.getChangedVersions(latestBlsOnConfgiuredStream, previousBuildBls);
            entries = this.translateChangedVersionsToEnteries(changedVerionsList);
        }
        return entries;
    }

    private List<HistoryEntry> translateChangedVersionsToEnteries(List<String> changedVerionsList) throws IOException, InterruptedException {
        List entries = null;
        StringBuilder entriesDesc = new StringBuilder();
        for (String version : changedVerionsList) {
            String versionDesc = UcmCommon.getVersionDescription((ClearToolLauncher)this.cleartool.getLauncher(), (String)version, (String)(this.historyHandler.getFormat() + "%c" + "\\n"));
            entriesDesc.append(versionDesc + "\n");
        }
        BufferedReader buffReader = new BufferedReader(new StringReader(entriesDesc.toString()));
        try {
            entries = this.parseLsHistory(buffReader);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
        return entries;
    }

    private List<String> getChangedVersions(List<UcmCommon.BaselineDesc> newBls, List<UcmCommon.BaselineDesc> oldBls) throws IOException, InterruptedException {
        ArrayList<String> changedVersionList = new ArrayList<String>();
        for (UcmCommon.BaselineDesc blDesc : newBls) {
            String previousBl;
            if (!blDesc.getComponentDesc().isModifiable() || (previousBl = this.getBaseLineNameForComponent(oldBls, blDesc.getComponentName())) == null || previousBl.equals(blDesc.getBaselineName())) continue;
            String viewName = UcmDynamicCheckoutAction.getConfiguredStreamViewName((String)this.build.getProject().getName(), (String)this.stream);
            List changedVersionListPerBl = UcmCommon.getDiffBlVersions((ClearToolLauncher)this.cleartool.getLauncher(), (String)(this.viewDrive + "/" + viewName), (String)previousBl, (String)blDesc.getBaselineName());
            changedVersionList.addAll(changedVersionListPerBl);
        }
        return changedVersionList;
    }

    private String getBaseLineNameForComponent(List<UcmCommon.BaselineDesc> baselineList, String compName) {
        for (UcmCommon.BaselineDesc blDesc : baselineList) {
            if (!UcmCommon.getNoVob((String)blDesc.getComponentName()).equals(UcmCommon.getNoVob((String)compName))) continue;
            return blDesc.getBaselineName();
        }
        return null;
    }
}

