/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;

public class SnapshotCheckoutAction
extends AbstractCheckoutAction {
    private final ConfigSpec configSpec;

    public SnapshotCheckoutAction(ClearTool cleartool, ConfigSpec configSpec, String[] loadRules, boolean useUpdate) {
        super(cleartool, loadRules, useUpdate);
        this.configSpec = configSpec;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        boolean viewCreated = this.cleanAndCreateViewIfNeeded(workspace, viewName, null);
        boolean needSetCs = true;
        AbstractCheckoutAction.LoadRulesDelta loadRulesDelta = null;
        if (!viewCreated) {
            ConfigSpec viewConfigSpec = new ConfigSpec(this.cleartool.catcs(viewName), launcher.isUnix());
            loadRulesDelta = this.getLoadRulesDelta(viewConfigSpec.getLoadRules(), launcher);
            boolean bl = needSetCs = !this.configSpec.stripLoadRules().equals(viewConfigSpec.stripLoadRules()) || !ArrayUtils.isEmpty((Object[])loadRulesDelta.getRemoved());
        }
        if (needSetCs) {
            try {
                this.cleartool.setcs(viewName, this.configSpec.setLoadRules(this.loadRules).getRaw());
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        Object[] addedLoadRules = loadRulesDelta.getAdded();
        if (!ArrayUtils.isEmpty((Object[])addedLoadRules)) {
            try {
                this.cleartool.update(viewName, (String[])addedLoadRules);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        if (!viewCreated) {
            try {
                this.cleartool.update(viewName, null);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        return true;
    }

    public ConfigSpec getConfigSpec() {
        return this.configSpec;
    }
}

