/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;

public class UcmSnapshotCheckoutAction
extends AbstractCheckoutAction {
    private final String streamSelector;

    public UcmSnapshotCheckoutAction(ClearTool cleartool, String streamSelector, String[] loadRules, boolean useUpdate) {
        super(cleartool, loadRules, useUpdate);
        this.streamSelector = streamSelector;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewName) throws IOException, InterruptedException {
        boolean viewCreated = this.cleanAndCreateViewIfNeeded(workspace, viewName, this.streamSelector);
        if (viewCreated) {
            try {
                this.cleartool.update(viewName, this.loadRules);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        ConfigSpec viewConfigSpec = new ConfigSpec(this.cleartool.catcs(viewName), launcher.isUnix());
        AbstractCheckoutAction.LoadRulesDelta loadRulesDelta = this.getLoadRulesDelta(viewConfigSpec.getLoadRules(), launcher);
        if (!ArrayUtils.isEmpty((Object[])loadRulesDelta.getRemoved())) {
            try {
                this.cleartool.setcs(viewName, viewConfigSpec.setLoadRules(this.loadRules).getRaw());
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        Object[] addedLoadRules = loadRulesDelta.getAdded();
        if (!ArrayUtils.isEmpty((Object[])addedLoadRules)) {
            try {
                this.cleartool.update(viewName, (String[])addedLoadRules);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        try {
            this.cleartool.update(viewName, null);
        }
        catch (IOException e) {
            launcher.getListener().fatalError(e.toString());
            return false;
        }
        return true;
    }
}

