/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearToolSnapshot
extends ClearToolExec {
    private String optionalMkviewParameters;

    public ClearToolSnapshot(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        super(variableResolver, launcher);
    }

    public ClearToolSnapshot(VariableResolver<String> variableResolver, ClearToolLauncher launcher, String optionalParameters) {
        this(variableResolver, launcher);
        this.optionalMkviewParameters = optionalParameters;
    }

    public void setcs(String viewName, String configSpec) throws IOException, InterruptedException {
        if (configSpec == null) {
            configSpec = "";
        }
        FilePath workspace = this.launcher.getWorkspace();
        FilePath configSpecFile = workspace.createTextTempFile("configspec", ".txt", configSpec);
        String csLocation = "";
        if (!configSpec.equals("")) {
            csLocation = ".." + File.separatorChar + configSpecFile.getName();
            csLocation = PathUtil.convertPathForOS((String)csLocation, (Launcher)this.launcher.getLauncher());
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        if (!csLocation.equals("")) {
            cmd.add(csLocation);
        } else {
            cmd.add("-current");
        }
        String output = this.runAndProcessOutput(cmd, workspace.child(viewName), false, null);
        configSpecFile.delete();
        if (output.contains("cleartool: Warning: An update is already in progress for view")) {
            throw new IOException("View update failed: " + output);
        }
    }

    public void setcsCurrent(String viewName) throws IOException, InterruptedException {
        FilePath workspace = this.launcher.getWorkspace();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        cmd.add("-current");
        String output = this.runAndProcessOutput(cmd, workspace.child(viewName), false, null);
        if (output.contains("cleartool: Warning: An update is already in progress for view")) {
            throw new IOException("View update failed: " + output);
        }
    }

    public void mkview(String viewName, String streamSelector) throws IOException, InterruptedException {
        boolean isOptionalParamContainsHost = false;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkview");
        cmd.add("-snapshot");
        if (streamSelector != null) {
            cmd.add("-stream");
            cmd.add(streamSelector);
        }
        cmd.add("-tag");
        cmd.add(viewName);
        if (this.optionalMkviewParameters != null && this.optionalMkviewParameters.length() > 0) {
            String variabledResolvedParams = Util.replaceMacro((String)this.optionalMkviewParameters, (VariableResolver)this.variableResolver);
            cmd.addTokenized(variabledResolvedParams);
            isOptionalParamContainsHost = this.optionalMkviewParameters.contains("-host");
        }
        if (!isOptionalParamContainsHost) {
            cmd.add(viewName);
        }
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void mkview(String viewName, String streamSelector, String defaultStorageDir) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Snapshot view does not support mkview (String, String)");
    }

    public void rmview(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add(viewName);
        String output = this.runAndProcessOutput(cmd, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to remove view: " + output);
        }
        FilePath viewFilePath = this.launcher.getWorkspace().child(viewName);
        if (viewFilePath.exists()) {
            this.launcher.getListener().getLogger().println("Removing view folder as it was not removed when the view was removed.");
            viewFilePath.deleteRecursive();
        }
    }

    public void update(String viewName, String[] loadRules) throws IOException, InterruptedException {
        String output;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("update");
        cmd.add("-force");
        cmd.add("-overwrite");
        cmd.add(new String[]{"-log", "NUL"});
        if (!ArrayUtils.isEmpty((Object[])loadRules)) {
            cmd.add("-add_loadrules");
            for (String loadRule : loadRules) {
                String loadRuleLocation = PathUtil.convertPathForOS((String)this.removePrefixLoadRule(loadRule), (Launcher)this.getLauncher().getLauncher());
                if (loadRuleLocation.matches(".*\\s.*")) {
                    cmd.addQuoted(loadRuleLocation);
                    continue;
                }
                cmd.add(loadRuleLocation);
            }
        }
        if ((output = this.runAndProcessOutput(cmd, this.getLauncher().getWorkspace().child(viewName), false, null)).contains("cleartool: Warning: An update is already in progress for view")) {
            throw new IOException("View update failed: " + output);
        }
    }

    private String removePrefixLoadRule(String loadRule) {
        char firstChar = loadRule.charAt(0);
        if (firstChar == '\\' || firstChar == '/') {
            return loadRule.substring(1);
        }
        return loadRule;
    }

    protected FilePath getRootViewPath(ClearToolLauncher launcher) {
        return launcher.getWorkspace();
    }

    public void startView(String viewTag) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Snapshot view does not support startview");
    }

    public void syncronizeViewWithStream(String viewName, String stream) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Snapshot view does not support syncronize");
    }
}

