/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import hudson.plugins.clearcase.action.CheckOutAction;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheckoutAction
implements CheckOutAction {
    protected final ClearTool cleartool;
    protected final String[] loadRules;
    protected final boolean useUpdate;

    public AbstractCheckoutAction(ClearTool cleartool, String[] loadRules, boolean useUpdate) {
        Validate.notNull((Object)cleartool);
        this.cleartool = cleartool;
        this.loadRules = loadRules;
        this.useUpdate = useUpdate;
    }

    protected boolean cleanAndCreateViewIfNeeded(FilePath workspace, String viewName, String streamSelector) throws IOException, InterruptedException {
        FilePath viewPath = new FilePath(workspace, viewName);
        boolean viewPathExists = viewPath.exists();
        boolean doViewCreation = true;
        if (this.cleartool.doesViewExist(viewName)) {
            if (viewPathExists) {
                if (viewName.equals(this.cleartool.lscurrentview(viewName))) {
                    if (this.useUpdate) {
                        doViewCreation = false;
                    } else {
                        this.cleartool.rmview(viewName);
                    }
                } else {
                    viewPath.renameTo(this.getUnusedFilePath(workspace, viewName));
                    this.cleartool.rmviewtag(viewName);
                }
            } else {
                this.cleartool.rmviewtag(viewName);
            }
        } else if (viewPathExists) {
            viewPath.renameTo(this.getUnusedFilePath(workspace, viewName));
        }
        if (doViewCreation) {
            this.cleartool.mkview(viewName, streamSelector);
        }
        return doViewCreation;
    }

    protected LoadRulesDelta getLoadRulesDelta(Set<String> configSpecLoadRules, Launcher launcher) {
        LinkedHashSet<String> removedLoadRules = new LinkedHashSet<String>(configSpecLoadRules);
        LinkedHashSet<String> addedLoadRules = new LinkedHashSet<String>(this.loadRules.length);
        for (String loadRule : this.loadRules) {
            addedLoadRules.add(this.unprefixLoadRule(loadRule));
        }
        removedLoadRules.removeAll(addedLoadRules);
        addedLoadRules.removeAll(configSpecLoadRules);
        PrintStream logger = launcher.getListener().getLogger();
        for (String removedLoadRule : removedLoadRules) {
            logger.println("Removed load rule : " + removedLoadRule);
        }
        for (String addedLoadRule : addedLoadRules) {
            logger.println("Added load rule : " + addedLoadRule);
        }
        return new LoadRulesDelta(removedLoadRules, addedLoadRules);
    }

    private String unprefixLoadRule(String loadRule) {
        if (loadRule.startsWith("/") || loadRule.startsWith("\\")) {
            return loadRule.substring(1);
        }
        return loadRule;
    }

    private FilePath getUnusedFilePath(FilePath workspace, String viewName) throws IOException, InterruptedException {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            FilePath result = new FilePath(workspace, viewName + ".keep." + i);
            if (result.exists()) continue;
            return result;
        }
        return null;
    }
}

