/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearToolDynamicUCM
extends ClearToolExec {
    private transient String viewDrive;
    private String optionalMkviewParameters;

    public ClearToolDynamicUCM(VariableResolver<String> variableResolver, ClearToolLauncher launcher, String viewDrive, String optionalMkviewParameters) {
        super(variableResolver, launcher);
        this.viewDrive = viewDrive;
        this.optionalMkviewParameters = optionalMkviewParameters;
    }

    @Override
    protected FilePath getRootViewPath(ClearToolLauncher launcher) {
        return new FilePath(launcher.getWorkspace().getChannel(), this.viewDrive);
    }

    @Override
    public void setcs(String viewName, String configSpec) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support setcs with a config spec");
    }

    @Override
    public void syncronizeViewWithStream(String viewName, String stream) throws IOException, InterruptedException {
        this.setcs(viewName);
    }

    private void setcs(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        cmd.add("-tag");
        cmd.add(viewName);
        cmd.add("-stream");
        this.launcher.run(cmd.toCommandArray(), null, null, this.getRootViewPath(this.launcher).child(viewName));
    }

    @Override
    public void mkview(String viewName, String streamSelector, String defaultStorageDir) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        boolean isOptionalParamContainsHost = false;
        cmd.add("mkview");
        if (streamSelector != null) {
            cmd.add("-stream");
            cmd.add(streamSelector);
        }
        cmd.add("-tag");
        cmd.add(viewName);
        if (this.optionalMkviewParameters != null && this.optionalMkviewParameters.length() > 0) {
            String variabledResolvedParams = Util.replaceMacro((String)this.optionalMkviewParameters, (VariableResolver)this.variableResolver);
            cmd.addTokenized(variabledResolvedParams);
            isOptionalParamContainsHost = this.optionalMkviewParameters.contains("-host");
        }
        if (!isOptionalParamContainsHost && defaultStorageDir != null && defaultStorageDir.length() > 0) {
            Integer rndNum = new Random().nextInt();
            String seperator = PathUtil.fileSepForOS(this.getLauncher().getLauncher().isUnix());
            String viewStorageDir = defaultStorageDir + seperator + viewName + "." + rndNum.toString();
            cmd.add(viewStorageDir);
        }
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    @Override
    public void mkview(String viewName, String streamSelector) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support mkview (String, String)");
    }

    @Override
    public void rmview(String viewName) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support rmview");
    }

    @Override
    public void rmviewtag(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmtag");
        cmd.add("-view");
        cmd.add(viewName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, baos, null);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        if (builder.toString().contains("cleartool: Error")) {
            throw new IOException("Failed to remove view tag: " + builder.toString());
        }
    }

    @Override
    public void update(String viewName, String[] loadRules) throws IOException, InterruptedException {
        this.launcher.getListener().fatalError("Dynamic UCM view does not support update");
    }

    @Override
    public void startView(String viewTags) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("startview");
        cmd.addTokenized(viewTags);
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }
}

