/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.AbortException;
import hudson.FilePath;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClearToolExec
implements ClearTool {
    private transient Pattern viewListPattern;
    protected ClearToolLauncher launcher;
    protected VariableResolver<String> variableResolver;

    public ClearToolExec(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        this.variableResolver = variableResolver;
        this.launcher = launcher;
    }

    @Override
    public ClearToolLauncher getLauncher() {
        return this.launcher;
    }

    protected abstract FilePath getRootViewPath(ClearToolLauncher var1);

    @Override
    public Reader lshistory(String format, Date lastBuildDate, String viewName, String branch, String[] viewPaths) throws IOException, InterruptedException {
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy.HH:mm:ss'UTC'Z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lshistory");
        cmd.add("-all");
        cmd.add(new String[]{"-since", formatter.format(lastBuildDate).toLowerCase()});
        cmd.add(new String[]{"-fmt", format});
        if (StringUtils.isNotEmpty((String)branch)) {
            cmd.add(new String[]{"-branch", "brtype:" + branch});
        }
        cmd.add("-nco");
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewName);
        for (String path : viewPaths) {
            if ((path = path.replace("\n", "").replace("\r", "")).matches(".*\\s.*")) {
                cmd.addQuoted(path);
                continue;
            }
            cmd.add(path);
        }
        InputStreamReader returnReader = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, baos, viewPath)) {
            returnReader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        }
        baos.close();
        return returnReader;
    }

    @Override
    public Reader lsactivity(String activity, String commandFormat, String viewname) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsactivity");
        cmd.add(new String[]{"-fmt", commandFormat});
        cmd.add(activity);
        FilePath viewPath = this.getRootViewPath(this.launcher).child(viewname);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, baos, viewPath);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        baos.close();
        return reader;
    }

    @Override
    public void mklabel(String viewName, String label) throws IOException, InterruptedException {
        throw new AbortException();
    }

    @Override
    public List<String> lsview(boolean onlyActiveDynamicViews) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, baos, null)) {
            return this.parseListOutput(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyActiveDynamicViews);
        }
        return new ArrayList<String>();
    }

    @Override
    public String lscurrentview(String viewPath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview").add("-cview").add("-s");
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        String output = this.runAndProcessOutput(cmd, this.getLauncher().getWorkspace().child(viewPath), true, exceptions);
        if (!exceptions.isEmpty()) {
            if (output.contains("cleartool: Error: Cannot get view info for current view: not a ClearCase object.")) {
                output = null;
            } else {
                throw (IOException)exceptions.get(0);
            }
        }
        return output;
    }

    @Override
    public boolean doesViewExist(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        cmd.add(viewName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            return this.launcher.run(cmd.toCommandArray(), null, baos, null);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public List<String> lsvob(boolean onlyMounted) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsvob");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, baos, null)) {
            return this.parseListOutput(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyMounted);
        }
        return new ArrayList<String>();
    }

    @Override
    public String pwv(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("pwv");
        cmd.add("-root");
        return this.runAndProcessOutput(cmd, this.getRootViewPath(this.launcher).child(viewName), false, null);
    }

    @Override
    public String catcs(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("catcs");
        cmd.add(new String[]{"-tag", viewName});
        return this.runAndProcessOutput(cmd, null, false, null);
    }

    private List<String> parseListOutput(Reader consoleReader, boolean onlyStarMarked) throws IOException {
        ArrayList<String> views = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(consoleReader);
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = this.viewListPattern.matcher(line);
            if (matcher.find() && matcher.groupCount() == 3 && (!onlyStarMarked || onlyStarMarked && matcher.group(1).equals("*"))) {
                String vob = matcher.group(2);
                int pos = Math.max(vob.lastIndexOf(92), vob.lastIndexOf(47));
                if (pos != -1) {
                    vob = vob.substring(pos + 1);
                }
                views.add(vob);
            }
            line = reader.readLine();
        }
        reader.close();
        return views;
    }

    private Pattern getListPattern() {
        if (this.viewListPattern == null) {
            this.viewListPattern = Pattern.compile("(.)\\s*(\\S*)\\s*(\\S*)");
        }
        return this.viewListPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mountVobs() throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mount");
        cmd.add("-all");
        try {
            this.launcher.run(cmd.toCommandArray(), null, baos, null);
        }
        catch (IOException ex) {
            this.logRedundantCleartoolError(cmd.toCommandArray(), ex);
        }
        finally {
            baos.close();
        }
    }

    @Override
    public Properties getViewData(String viewName) throws IOException, InterruptedException {
        Properties resPrp = new Properties();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        cmd.add(new String[]{"-l", viewName});
        Pattern uuidPattern = Pattern.compile("View uuid: (.*)");
        Pattern globalPathPattern = Pattern.compile("View server access path: (.*)");
        boolean res = true;
        Object exception = null;
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        String output = this.runAndProcessOutput(cmd, null, true, exceptions);
        if (!exceptions.isEmpty() && !output.contains("No matching entries found for view")) {
            throw (IOException)exceptions.get(0);
        }
        if (res && exception == null) {
            String[] lines;
            for (String line : lines = output.split("\n")) {
                Matcher matcher = uuidPattern.matcher(line);
                if (matcher.find() && matcher.groupCount() == 1) {
                    resPrp.put("UUID", matcher.group(1));
                }
                if (!(matcher = globalPathPattern.matcher(line)).find() || matcher.groupCount() != 1) continue;
                resPrp.put("STORAGE_DIR", matcher.group(1));
            }
        }
        return resPrp;
    }

    @Override
    public void endView(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("endview");
        cmd.add(viewName);
        String output = this.runAndProcessOutput(cmd, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to end view tag: " + output);
        }
    }

    @Override
    public void rmviewtag(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add("-tag");
        cmd.add(viewName);
        String output = this.runAndProcessOutput(cmd, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to remove view tag: " + output);
        }
    }

    @Override
    public void unregisterView(String uuid) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("unregister");
        cmd.add("-view");
        cmd.add("-uuid");
        cmd.add(uuid);
        String output = this.runAndProcessOutput(cmd, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to unregister view: " + output);
        }
    }

    @Override
    public void rmviewUuid(String viewUuid) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add("-avobs");
        cmd.add("-uuid");
        cmd.add(viewUuid);
        String output = this.runAndProcessOutput(cmd, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to remove view: " + output);
        }
    }

    protected String runAndProcessOutput(ArgumentListBuilder cmd, FilePath workFolder, boolean catchExceptions, List<IOException> exceptions) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.launcher.run(cmd.toCommandArray(), null, baos, workFolder);
        }
        catch (IOException e) {
            if (!catchExceptions) {
                throw e;
            }
            exceptions.add(e);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        return builder.toString();
    }

    @Override
    public void logRedundantCleartoolError(String[] cmd, Exception ex) {
        this.getLauncher().getListener().getLogger().println("Redundant Cleartool Error ");
        if (cmd != null) {
            this.getLauncher().getListener().getLogger().println("command: " + this.getLauncher().getCmdString(cmd));
        }
        this.getLauncher().getListener().getLogger().println(ex.getMessage());
    }
}

