/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearCaseDataAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseReportAction
implements Action {
    private AbstractBuild<?, ?> build;
    private static String urlName = "clearcaseInformation";

    public ClearCaseReportAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public String getIconFileName() {
        return "gear2.gif";
    }

    public String getDisplayName() {
        return "ClearCase Information";
    }

    public String getUrlName() {
        return urlName;
    }

    public static String getUrlNameStat() {
        return urlName;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.build;
    }

    public String getConfigSpecHtml() {
        String configSpecHtml = this.getCspec();
        configSpecHtml = configSpecHtml.replaceAll("\n", "<br/>");
        return configSpecHtml;
    }

    public boolean isCspec() {
        String cspec = this.getCspec();
        return cspec != null && cspec.trim().length() > 0;
    }

    public List<Baseline> getBaselines() {
        ClearCaseDataAction clearCaseDataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (clearCaseDataAction != null) {
            return clearCaseDataAction.getLatestBlsOnConfiguredStream();
        }
        return null;
    }

    public boolean isBaselineInfo() {
        ClearCaseDataAction baselinesAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        return baselinesAction != null;
    }

    public String getStream() {
        String stream = null;
        ClearCaseDataAction dataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (dataAction != null) {
            stream = dataAction.getStream();
        }
        return stream;
    }

    private String getCspec() {
        String cspec = null;
        ClearCaseDataAction dataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (dataAction != null) {
            cspec = dataAction.getCspec();
        }
        return cspec;
    }
}

