/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.plugins.clearcase.util.PathUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ConfigSpec {
    private final String raw;
    private final boolean isUnix;

    public ConfigSpec(String raw, boolean isUnix) {
        Validate.notNull((Object)raw);
        this.raw = raw;
        this.isUnix = isUnix;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigSpec other = (ConfigSpec)obj;
        if (this.isUnix != other.isUnix) {
            return false;
        }
        return !(this.raw == null ? other.raw != null : !this.raw.equals(other.raw));
    }

    public Set<String> getLoadRules() {
        HashSet<String> rules = new HashSet<String>();
        for (String row : this.raw.split("[\\r\\n]+")) {
            String trimmedRow = row.trim();
            if (!trimmedRow.startsWith("load")) continue;
            String rule = row.trim().substring("load".length()).trim();
            rules.add(rule);
        }
        return rules;
    }

    public String getRaw() {
        return this.raw;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isUnix ? 1231 : 1237);
        result = 31 * result + (this.raw == null ? 0 : this.raw.hashCode());
        return result;
    }

    public ConfigSpec setLoadRules(String[] loadRules) {
        StringBuilder sb = this.stripLoadRulesOnRaw();
        if (!ArrayUtils.isEmpty((Object[])loadRules)) {
            for (String loadRule : loadRules) {
                sb.append("load ");
                sb.append(ConfigSpec.cleanLoadRule((String)loadRule, (boolean)this.isUnix).trim()).append(PathUtil.newLineForOS((boolean)this.isUnix));
            }
        }
        return new ConfigSpec(sb.toString(), this.isUnix);
    }

    public static String cleanLoadRule(String loadRule, boolean isUnix) {
        char firstChar;
        if (StringUtils.isBlank((String)loadRule)) {
            return loadRule;
        }
        String lr = loadRule;
        if (lr.charAt(0) == '\"' && lr.charAt(lr.length() - 1) == '\"') {
            lr = lr.substring(1, lr.length() - 1);
        }
        if ((firstChar = lr.charAt(0)) != '\\' && firstChar != '/') {
            lr = PathUtil.fileSepForOS((boolean)isUnix) + lr;
        }
        if (lr.contains(" ")) {
            lr = '\"' + lr + '\"';
        }
        return PathUtil.convertPathForOS((String)lr, (boolean)isUnix);
    }

    public ConfigSpec stripLoadRules() {
        return new ConfigSpec(this.stripLoadRulesOnRaw().toString().trim(), this.isUnix);
    }

    private StringBuilder stripLoadRulesOnRaw() {
        StringBuilder sb = new StringBuilder();
        for (String row : this.raw.split("[\\r\\n]+")) {
            if (row.startsWith("load")) continue;
            sb.append(row).append(PathUtil.newLineForOS((boolean)this.isUnix));
        }
        return sb;
    }
}

