/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.base;

import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.ChangeLogAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.util.ChangeLogEntryMerger;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseChangeLogAction
implements ChangeLogAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%u", "%e", "%En", "%Vn", "%o"};
    private ClearTool cleartool;
    private ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
    private final int maxTimeDifferenceMillis;
    private List<Filter> filters;
    private String extendedViewPath;

    public BaseChangeLogAction(ClearTool cleartool, int maxTimeDifferenceMillis, List<Filter> filters) {
        this.cleartool = cleartool;
        this.maxTimeDifferenceMillis = maxTimeDifferenceMillis;
        this.filters = filters;
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
    }

    public List<ClearCaseChangeLogEntry> getChanges(Date time, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        ArrayList fullList = new ArrayList();
        try {
            for (String branchName : branchNames) {
                BufferedReader reader = new BufferedReader(this.cleartool.lshistory(this.historyHandler.getFormat() + "%c" + "\\n", time, viewName, branchName, viewPaths));
                fullList.addAll(this.parseEntries(reader));
                reader.close();
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        ChangeLogEntryMerger entryMerger = new ChangeLogEntryMerger(this.maxTimeDifferenceMillis);
        return entryMerger.getMergedList(fullList);
    }

    private List<ClearCaseChangeLogEntry> parseEntries(BufferedReader reader) throws IOException, InterruptedException, ParseException {
        ArrayList<ClearCaseChangeLogEntry> entries = new ArrayList<ClearCaseChangeLogEntry>();
        StringBuilder commentBuilder = new StringBuilder();
        String line = reader.readLine();
        ClearCaseChangeLogEntry currentEntry = null;
        block0: while (line != null) {
            if (line.startsWith("cleartool: Error:")) {
                line = reader.readLine();
                continue;
            }
            Matcher matcher = this.historyHandler.checkLine(line);
            if (matcher != null) {
                if (currentEntry != null) {
                    currentEntry.setComment(commentBuilder.toString());
                }
                commentBuilder = new StringBuilder();
                currentEntry = new ClearCaseChangeLogEntry();
                Date date = this.dateFormatter.parse(matcher.group(1));
                currentEntry.setDate(date);
                currentEntry.setUser(matcher.group(2));
                String fileName = matcher.group(4).trim();
                if (this.extendedViewPath != null && fileName.startsWith(this.extendedViewPath)) {
                    fileName = fileName.substring(this.extendedViewPath.length());
                }
                ClearCaseChangeLogEntry.FileElement element = new ClearCaseChangeLogEntry.FileElement(fileName, matcher.group(5).trim(), matcher.group(3).trim(), matcher.group(6).trim());
                currentEntry.addElement(element);
                HistoryEntry entry = new HistoryEntry();
                entry.setLine(line);
                entry.setDateText(matcher.group(1).trim());
                entry.setUser(matcher.group(2).trim());
                entry.setEvent(matcher.group(3).trim());
                entry.setElement(matcher.group(4).trim());
                entry.setVersionId(matcher.group(5).trim());
                entry.setOperation(matcher.group(6).trim());
                for (Filter filter : this.filters) {
                    if (filter.accept(entry)) continue;
                    line = reader.readLine();
                    continue block0;
                }
                entries.add(currentEntry);
            } else {
                if (commentBuilder.length() > 0) {
                    commentBuilder.append("\n");
                }
                commentBuilder.append(line);
            }
            line = reader.readLine();
        }
        if (currentEntry != null) {
            currentEntry.setComment(commentBuilder.toString());
        }
        return entries;
    }

    public void setExtendedViewPath(String path) {
        this.extendedViewPath = path;
    }

    public String getExtendedViewPath() {
        return this.extendedViewPath;
    }
}

