/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.history;

import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHistoryAction
implements HistoryAction {
    protected ClearTool cleartool;
    private Filter filter;
    protected String extendedViewPath;
    protected boolean isDynamicView;

    public AbstractHistoryAction(ClearTool cleartool, boolean isDynamicView, Filter filter) {
        this.cleartool = cleartool;
        this.filter = filter;
        this.isDynamicView = isDynamicView;
    }

    protected abstract List<? extends ChangeLogSet.Entry> buildChangelog(String var1, List<HistoryEntry> var2) throws IOException, InterruptedException;

    protected List<HistoryEntry> filterEntries(List<HistoryEntry> entries) throws IOException, InterruptedException {
        if (this.filter == null) {
            return entries;
        }
        ArrayList<HistoryEntry> filtered = new ArrayList<HistoryEntry>();
        for (HistoryEntry entry : entries) {
            if (!this.filter.accept(entry)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    public List<? extends ChangeLogSet.Entry> getChanges(Date time, String viewPath, String viewTag, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        List entries = this.runLsHistory(time, viewPath, viewTag, branchNames, viewPaths);
        List filtered = this.filterEntries(entries);
        List changelog = this.buildChangelog(viewPath, filtered);
        return changelog;
    }

    public String getExtendedViewPath() {
        return this.extendedViewPath;
    }

    protected abstract ClearToolFormatHandler getHistoryFormatHandler();

    public boolean hasChanges(Date time, String viewPath, String viewTag, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        List entries = this.runLsHistory(time, viewPath, viewTag, branchNames, viewPaths);
        List filtered = this.filterEntries(entries);
        return filtered.size() > 0;
    }

    protected abstract HistoryEntry parseEventLine(Matcher var1, String var2) throws IOException, InterruptedException, ParseException;

    protected void parseLsHistory(BufferedReader reader, Collection<HistoryEntry> history) throws IOException, InterruptedException, ParseException {
        HistoryEntry currentEntry = null;
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("cleartool: Error:")) {
                Matcher matcher = this.getHistoryFormatHandler().checkLine(line);
                if (matcher != null) {
                    currentEntry = this.parseEventLine(matcher, line);
                    currentEntry.setElement(StringUtils.removeStart((String)currentEntry.getElement(), (String)this.extendedViewPath));
                    history.add(currentEntry);
                } else if (currentEntry != null) {
                    currentEntry.appendComment(line).appendComment("\n");
                } else {
                    Logger.getLogger(AbstractHistoryAction.class.getName()).warning("Got the comment : \"" + line + "\" but couldn't attach it to any entry");
                }
            }
            line = reader.readLine();
        }
    }

    protected List<HistoryEntry> runLsHistory(Date time, String viewPath, String viewTag, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        Validate.notNull((Object)viewPath);
        ArrayList<HistoryEntry> history = new ArrayList<HistoryEntry>();
        if (!this.cleartool.doesViewExist(viewTag)) {
            return history;
        }
        if (this.isDynamicView) {
            this.cleartool.startView(viewTag);
        }
        if (ArrayUtils.isEmpty((Object[])viewPaths)) {
            return history;
        }
        try {
            for (String branchName : branchNames) {
                BufferedReader reader = new BufferedReader(this.cleartool.lshistory(this.getHistoryFormatHandler().getFormat() + "%c" + "\\n", time, viewPath, branchName, viewPaths));
                this.parseLsHistory(reader, history);
                reader.close();
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return history;
    }

    public void setExtendedViewPath(String path) {
        this.extendedViewPath = path;
    }
}

