/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.FilePath;
import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class UcmCommon {
    public static String[] generateLoadRulesFromBaselines(ClearTool clearTool, String stream, List<Baseline> baselines) throws IOException, InterruptedException {
        if (baselines == null) {
            return null;
        }
        ArrayList<String> loadRules = new ArrayList<String>();
        boolean i = false;
        for (Baseline bl : baselines) {
            Reader reader = clearTool.describe("%[root_dir]p\\n", "component:" + bl.getComponentName());
            BufferedReader br = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                if (StringUtils.isNotBlank((String)line)) {
                    sb.append(line.substring(1));
                }
                line = br.readLine();
            }
            String loadRule = sb.toString();
            if (!StringUtils.isNotBlank((String)loadRule)) continue;
            loadRules.add(loadRule);
        }
        return loadRules.toArray(new String[loadRules.size()]);
    }

    public static List<String> getLatestBaselineNames(ClearTool clearTool, boolean isUseDynamicView, String viewName, FilePath filePath, List<String> readWriteComponents) throws IOException, InterruptedException {
        String output = clearTool.lsstream(null, viewName, "%[latest_bls]Xp");
        String prefix = "baseline:";
        ArrayList<String> baselineNames = new ArrayList<String>();
        if (StringUtils.startsWith((String)output, (String)prefix)) {
            String[] baselineNamesSplit;
            for (String baselineName : baselineNamesSplit = output.split("baseline:")) {
                if (!StringUtils.isNotBlank((String)baselineName)) continue;
                String baselineNameTrimmed = StringUtils.trim((String)baselineName);
                String blComp = UcmCommon.getDataforBaseline((ClearTool)clearTool, (FilePath)filePath, (String)baselineNameTrimmed).getBaselineName();
                if (readWriteComponents != null && !readWriteComponents.contains(blComp)) continue;
                baselineNames.add(baselineNameTrimmed);
            }
        }
        return baselineNames;
    }

    public static List<Baseline> getComponentsForBaselines(ClearTool clearTool, List<Component> componentsList, boolean isUseDynamicView, String viewName, FilePath filePath, List<String> baselinesNames) throws InterruptedException, IOException {
        ArrayList<Baseline> baselinesList = new ArrayList<Baseline>();
        for (String blName : baselinesNames) {
            Baseline baseline = UcmCommon.getDataforBaseline((ClearTool)clearTool, (FilePath)filePath, (String)blName);
            Component matchComponentDesc = null;
            for (Component componentDesc : componentsList) {
                if (!UcmCommon.getNoVob((String)componentDesc.getName()).equals(UcmCommon.getNoVob((String)baseline.getComponentName()))) continue;
                matchComponentDesc = componentDesc;
                baselinesList.add(new Baseline(blName, matchComponentDesc, baseline.isNotLabeled()));
                break;
            }
            if (matchComponentDesc != null) continue;
            clearTool.getLauncher().getListener().error("Could not find a component matching baseline " + blName);
        }
        return baselinesList;
    }

    public static Baseline getDataforBaseline(ClearTool clearTool, FilePath filePath, String blName) throws InterruptedException, IOException {
        String cleartoolResult = clearTool.lsbl(blName, "%[label_status]p|%[component]Xp");
        String[] arr = cleartoolResult.split("\\|");
        boolean isNotLabeled = arr[0].contains("Not Labeled");
        String prefix = "component:";
        String componentName = arr[1].substring(cleartoolResult.indexOf(cleartoolResult) + prefix.length());
        return new Baseline(componentName, isNotLabeled);
    }

    public static List<Baseline> getLatestBaselines(ClearTool clearTool, String stream) throws IOException, InterruptedException {
        return UcmCommon.getBaselinesDesc((ClearTool)clearTool, (String)stream, (String)"%[latest_bls]Xp\\n");
    }

    public static List<Baseline> getFoundationBaselines(ClearTool clearTool, String stream) throws IOException, InterruptedException {
        return UcmCommon.getBaselinesDesc((ClearTool)clearTool, (String)stream, (String)"%[found_bls]Xp\\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Baseline> getBaselinesDesc(ClearTool clearTool, String stream, String format) throws IOException, InterruptedException {
        BufferedReader rd = new BufferedReader(clearTool.describe(format, "stream:" + stream));
        ArrayList<String> baselines = new ArrayList<String>();
        try {
            String line = rd.readLine();
            while (line != null) {
                if (!line.startsWith("cleartool: Error:")) {
                    String[] bl;
                    for (String b : bl = line.split(" ")) {
                        if (!StringUtils.isNotBlank((String)b)) continue;
                        baselines.add(b);
                    }
                }
                line = rd.readLine();
            }
        }
        finally {
            rd.close();
        }
        ArrayList<Baseline> foundationBaselines = new ArrayList<Baseline>();
        for (String baseline : baselines) {
            BufferedReader br = new BufferedReader(clearTool.describe("%[component]Xp\\n", baseline));
            try {
                foundationBaselines.add(new Baseline(StringUtils.removeStart((String)baseline, (String)"baseline:"), StringUtils.removeStart((String)br.readLine(), (String)"component:")));
            }
            finally {
                br.close();
            }
        }
        return foundationBaselines;
    }

    public static List<Component> getStreamComponentsDesc(ClearTool clearTool, String streamName) throws IOException, InterruptedException {
        ArrayList<Component> componentsDescList = new ArrayList<Component>();
        Reader reader = clearTool.describe(null, "stream:" + streamName);
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        while (bufferedReader.ready()) {
            sb.append(bufferedReader.readLine());
        }
        String output = sb.toString();
        int idx = 0;
        String searchFor = "modifiable)";
        while (idx >= 0) {
            if ((idx = output.indexOf(searchFor, idx + 1)) <= 0) continue;
            int idx1 = output.lastIndexOf("(", idx - 1);
            int idx2 = output.indexOf(")", idx1);
            String componentState = output.substring(idx1 + 1, idx2);
            idx1 = output.lastIndexOf("(", idx1 - 1);
            idx2 = output.indexOf(")", idx1);
            Component componentDesc = new Component(output.substring(idx1 + 1, idx2), componentState.equals("modifiable"));
            componentsDescList.add(componentDesc);
        }
        return componentsDescList;
    }

    public static List<Baseline> getLatestBlsWithCompOnStream(ClearTool clearTool, String stream, String view) throws IOException, InterruptedException {
        List componentsList = UcmCommon.getStreamComponentsDesc((ClearTool)clearTool, (String)stream);
        List latestBlsOnBuildStream = UcmCommon.getLatestBaselineNames((ClearTool)clearTool, (boolean)true, (String)view, null, null);
        List latestBlsWithComp = UcmCommon.getComponentsForBaselines((ClearTool)clearTool, (List)componentsList, (boolean)true, (String)view, null, (List)latestBlsOnBuildStream);
        return latestBlsWithComp;
    }

    public static List<String> getReadWriteComponents(List<Component> components) {
        ArrayList<String> res = new ArrayList<String>();
        for (Component comp : components) {
            if (!comp.isModifiable()) continue;
            res.add(comp.getName());
        }
        return res;
    }

    public static List<String> getDiffBlVersions(ClearTool clearTool, String viewRootDirectory, String bl1, String bl2) throws IOException, InterruptedException {
        Reader rd = clearTool.diffbl(EnumSet.of(ClearTool.DiffBlOptions.VERSIONS), bl1, bl2, viewRootDirectory);
        BufferedReader br = new BufferedReader(rd);
        ArrayList<String> versionList = new ArrayList<String>();
        String line = br.readLine();
        while (br.ready()) {
            if (line.startsWith(">>")) {
                line = line.replaceAll(">>", "");
                versionList.add(line.trim());
            }
            line = br.readLine();
        }
        return versionList;
    }

    public static String getVersionDescription(ClearTool clearTool, String version, String format) throws IOException, InterruptedException {
        Reader rd = clearTool.describe(format, version);
        BufferedReader bufferedReader = new BufferedReader(rd);
        StringBuilder sb = new StringBuilder();
        while (bufferedReader.ready()) {
            sb.append(bufferedReader.readLine());
        }
        return sb.toString();
    }

    public static void rebase(ClearTool clearTool, String viewName, List<Baseline> baselines) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        for (Baseline bl : baselines) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(bl.getBaselineName());
        }
        clearTool.rebaseDynamic(viewName, sb.toString());
    }

    public static String getNoVob(String element) {
        return element.split("@")[0];
    }

    public static String getVob(String element) {
        return element.split("@")[1];
    }
}

