/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import hudson.util.VariableResolver;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildVariableResolver
implements VariableResolver<String> {
    private static final Logger LOGGER = Logger.getLogger(BuildVariableResolver.class.getName());
    private AbstractBuild<?, ?> build;
    private transient String nodeName;
    private transient Computer computer;
    private transient Map<Object, Object> systemProperties;
    private boolean restricted;

    public BuildVariableResolver(AbstractBuild<?, ?> build) {
        this.build = build;
        Node node = build.getBuiltOn();
        this.nodeName = node.getNodeName();
        this.computer = node.toComputer();
    }

    public BuildVariableResolver(AbstractBuild<?, ?> build, boolean restricted) {
        this(build);
        this.restricted = restricted;
    }

    public String resolve(String key) {
        try {
            EnvVars env;
            if (this.systemProperties == null) {
                this.systemProperties = this.computer.getSystemProperties();
            }
            LogTaskListener ltl = new LogTaskListener(LOGGER, Level.INFO);
            if ("JOB_NAME".equals(key) && this.build != null && this.build.getProject() != null) {
                return this.build.getProject().getName();
            }
            if ("HOST".equals(key)) {
                return Util.fixEmpty((String)this.computer.getHostName());
            }
            if ("OS".equals(key)) {
                return (String)this.systemProperties.get("os.name");
            }
            if ("NODE_NAME".equals(key)) {
                return Util.fixEmpty((String)(StringUtils.isEmpty((String)this.nodeName) ? "master" : this.nodeName));
            }
            if ("USER_NAME".equals(key)) {
                return (String)this.systemProperties.get("user.name");
            }
            Map buildVariables = this.build.getBuildVariables();
            if (buildVariables.containsKey(key)) {
                return (String)buildVariables.get(key);
            }
            if (!this.restricted && (env = this.build.getEnvironment((TaskListener)ltl)).containsKey((Object)key)) {
                return (String)env.get((Object)key);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Variable name '" + key + "' look up failed", e);
        }
        return null;
    }
}

