/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearCaseDataAction;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.ucm.UcmCommon;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class UcmDynamicCheckoutAction
implements CheckOutAction {
    private static final String CONFIGURED_STREAM_VIEW_SUFFIX = "_hudson_view";
    private static final String BUILD_STREAM_PREFIX = "hudson_stream.";
    private static final String BASELINE_NAME = "hudson_co_";
    private static final String BASELINE_COMMENT = "hudson_co_";
    private ClearTool cleartool;
    private String stream;
    private boolean createDynView;
    private String winDynStorageDir;
    private String unixDynStorageDir;
    private AbstractBuild build;
    private boolean freezeCode;
    private boolean recreateView;

    public UcmDynamicCheckoutAction(ClearTool cleartool, String stream, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, AbstractBuild build, boolean freezeCode, boolean recreateView) {
        this.cleartool = cleartool;
        this.stream = stream;
        this.createDynView = createDynView;
        this.winDynStorageDir = winDynStorageDir;
        this.unixDynStorageDir = unixDynStorageDir;
        this.build = build;
        this.freezeCode = freezeCode;
        this.recreateView = recreateView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(Launcher launcher, FilePath workspace, String viewTag) throws IOException, InterruptedException {
        ClearCaseDataAction dataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (dataAction != null) {
            AbstractProject abstractProject = this.build.getProject();
            synchronized (abstractProject) {
                dataAction.setStream(this.stream);
            }
        }
        if (this.createDynView) {
            if (this.freezeCode) {
                this.checkoutCodeFreeze(viewTag);
            } else {
                this.prepareView(viewTag, this.stream);
                this.cleartool.startView(viewTag);
                this.cleartool.setcsTag(viewTag, ClearTool.SetcsOption.STREAM, null);
            }
        } else {
            this.cleartool.startView(viewTag);
            this.cleartool.setcsTag(viewTag, ClearTool.SetcsOption.STREAM, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkoutCodeFreeze(String viewName) throws IOException, InterruptedException {
        AbstractProject abstractProject = this.build.getProject();
        synchronized (abstractProject) {
            ClearCaseDataAction clearcaseDataAction = null;
            for (Run previousBuild = this.build.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
                clearcaseDataAction = (ClearCaseDataAction)previousBuild.getAction(ClearCaseDataAction.class);
                if (!previousBuild.isBuilding() || clearcaseDataAction == null || !clearcaseDataAction.getStream().equals(this.stream)) continue;
                throw new IOException("Can't run build on stream " + this.stream + " when build " + previousBuild.getNumber() + " is currently running on the same stream.");
            }
        }
        this.prepareBuildStreamAndViews(viewName, this.stream);
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy_HH_mm_ss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStr = formatter.format(this.build.getTimestamp().getTime()).toLowerCase();
        this.cleartool.mkbl("hudson_co_" + dateStr, this.getConfiguredStreamViewName(), "hudson_co_" + dateStr, false, false, null, null, null);
        List<Baseline> latestBlsOnConfgiuredStream = UcmCommon.getLatestBlsWithCompOnStream(this.cleartool, this.stream, this.getConfiguredStreamViewName());
        for (Baseline baseLineDesc : latestBlsOnConfgiuredStream) {
            if (!baseLineDesc.isNotLabeled() || !baseLineDesc.getComponentDesc().isModifiable()) continue;
            ArrayList<String> readWriteCompList = new ArrayList<String>();
            readWriteCompList.add(baseLineDesc.getComponentDesc().getName());
            List<Baseline> baseLineDescList = this.cleartool.mkbl("hudson_co_" + dateStr, this.getConfiguredStreamViewName(), "hudson_co_" + dateStr, false, true, readWriteCompList, null, null);
            String newBaseline = baseLineDescList.get(0).getBaselineName() + "@" + UcmCommon.getVob(baseLineDesc.getComponentDesc().getName());
            baseLineDesc.setBaselineName(newBaseline);
        }
        UcmCommon.rebase(this.cleartool, viewName, latestBlsOnConfgiuredStream);
        ClearCaseDataAction dataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (dataAction != null) {
            dataAction.setLatestBlsOnConfiguredStream(latestBlsOnConfgiuredStream);
        }
        return true;
    }

    private void prepareBuildStreamAndViews(String viewTag, String stream) throws IOException, InterruptedException {
        if (!this.cleartool.doesViewExist(this.getConfiguredStreamViewName())) {
            String dynStorageDir = this.cleartool.getLauncher().getLauncher().isUnix() ? this.unixDynStorageDir : this.winDynStorageDir;
            this.cleartool.mkview(null, this.getConfiguredStreamViewName(), stream, dynStorageDir);
        }
        this.cleartool.startView(this.getConfiguredStreamViewName());
        if (!this.cleartool.doesStreamExist(this.getBuildStream())) {
            this.cleartool.mkstream(stream, this.getBuildStream());
        }
        this.prepareView(viewTag, this.getBuildStream());
    }

    private void prepareView(String viewTag, String stream) throws IOException, InterruptedException {
        String dynStorageDir;
        String string = dynStorageDir = this.cleartool.getLauncher().getLauncher().isUnix() ? this.unixDynStorageDir : this.winDynStorageDir;
        if (this.cleartool.doesViewExist(viewTag)) {
            if (this.recreateView) {
                this.cleartool.rmviewtag(viewTag);
                this.cleartool.mkview(null, viewTag, stream, dynStorageDir);
            }
        } else {
            this.cleartool.mkview(null, viewTag, stream, dynStorageDir);
        }
    }

    public static String getConfiguredStreamViewName(String jobName, String stream) {
        jobName = jobName.replace(" ", "");
        return UcmCommon.getNoVob(stream) + "_" + jobName + "_" + CONFIGURED_STREAM_VIEW_SUFFIX;
    }

    private String getConfiguredStreamViewName() {
        return UcmDynamicCheckoutAction.getConfiguredStreamViewName(this.build.getProject().getName(), this.stream);
    }

    private String getBuildStream() {
        String jobName = this.build.getProject().getName().replace(" ", "");
        return BUILD_STREAM_PREFIX + jobName + "." + this.stream;
    }

    public boolean isViewValid(Launcher launcher, FilePath workspace, String viewTag) throws IOException, InterruptedException {
        if (this.cleartool.doesViewExist(viewTag)) {
            this.cleartool.startView(viewTag);
            return true;
        }
        return false;
    }
}

