/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearCaseDataAction;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.ucm.ClearCaseUCMSCMRevisionState;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.plugins.clearcase.ucm.UcmHistoryAction;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreezeCodeUcmHistoryAction
extends UcmHistoryAction {
    private static final String BASELINE_NAME = "hudson_poll_";
    private static final String BASELINE_COMMENT = "hudson_poll_";
    private final AbstractBuild<?, ?> build;
    private final String viewDrive;
    private final String stream;

    public FreezeCodeUcmHistoryAction(ClearTool cleartool, boolean useDynamicView, Filter filter, String stream, String viewDrive, AbstractBuild<?, ?> build, ClearCaseUCMSCMRevisionState oldBaseline, ClearCaseUCMSCMRevisionState newBaseline) {
        super(cleartool, useDynamicView, filter, oldBaseline, newBaseline);
        this.build = build;
        this.stream = stream;
        this.viewDrive = viewDrive;
    }

    @Override
    public List<? extends ChangeLogSet.Entry> getChanges(Date time, String viewPath, String viewName, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        List<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        ClearCaseDataAction latestBaselinesAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        List<Baseline> latestBlsOnConfiguredStream = latestBaselinesAction.getLatestBlsOnConfiguredStream();
        ClearCaseDataAction clearcaseDataAction = null;
        Run previousBuild = this.build.getPreviousBuild();
        while (previousBuild != null && clearcaseDataAction == null) {
            clearcaseDataAction = (ClearCaseDataAction)previousBuild.getAction(ClearCaseDataAction.class);
            if (clearcaseDataAction == null || clearcaseDataAction.getStream().equals(this.getStream())) continue;
            clearcaseDataAction = null;
            previousBuild = previousBuild.getPreviousBuild();
        }
        List<Baseline> previousBuildBls = null;
        if (clearcaseDataAction != null) {
            this.cleartool.getLauncher().getListener().getLogger().println("Checking changes by comparing this build and the last build (" + previousBuild.getNumber() + ") that ran on stream " + this.getStream());
            previousBuildBls = clearcaseDataAction.getLatestBlsOnConfiguredStream();
        } else {
            this.cleartool.getLauncher().getListener().getLogger().println("Found no previous build that ran on stream " + this.getStream());
        }
        if (latestBlsOnConfiguredStream != null && previousBuildBls != null) {
            List<String> changedVerionsList = this.getChangedVersions(latestBlsOnConfiguredStream, previousBuildBls);
            entries = this.translateChangedVersionsToEnteries(changedVerionsList);
        }
        List<HistoryEntry> filtered = this.filterEntries(entries);
        List<? extends ChangeLogSet.Entry> changelog = this.buildChangelog(viewName, filtered);
        return changelog;
    }

    @Override
    public boolean hasChanges(Date time, String viewPath, String viewTag, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy_HH_mm_ss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStr = formatter.format(new Date()).toLowerCase();
        this.cleartool.mkbl("hudson_poll_" + dateStr, UcmDynamicCheckoutAction.getConfiguredStreamViewName(this.build.getProject().getName(), this.getStream()), "hudson_poll_" + dateStr, false, false, null, null, null);
        List<Baseline> latestBlsOnConfgiuredStream = UcmCommon.getLatestBlsWithCompOnStream(this.cleartool, this.getStream(), UcmDynamicCheckoutAction.getConfiguredStreamViewName(this.build.getProject().getName(), this.getStream()));
        Run previousBuild = this.build.getPreviousBuild();
        ClearCaseDataAction clearcaseDataAction = (ClearCaseDataAction)previousBuild.getAction(ClearCaseDataAction.class);
        List<Baseline> previousBuildBls = null;
        if (clearcaseDataAction != null) {
            previousBuildBls = clearcaseDataAction.getLatestBlsOnConfiguredStream();
        }
        if (latestBlsOnConfgiuredStream != null && previousBuildBls != null) {
            if (latestBlsOnConfgiuredStream.size() != previousBuildBls.size()) {
                return true;
            }
            for (Baseline blCurr : latestBlsOnConfgiuredStream) {
                boolean foundBl = false;
                for (Baseline blPrev : previousBuildBls) {
                    if (!blCurr.getBaselineName().equals(blPrev.getBaselineName())) continue;
                    foundBl = true;
                    break;
                }
                if (foundBl) continue;
                return true;
            }
        }
        return false;
    }

    private List<HistoryEntry> translateChangedVersionsToEnteries(List<String> changedVerionsList) throws IOException, InterruptedException {
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        StringBuilder entriesDesc = new StringBuilder();
        for (String version : changedVerionsList) {
            String versionDesc = UcmCommon.getVersionDescription(this.cleartool, version, this.getHistoryFormatHandler().getFormat() + "%c" + "\\n");
            entriesDesc.append(versionDesc + "\n");
        }
        BufferedReader buffReader = new BufferedReader(new StringReader(entriesDesc.toString()));
        try {
            this.parseLsHistory(buffReader, entries);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
        return entries;
    }

    private List<String> getChangedVersions(List<Baseline> newBls, List<Baseline> oldBls) throws IOException, InterruptedException {
        ArrayList<String> changedVersionList = new ArrayList<String>();
        for (Baseline blDesc : newBls) {
            String previousBl;
            if (!blDesc.getComponentDesc().isModifiable() || (previousBl = this.getBaseLineNameForComponent(oldBls, blDesc.getComponentName())) == null || previousBl.equals(blDesc.getBaselineName())) continue;
            String viewName = UcmDynamicCheckoutAction.getConfiguredStreamViewName(this.build.getProject().getName(), this.getStream());
            List<String> changedVersionListPerBl = UcmCommon.getDiffBlVersions(this.cleartool, this.viewDrive + "/" + viewName, previousBl, blDesc.getBaselineName());
            changedVersionList.addAll(changedVersionListPerBl);
        }
        return changedVersionList;
    }

    private String getBaseLineNameForComponent(List<Baseline> baselineList, String compName) {
        for (Baseline blDesc : baselineList) {
            if (!UcmCommon.getNoVob(blDesc.getComponentName()).equals(UcmCommon.getNoVob(compName))) continue;
            return blDesc.getBaselineName();
        }
        return null;
    }

    public String getStream() {
        return this.stream;
    }
}

