/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.AbstractClearCaseSCMRevisionState;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearCaseSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DynamicCheckoutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.SnapshotCheckoutAction;
import hudson.plugins.clearcase.base.BaseHistoryAction;
import hudson.plugins.clearcase.base.BaseSaveChangeLogAction;
import hudson.plugins.clearcase.base.ClearCaseSCMRevisionState;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCMRevisionState;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends AbstractClearCaseScm {
    private static final String DEFAULT_VALUE_WIN_DYN_STORAGE_DIR = "\\views\\dynamic";
    private String configSpec;
    private final String branch;
    private boolean doNotUpdateConfigSpec;
    private boolean useTimeRule;

    @DataBoundConstructor
    public ClearCaseSCM(String branch, String configspec, String viewTag, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename, String excludedRegions, String multiSitePollBuffer, boolean useTimeRule, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, String viewPath) {
        super(viewTag, mkviewoptionalparam, filterOutDestroySubBranchEvent, !usedynamicview && useupdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, loadRules, multiSitePollBuffer, createDynView, winDynStorageDir, unixDynStorageDir, false, false, viewPath);
        this.branch = branch;
        this.configSpec = configspec;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
        this.useTimeRule = useTimeRule;
    }

    public ClearCaseSCM(String branch, String configspec, String viewTag, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename) {
        this(branch, configspec, viewTag, useupdate, loadRules, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, doNotUpdateConfigSpec, rmviewonrename, "", null, false, false, "", "", viewTag);
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public boolean isDoNotUpdateConfigSpec() {
        return this.doNotUpdateConfigSpec;
    }

    public boolean isUseTimeRule() {
        return this.useTimeRule;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.BASE_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.isUseDynamicView()) {
            if (this.getViewDrive() != null) {
                env.put("CLEARCASE_VIEWPATH", this.getViewDrive() + File.separator + this.getNormalizedViewName());
            } else {
                env.remove("CLEARCASE_VIEWPATH");
            }
        }
    }

    protected CheckOutAction createCheckOutAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        String effectiveConfigSpec = Util.replaceMacro((String)this.configSpec, variableResolver);
        Object action = this.isUseDynamicView() ? new DynamicCheckoutAction(this.createClearTool(variableResolver, launcher), effectiveConfigSpec, this.doNotUpdateConfigSpec, this.useTimeRule, this.isCreateDynView(), this.getNormalizedWinDynStorageDir(variableResolver), this.getNormalizedUnixDynStorageDir(variableResolver), build) : new SnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), new ConfigSpec(effectiveConfigSpec, launcher.getLauncher().isUnix()), this.getViewPaths(variableResolver, build, launcher.getLauncher()), this.isUseUpdate(), this.getViewPath(variableResolver));
        return action;
    }

    protected HistoryAction createHistoryAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        BaseHistoryAction action = new BaseHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(variableResolver, build, launcher.getLauncher()), this.getDescriptor().getLogMergeTimeWindow());
        try {
            String viewName = this.generateNormalizedViewName(variableResolver);
            String pwv = ct.pwv(viewName);
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new BaseSaveChangeLogAction();
    }

    public String[] getBranchNames(VariableResolver<String> variableResolver) {
        String[] branchArray = this.branch.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = Util.replaceMacro((String)branchArray[i].replaceAll("\\\\ ", " "), variableResolver);
        }
        return branchArray;
    }

    protected ClearTool createClearTool(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamic(variableResolver, launcher, this.getViewDrive(), this.getMkviewOptionalParam());
        }
        return super.createClearTool(variableResolver, launcher);
    }

    protected boolean isFirstBuild(SCMRevisionState baseline) {
        return baseline == null || !(baseline instanceof ClearCaseSCMRevisionState);
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, build.getTime());
    }

    public SCMRevisionState calcRevisionsFromPoll(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, new Date());
    }

    private AbstractClearCaseSCMRevisionState createRevisionState(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener, Date date) throws IOException, InterruptedException {
        ClearCaseSCMRevisionState revisionState = new ClearCaseSCMRevisionState(date);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        revisionState.setLoadRules(this.getViewPaths((VariableResolver)variableResolver, build, launcher));
        return revisionState;
    }
}

