/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.AbstractClearCaseSCMRevisionState;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseChangeLogParser;
import hudson.plugins.clearcase.ClearCaseInstallation;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.DynamicCheckoutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.SnapshotCheckoutAction;
import hudson.plugins.clearcase.base.BaseHistoryAction;
import hudson.plugins.clearcase.base.BaseSaveChangeLogAction;
import hudson.plugins.clearcase.base.ClearCaseSCMRevisionState;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseSCM
extends AbstractClearCaseScm {
    private static final String DEFAULT_VALUE_WIN_DYN_STORAGE_DIR = "\\views\\dynamic";
    private String configSpec;
    private final String branch;
    private boolean doNotUpdateConfigSpec;
    private boolean useTimeRule;

    @DataBoundConstructor
    public ClearCaseSCM(String branch, String configspec, String viewTag, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename, String excludedRegions, String multiSitePollBuffer, boolean useTimeRule, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, String viewPath) {
        super(viewTag, mkviewoptionalparam, filterOutDestroySubBranchEvent, !usedynamicview && useupdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, loadRules, multiSitePollBuffer, createDynView, winDynStorageDir, unixDynStorageDir, false, false, viewPath);
        this.branch = branch;
        this.configSpec = configspec;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
        this.useTimeRule = useTimeRule;
    }

    public ClearCaseSCM(String branch, String configspec, String viewTag, boolean useupdate, String loadRules, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean doNotUpdateConfigSpec, boolean rmviewonrename) {
        this(branch, configspec, viewTag, useupdate, loadRules, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, doNotUpdateConfigSpec, rmviewonrename, "", null, false, false, "", "", viewTag);
    }

    public String getBranch() {
        return this.branch;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    public boolean isDoNotUpdateConfigSpec() {
        return this.doNotUpdateConfigSpec;
    }

    public boolean isUseTimeRule() {
        return this.useTimeRule;
    }

    public ClearCaseScmDescriptor getDescriptor() {
        return PluginImpl.BASE_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ClearCaseChangeLogParser();
    }

    @Override
    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.isUseDynamicView()) {
            if (this.getViewDrive() != null) {
                env.put("CLEARCASE_VIEWPATH", this.getViewDrive() + File.separator + this.getNormalizedViewName());
            } else {
                env.remove("CLEARCASE_VIEWPATH");
            }
        }
    }

    @Override
    protected CheckOutAction createCheckOutAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        String effectiveConfigSpec = Util.replaceMacro((String)this.configSpec, variableResolver);
        CheckOutAction action = this.isUseDynamicView() ? new DynamicCheckoutAction(this.createClearTool(variableResolver, launcher), effectiveConfigSpec, this.doNotUpdateConfigSpec, this.useTimeRule, this.isCreateDynView(), this.getNormalizedWinDynStorageDir(variableResolver), this.getNormalizedUnixDynStorageDir(variableResolver), build) : new SnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), new ConfigSpec(effectiveConfigSpec, launcher.getLauncher().isUnix()), this.getViewPaths(variableResolver, build, launcher.getLauncher()), this.isUseUpdate(), this.getViewPath(variableResolver));
        return action;
    }

    @Override
    protected HistoryAction createHistoryAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        BaseHistoryAction action = new BaseHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(variableResolver, build, launcher.getLauncher()), this.getDescriptor().getLogMergeTimeWindow());
        try {
            String viewName = this.generateNormalizedViewName(variableResolver);
            String pwv = ct.pwv(viewName);
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    @Override
    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new BaseSaveChangeLogAction();
    }

    @Override
    public String[] getBranchNames(VariableResolver<String> variableResolver) {
        String[] branchArray = this.branch.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < branchArray.length; ++i) {
            branchArray[i] = Util.replaceMacro((String)branchArray[i].replaceAll("\\\\ ", " "), variableResolver);
        }
        return branchArray;
    }

    @Override
    protected ClearTool createClearTool(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamic(variableResolver, launcher, this.getViewDrive(), this.getMkviewOptionalParam());
        }
        return super.createClearTool(variableResolver, launcher);
    }

    @Override
    protected boolean isFirstBuild(SCMRevisionState baseline) {
        return baseline == null || !(baseline instanceof ClearCaseSCMRevisionState);
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, build.getTime());
    }

    @Override
    public SCMRevisionState calcRevisionsFromPoll(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, new Date());
    }

    private AbstractClearCaseSCMRevisionState createRevisionState(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener, Date date) throws IOException, InterruptedException {
        ClearCaseSCMRevisionState revisionState = new ClearCaseSCMRevisionState(date);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        revisionState.setLoadRules(this.getViewPaths(variableResolver, build, launcher));
        return revisionState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearCaseScmDescriptor
    extends SCMDescriptor<ClearCaseSCM>
    implements ModelObject {
        private static final int DEFAULT_CHANGE_LOG_MERGE_TIME_WINDOW = 5;
        private int changeLogMergeTimeWindow = 5;
        private String defaultViewName;
        private String defaultViewPath;
        private String defaultWinDynStorageDir;
        private String defaultUnixDynStorageDir;
        private volatile ClearCaseInstallation[] installations = new ClearCaseInstallation[0];

        public ClearCaseScmDescriptor() {
            super(ClearCaseSCM.class, null);
            this.load();
        }

        public int getLogMergeTimeWindow() {
            return this.changeLogMergeTimeWindow;
        }

        public String getCleartoolExe() {
            String cleartoolExe;
            try {
                cleartoolExe = this.getCleartoolExe(Computer.currentComputer().getNode(), TaskListener.NULL);
            }
            catch (Exception e) {
                cleartoolExe = "cleartool";
            }
            return cleartoolExe;
        }

        public String getCleartoolExe(Node node, TaskListener listener) throws IOException, InterruptedException {
            return ((ClearCaseInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(ClearCaseInstallation.DescriptorImpl.class)).getInstallation().getCleartoolExe(node, listener);
        }

        public String getDefaultViewName() {
            return StringUtils.defaultString((String)this.defaultViewName, (String)"${USER_NAME}_${NODE_NAME}_${JOB_NAME}_hudson");
        }

        public String getDefaultViewPath() {
            return StringUtils.defaultString((String)this.defaultViewPath, (String)"view");
        }

        public String getDefaultWinDynStorageDir() {
            if (this.defaultWinDynStorageDir == null) {
                try {
                    return "\\\\" + InetAddress.getLocalHost().getHostName() + ClearCaseSCM.DEFAULT_VALUE_WIN_DYN_STORAGE_DIR;
                }
                catch (UnknownHostException e) {
                    return "";
                }
            }
            return this.defaultWinDynStorageDir;
        }

        public String getDefaultUnixDynStorageDir() {
            return this.defaultUnixDynStorageDir;
        }

        public String getDisplayName() {
            return "Base ClearCase";
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            this.defaultViewName = Util.fixEmpty((String)req.getParameter("clearcase.defaultViewName").trim());
            this.defaultViewPath = Util.fixEmpty((String)req.getParameter("clearcase.defaultViewPath").trim());
            this.defaultWinDynStorageDir = Util.fixEmpty((String)req.getParameter("clearcase.defaultWinDynStorageDir").trim());
            this.defaultUnixDynStorageDir = Util.fixEmpty((String)req.getParameter("clearcase.defaultUnixDynStorageDir").trim());
            String mergeTimeWindow = Util.fixEmpty((String)req.getParameter("clearcase.logmergetimewindow"));
            if (mergeTimeWindow != null) {
                try {
                    this.changeLogMergeTimeWindow = DecimalFormat.getIntegerInstance().parse(mergeTimeWindow).intValue();
                }
                catch (ParseException e) {
                    this.changeLogMergeTimeWindow = 5;
                }
            } else {
                this.changeLogMergeTimeWindow = 5;
            }
            this.save();
            return true;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ClearCaseSCM scm = new ClearCaseSCM(req.getParameter("cc.branch"), req.getParameter("cc.configspec"), req.getParameter("cc.viewname"), req.getParameter("cc.useupdate") != null, req.getParameter("cc.loadrules"), req.getParameter("cc.usedynamicview") != null, req.getParameter("cc.viewdrive"), req.getParameter("cc.mkviewoptionalparam"), req.getParameter("cc.filterOutDestroySubBranchEvent") != null, req.getParameter("cc.doNotUpdateConfigSpec") != null, req.getParameter("cc.rmviewonrename") != null, req.getParameter("cc.excludedRegions"), Util.fixEmpty((String)req.getParameter("cc.multiSitePollBuffer")), req.getParameter("cc.useTimeRule") != null, req.getParameter("cc.createDynView") != null, req.getParameter("cc.winDynStorageDir"), req.getParameter("cc.unixDynStorageDir"), req.getParameter("cc.viewpath"));
            return scm;
        }

        public FormValidation doCleartoolExeCheck(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateExecutable((String)value);
        }

        public FormValidation doExcludedRegionsCheck(@QueryParameter String value) throws IOException, ServletException {
            String v = Util.fixEmptyAndTrim((String)value);
            if (v != null) {
                String[] regions;
                for (String region : regions = v.split("[\\r\\n]+")) {
                    try {
                        Pattern.compile(region);
                    }
                    catch (PatternSyntaxException e) {
                        return FormValidation.error((String)("Invalid regular expression. " + e.getMessage()));
                    }
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doConfigSpecCheck(@QueryParameter String value) throws IOException, ServletException {
            String v = Util.fixEmpty((String)value);
            if (v == null || v.length() == 0) {
                return FormValidation.error((String)"Config spec is mandatory");
            }
            for (String cSpecLine : v.split("[\\r\\n]+")) {
                if (!cSpecLine.startsWith("load ")) continue;
                return FormValidation.error((String)"Config spec can not contain load rules");
            }
            return FormValidation.ok();
        }

        public FormValidation doMandatoryCheck(@QueryParameter String value, @QueryParameter String errorText) throws IOException, ServletException {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Util.fixEmpty((String)errorText));
            }
            return FormValidation.ok();
        }

        public void doVersion(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteBuffer baos = new ByteBuffer();
            try {
                Hudson.getInstance().createLauncher(TaskListener.NULL).launch().cmds(new String[]{this.getCleartoolExe(), "-version"}).stdout((OutputStream)baos).join();
                rsp.setContentType("text/plain");
                baos.writeTo((OutputStream)rsp.getOutputStream());
            }
            catch (IOException e) {
                req.setAttribute("error", (Object)e);
                rsp.forward((Object)this, "versionCheckError", req);
            }
        }

        public void doListViews(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Hudson.getInstance().createLauncher(TaskListener.NULL).launch().cmds(new String[]{this.getCleartoolExe(), "lsview", "-short"}).stdout((OutputStream)baos).join();
            rsp.setContentType("text/plain");
            rsp.getOutputStream().println("ClearCase Views found:\n");
            baos.writeTo((OutputStream)rsp.getOutputStream());
        }

        public ClearCaseInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(ClearCaseInstallation[] installations) {
            this.installations = installations;
            this.save();
        }
    }
}

