/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.AbstractClearCaseSCMRevisionState;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearCaseSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.ucm.ClearCaseUCMSCMRevisionState;
import hudson.plugins.clearcase.ucm.FreezeCodeUcmHistoryAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogParser;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.plugins.clearcase.ucm.UcmHistoryAction;
import hudson.plugins.clearcase.ucm.UcmSaveChangeLogAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private static final String STREAM_PREFIX = "stream:";
    private static final String AUTO_ALLOCATE_VIEW_NAME = "${STREAM}_${JOB_NAME}_bs_hudson_view";
    private final String stream;
    private final String overrideBranchName;
    private boolean allocateViewName;
    private boolean useManualLoadRules;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewTag, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions, String multiSitePollBuffer, String overrideBranchName, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, boolean freezeCode, boolean recreateView, boolean allocateViewName, String viewPath, boolean useManualLoadRules) {
        super(viewTag, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, useManualLoadRules ? loadrules : null, multiSitePollBuffer, createDynView, winDynStorageDir, unixDynStorageDir, freezeCode, recreateView, viewPath);
        this.stream = this.shortenStreamName(stream);
        this.allocateViewName = allocateViewName;
        this.overrideBranchName = overrideBranchName;
        this.useManualLoadRules = useManualLoadRules ? useManualLoadRules : StringUtils.isNotBlank((String)loadrules);
        Validate.notEmpty((String)this.stream, (String)"The stream selector cannot be empty");
    }

    @Deprecated
    public ClearCaseUcmSCM(String stream, String loadrules, String viewTag, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename) {
        this(stream, loadrules, viewTag, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, "", null, "", false, null, null, false, false, false, viewTag, StringUtils.isBlank((String)loadrules));
    }

    public String getStream() {
        return this.stream;
    }

    public String getStream(VariableResolver<String> variableResolver) {
        return Util.replaceMacro((String)this.stream, variableResolver);
    }

    public boolean isAllocateViewName() {
        return this.allocateViewName;
    }

    public void setAllocateViewName(boolean allocateViewName) {
        this.allocateViewName = allocateViewName;
    }

    public String getOverrideBranchName() {
        return this.overrideBranchName;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new UcmChangeLogParser();
    }

    public boolean isUseManualLoadRules() {
        return this.useManualLoadRules;
    }

    @Override
    public String[] getBranchNames(VariableResolver<String> variableResolver) {
        String override = Util.replaceMacro((String)this.overrideBranchName, variableResolver);
        if (StringUtils.isNotEmpty((String)override)) {
            return new String[]{override};
        }
        return new String[]{UcmCommon.getNoVob(this.getStream(variableResolver))};
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, this.getBuildTime((Run<?, ?>)build));
    }

    @Override
    public SCMRevisionState calcRevisionsFromPoll(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, new Date());
    }

    private AbstractClearCaseSCMRevisionState createRevisionState(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener, Date date) throws IOException, InterruptedException {
        ClearTool clearTool = this.createClearTool(build, launcher);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        String resolvedStream = this.getStream(variableResolver);
        ClearCaseUCMSCMRevisionState revisionState = new ClearCaseUCMSCMRevisionState(UcmCommon.getFoundationBaselines(clearTool, resolvedStream), date, resolvedStream);
        revisionState.setLoadRules(this.getViewPaths(variableResolver, build, launcher));
        return revisionState;
    }

    @Override
    protected boolean isFirstBuild(SCMRevisionState baseline) {
        return baseline == null || !(baseline instanceof ClearCaseUCMSCMRevisionState);
    }

    @Override
    public String generateNormalizedViewName(VariableResolver<String> variableResolver, String modViewName) {
        if (this.allocateViewName) {
            modViewName = AUTO_ALLOCATE_VIEW_NAME.replace("${STREAM}", UcmCommon.getNoVob(this.getStream(variableResolver)));
        }
        return super.generateNormalizedViewName(variableResolver, modViewName);
    }

    @Override
    protected CheckOutAction createCheckOutAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        CheckOutAction action = this.isUseDynamicView() ? new UcmDynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(variableResolver), this.isCreateDynView(), this.getNormalizedWinDynStorageDir(variableResolver), this.getNormalizedUnixDynStorageDir(variableResolver), build, this.isFreezeCode(), this.isRecreateView()) : new UcmSnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(variableResolver), this.getViewPaths(variableResolver, build, launcher.getLauncher()), this.isUseUpdate(), this.getViewPath(variableResolver));
        return action;
    }

    @Override
    protected HistoryAction createHistoryAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        ClearCaseUCMSCMRevisionState oldBaseline = null;
        ClearCaseUCMSCMRevisionState newBaseline = null;
        PrintStream logger = launcher.getListener().getLogger();
        if (build != null) {
            try {
                AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
                if (previousBuild != null) {
                    oldBaseline = (ClearCaseUCMSCMRevisionState)((AbstractBuild)build.getPreviousBuild()).getAction(ClearCaseUCMSCMRevisionState.class);
                }
                newBaseline = (ClearCaseUCMSCMRevisionState)this.calcRevisionsFromBuild(build, launcher.getLauncher(), launcher.getListener());
            }
            catch (IOException e) {
                Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.SEVERE, "IOException when calculating revisions'", e);
                e.printStackTrace(logger);
                return null;
            }
            catch (InterruptedException e) {
                Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.SEVERE, "InterruptedException when calculating revisions'", e);
                e.printStackTrace(logger);
                return null;
            }
        }
        UcmHistoryAction action = this.isFreezeCode() ? new FreezeCodeUcmHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(variableResolver, build, launcher.getLauncher()), this.getStream(variableResolver), this.getViewDrive(), build, oldBaseline, newBaseline) : new UcmHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(variableResolver, build, launcher.getLauncher()), oldBaseline, newBaseline);
        try {
            String pwv = ct.pwv(this.generateNormalizedViewName((BuildVariableResolver)variableResolver));
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    @Override
    public String[] getViewPaths(VariableResolver<String> variableResolver, AbstractBuild build, Launcher launcher) throws IOException, InterruptedException {
        if (!this.useManualLoadRules) {
            String[] lr;
            AbstractClearCaseSCMRevisionState revisionState = (AbstractClearCaseSCMRevisionState)build.getAction(ClearCaseUCMSCMRevisionState.class);
            if (revisionState != null && (lr = revisionState.getLoadRules()) != null) {
                return lr;
            }
            ClearTool clearTool = this.createClearTool(build, launcher);
            List<Baseline> latest = UcmCommon.getLatestBaselines(clearTool, this.getStream(variableResolver));
            return UcmCommon.generateLoadRulesFromBaselines(clearTool, this.getStream(variableResolver), latest);
        }
        return super.getViewPaths(variableResolver, build, launcher);
    }

    @Override
    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new UcmSaveChangeLogAction();
    }

    @Override
    public ClearTool createClearTool(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamic(variableResolver, launcher, this.getViewDrive(), this.getMkviewOptionalParam());
        }
        return super.createClearTool(variableResolver, launcher);
    }

    public ClearTool createClearTool(AbstractBuild<?, ?> build, Launcher launcher) {
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher(launcher.getListener(), build.getWorkspace(), launcher);
        return this.createClearTool(variableResolver, clearToolLauncher);
    }

    private String shortenStreamName(String longStream) {
        if (StringUtils.startsWith((String)longStream, (String)STREAM_PREFIX)) {
            return StringUtils.substringAfter((String)longStream, (String)STREAM_PREFIX);
        }
        return longStream;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearCaseUcmScmDescriptor
    extends SCMDescriptor<ClearCaseUcmSCM>
    implements ModelObject {
        private ClearCaseSCM.ClearCaseScmDescriptor baseDescriptor;

        public ClearCaseUcmScmDescriptor(ClearCaseSCM.ClearCaseScmDescriptor baseDescriptor) {
            super(ClearCaseUcmSCM.class, null);
            this.baseDescriptor = baseDescriptor;
            this.load();
        }

        public String getDefaultViewName() {
            return this.baseDescriptor.getDefaultViewName();
        }

        public String getDefaultViewPath() {
            return this.baseDescriptor.getDefaultViewPath();
        }

        public String getDisplayName() {
            return "UCM ClearCase";
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            return true;
        }

        public String getDefaultWinDynStorageDir() {
            return this.baseDescriptor.getDefaultWinDynStorageDir();
        }

        public String getDefaultUnixDynStorageDir() {
            return this.baseDescriptor.getDefaultUnixDynStorageDir();
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ClearCaseUcmSCM scm = new ClearCaseUcmSCM(req.getParameter("ucm.stream"), req.getParameter("ucm.loadrules"), req.getParameter("ucm.viewname"), req.getParameter("ucm.usedynamicview") != null, req.getParameter("ucm.viewdrive"), req.getParameter("ucm.mkviewoptionalparam"), req.getParameter("ucm.filterOutDestroySubBranchEvent") != null, req.getParameter("ucm.useupdate") != null, req.getParameter("ucm.rmviewonrename") != null, req.getParameter("ucm.excludedRegions"), Util.fixEmpty((String)req.getParameter("ucm.multiSitePollBuffer")), req.getParameter("ucm.overrideBranchName"), req.getParameter("ucm.createDynView") != null, req.getParameter("ucm.winDynStorageDir"), req.getParameter("ucm.unixDynStorageDir"), req.getParameter("ucm.freezeCode") != null, req.getParameter("ucm.recreateView") != null, req.getParameter("ucm.allocateViewName") != null, req.getParameter("ucm.viewpath"), req.getParameter("ucm.useManualLoadRules") != null);
            return scm;
        }
    }
}

