/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;

public class SnapshotCheckoutAction
extends AbstractCheckoutAction {
    private final ConfigSpec configSpec;

    public SnapshotCheckoutAction(ClearTool cleartool, ConfigSpec configSpec, String[] loadRules, boolean useUpdate, String viewPath) {
        super(cleartool, loadRules, useUpdate, viewPath);
        this.configSpec = configSpec;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewTag) throws IOException, InterruptedException {
        boolean viewCreated = this.cleanAndCreateViewIfNeeded(workspace, viewTag, this.viewPath, null);
        boolean needSetCs = true;
        AbstractCheckoutAction.LoadRulesDelta loadRulesDelta = null;
        if (!viewCreated) {
            ConfigSpec viewConfigSpec = new ConfigSpec(this.cleartool.catcs(viewTag), launcher.isUnix());
            loadRulesDelta = this.getLoadRulesDelta(viewConfigSpec.getLoadRules(), launcher);
            boolean bl = needSetCs = !this.configSpec.stripLoadRules().equals(viewConfigSpec.stripLoadRules()) || !ArrayUtils.isEmpty((Object[])loadRulesDelta.getRemoved());
        }
        if (needSetCs) {
            try {
                this.cleartool.setcs(this.viewPath, ClearTool.SetcsOption.CONFIGSPEC, this.configSpec.setLoadRules(this.loadRules).getRaw());
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        Object[] addedLoadRules = loadRulesDelta.getAdded();
        if (!ArrayUtils.isEmpty((Object[])addedLoadRules)) {
            try {
                this.cleartool.update(this.viewPath, (String[])addedLoadRules);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        if (!viewCreated) {
            try {
                this.cleartool.setcs(this.viewPath, ClearTool.SetcsOption.CURRENT, null);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        return true;
    }

    public ConfigSpec getConfigSpec() {
        return this.configSpec;
    }
}

