/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.history.AbstractHistoryAction;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import hudson.plugins.clearcase.ucm.ClearCaseUCMSCMRevisionState;
import hudson.plugins.clearcase.ucm.UcmActivity;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.plugins.clearcase.util.ClearToolFormatHandler;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmHistoryAction
extends AbstractHistoryAction {
    private static final String[] HISTORY_FORMAT = new String[]{"%Nd", "%u", "%En", "%Vn", "%e", "%o", "%[activity]p"};
    private static final String[] ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u"};
    private static final String[] INTEGRATION_ACTIVITY_FORMAT = new String[]{"%[headline]p", "%[stream]p", "%u", "%[contrib_acts]p"};
    private final ClearToolFormatHandler historyHandler = new ClearToolFormatHandler(HISTORY_FORMAT);
    private final ClearCaseUCMSCMRevisionState oldBaseline;
    private final ClearCaseUCMSCMRevisionState newBaseline;

    public UcmHistoryAction(ClearTool cleartool, boolean useDynamicView, Filter filter, ClearCaseUCMSCMRevisionState oldBaseline, ClearCaseUCMSCMRevisionState newBaseline) {
        super(cleartool, useDynamicView, filter);
        this.oldBaseline = oldBaseline;
        this.newBaseline = newBaseline;
    }

    @Override
    protected List<? extends ChangeLogSet.Entry> buildChangelog(String viewPath, List<HistoryEntry> entries) throws IOException, InterruptedException {
        ArrayList<UcmActivity> result = new ArrayList<UcmActivity>();
        HashMap<String, UcmActivity> activityMap = new HashMap<String, UcmActivity>();
        for (HistoryEntry entry : entries) {
            UcmActivity activity = (UcmActivity)((Object)activityMap.get(entry.getActivityName()));
            if (activity == null) {
                activity = new UcmActivity();
                activity.setName(entry.getActivityName());
                activity.setUser(entry.getUser());
                activityMap.put(entry.getActivityName(), activity);
                result.add(activity);
            }
            UcmActivity.File currentFile = new UcmActivity.File();
            currentFile.setComment(entry.getComment());
            currentFile.setDate(entry.getDate());
            currentFile.setDateStr(entry.getDateText());
            currentFile.setEvent(entry.getEvent());
            currentFile.setName(entry.getElement());
            currentFile.setOperation(entry.getOperation());
            currentFile.setVersion(entry.getVersionId());
            activity.addFile(currentFile);
        }
        for (UcmActivity activity : result) {
            this.callLsActivity(activityMap, activity, viewPath, 3);
        }
        return result;
    }

    private void callLsActivity(Map<String, UcmActivity> activityMap, UcmActivity activity, String viewPath, int numberOfContributingActivitiesToFollow) throws IOException, InterruptedException {
        ClearToolFormatHandler handler = new ClearToolFormatHandler(activity.isIntegrationActivity() ? INTEGRATION_ACTIVITY_FORMAT : ACTIVITY_FORMAT);
        if (StringUtils.isBlank((String)activity.getName())) {
            activity.setName("Unable to get activity name");
            return;
        }
        BufferedReader reader = new BufferedReader(this.cleartool.lsactivity(activity.getName(), handler.getFormat(), viewPath));
        String line = reader.readLine();
        Matcher matcher = handler.checkLine(line);
        if (matcher != null) {
            activity.setHeadline(matcher.group(1));
            activity.setStream(matcher.group(2));
            activity.setUser(matcher.group(3));
            if (activity.isIntegrationActivity() && numberOfContributingActivitiesToFollow > 0) {
                String contributingActivities = matcher.group(4);
                for (String contributing : contributingActivities.split(" ")) {
                    UcmActivity subActivity = null;
                    UcmActivity cachedActivity = activityMap.get(contributing);
                    if (cachedActivity == null) {
                        subActivity = new UcmActivity();
                        subActivity.setName(contributing);
                        this.callLsActivity(activityMap, subActivity, viewPath, --numberOfContributingActivitiesToFollow);
                        activityMap.put(contributing, subActivity);
                    } else {
                        subActivity = new UcmActivity(cachedActivity);
                    }
                    activity.addSubActivity(subActivity);
                }
            }
        }
        reader.close();
    }

    @Override
    protected List<HistoryEntry> runLsHistory(Date sinceTime, String viewPath, String viewTag, String[] branchNames, String[] viewPaths) throws IOException, InterruptedException {
        List<Baseline> newBaselines;
        List<HistoryEntry> history = super.runLsHistory(sinceTime, viewPath, viewTag, branchNames, viewPaths);
        if (this.oldBaseline == null) {
            return history;
        }
        List<Baseline> oldBaselines = this.oldBaseline.getBaselines();
        if (ObjectUtils.equals(oldBaselines, newBaselines = this.newBaseline.getBaselines())) {
            return history;
        }
        for (Baseline oldBl : oldBaselines) {
            String bl1 = oldBl.getBaselineName();
            final String comp1 = oldBl.getComponentName();
            Baseline newBl = (Baseline)CollectionUtils.find(newBaselines, (Predicate)new Predicate(){

                public boolean evaluate(Object bl) {
                    return StringUtils.equals((String)comp1, (String)((Baseline)bl).getComponentName());
                }
            });
            if (newBl == null) {
                this.cleartool.getLauncher().getListener().getLogger().print("Old Baseline " + bl1 + " for component " + comp1 + " couldn't be found in the new set of baselines.");
                continue;
            }
            String bl2 = newBl.getBaselineName();
            if (StringUtils.equals((String)bl1, (String)bl2)) continue;
            List<String> versions = UcmCommon.getDiffBlVersions(this.cleartool, viewPath, "baseline:" + bl1, "baseline:" + bl2);
            for (String version : versions) {
                try {
                    this.parseLsHistory(new BufferedReader(this.cleartool.describe(this.getHistoryFormatHandler().getFormat() + "%c" + "\\n", version)), history);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return history;
    }

    @Override
    protected ClearToolFormatHandler getHistoryFormatHandler() {
        return this.historyHandler;
    }

    @Override
    protected HistoryEntry parseEventLine(Matcher matcher, String line) throws ParseException {
        HistoryEntry entry = new HistoryEntry();
        entry.setLine(line);
        entry.setDateText(matcher.group(1));
        entry.setUser(matcher.group(2).trim());
        entry.setElement(matcher.group(3).trim());
        entry.setVersionId(matcher.group(4).trim());
        entry.setEvent(matcher.group(5).trim());
        entry.setOperation(matcher.group(6).trim());
        entry.setActivityName(matcher.group(7).trim());
        return entry;
    }
}

