/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmMakeBaseline
extends Notifier {
    private static final String ENV_CC_BASELINE_NAME = "CC_BASELINE_NAME";
    private static final Logger LOGGER = Logger.getLogger(UcmMakeBaseline.class.getName());
    private transient List<String> readWriteComponents = null;
    private transient List<String> latestBaselines = new ArrayList<String>();
    private transient List<Baseline> createdBaselines = null;
    private final String namePattern;
    private final String commentPattern;
    private final boolean lockStream;
    private final boolean recommend;
    private transient boolean streamSuccessfullyLocked;
    private final boolean fullBaseline;
    private final boolean identical;
    private final String dynamicViewName;
    private final boolean rebaseDynamicView;

    public String getCommentPattern() {
        return this.commentPattern;
    }

    public boolean isLockStream() {
        return this.lockStream;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public boolean isRecommend() {
        return this.recommend;
    }

    public boolean isFullBaseline() {
        return this.fullBaseline;
    }

    public boolean isIdentical() {
        return this.identical;
    }

    public String getDynamicViewName() {
        return this.dynamicViewName;
    }

    public boolean isRebaseDynamicView() {
        return this.rebaseDynamicView;
    }

    public List<String> getReadWriteComponents() {
        return this.readWriteComponents;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public UcmMakeBaseline(String namePattern, String commentPattern, boolean lock, boolean recommend, boolean fullBaseline, boolean identical, boolean rebaseDynamicView, String dynamicViewName) {
        this.namePattern = namePattern;
        this.commentPattern = commentPattern;
        this.lockStream = lock;
        this.recommend = recommend;
        this.fullBaseline = fullBaseline;
        this.identical = identical;
        this.rebaseDynamicView = rebaseDynamicView;
        this.dynamicViewName = dynamicViewName;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        SCM scm = build.getProject().getScm();
        if (scm instanceof ClearCaseUcmSCM) {
            ClearCaseUcmSCM ucm = (ClearCaseUcmSCM)scm;
            Launcher launcher = Executor.currentExecutor().getOwner().getNode().createLauncher((TaskListener)listener);
            BuildVariableResolver variableResolver = new BuildVariableResolver(build);
            ClearTool clearTool = ucm.createClearTool(variableResolver, ucm.createClearToolLauncher((TaskListener)listener, build.getWorkspace(), launcher));
            if (this.lockStream) {
                try {
                    this.streamSuccessfullyLocked = this.lockStream(clearTool, ucm.getStream());
                    if (!this.streamSuccessfullyLocked) {
                        listener.fatalError("Failed to lock stream");
                    }
                }
                catch (Exception ex) {
                    listener.fatalError("Failed to lock stream: " + ex);
                    return false;
                }
            }
            try {
                String viewTag = ucm.getViewName(variableResolver);
                this.readWriteComponents = this.getReadWriteComponent(clearTool, viewTag);
                if (!this.readWriteComponents.isEmpty()) {
                    this.createdBaselines = this.makeBaseline(clearTool, viewTag, variableResolver);
                    this.latestBaselines = this.getLatestBaselineNames(clearTool, viewTag);
                    this.addBuildParameter(build);
                }
            }
            catch (Exception ex) {
                listener.getLogger().println("Failed to create baseline: " + ex);
                return false;
            }
            return true;
        }
        listener.fatalError("Not a UCM clearcase SCM, cannot create baseline");
        return false;
    }

    private void addBuildParameter(AbstractBuild<?, ?> build) {
        if (!CollectionUtils.isEmpty(this.latestBaselines)) {
            ArrayList<StringParameterValue> parameters = new ArrayList<StringParameterValue>();
            String baselineName = this.latestBaselines.get(0);
            parameters.add(new StringParameterValue(ENV_CC_BASELINE_NAME, baselineName));
            build.addAction((Action)new ParametersAction(parameters));
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SCM scm = build.getProject().getScm();
        if (scm instanceof ClearCaseUcmSCM) {
            ClearCaseUcmSCM ucm = (ClearCaseUcmSCM)scm;
            BuildVariableResolver variableResolver = new BuildVariableResolver(build);
            ClearTool clearTool = ucm.createClearTool(variableResolver, ucm.createClearToolLauncher((TaskListener)listener, build.getWorkspace(), launcher));
            Result result = build.getResult();
            if (result.equals(Result.SUCCESS)) {
                for (String baselineName : this.latestBaselines) {
                    this.promoteBaselineToBuiltLevel(clearTool, baselineName);
                }
                if (this.recommend) {
                    this.recommendBaseline(clearTool, ucm.getStream());
                }
                if (this.rebaseDynamicView) {
                    for (String baseline : this.latestBaselines) {
                        this.rebaseDynamicView(clearTool, Util.replaceMacro((String)this.dynamicViewName, (VariableResolver)variableResolver), baseline);
                    }
                }
            } else if (result.equals(Result.FAILURE)) {
                ArrayList<String> alreadyRejected = new ArrayList<String>();
                for (Baseline baseline : this.createdBaselines) {
                    String realBaselineName = null;
                    for (String fullBaselineName : this.latestBaselines) {
                        if (!fullBaselineName.startsWith(baseline.getBaselineName()) || alreadyRejected.contains(fullBaselineName)) continue;
                        realBaselineName = fullBaselineName;
                    }
                    if (realBaselineName == null) {
                        listener.getLogger().println("Couldn't find baseline name for " + baseline.getBaselineName());
                        continue;
                    }
                    this.demoteBaselineToRejectedLevel(clearTool, realBaselineName);
                    alreadyRejected.add(realBaselineName);
                }
            }
            if (this.lockStream && this.streamSuccessfullyLocked) {
                this.unlockStream(clearTool, ucm.getStream());
            }
        } else {
            listener.fatalError("Not a UCM clearcase SCM, cannot create baseline");
            return false;
        }
        return true;
    }

    private void rebaseDynamicView(ClearTool clearTool, String viewTag, String baselineName) throws InterruptedException, IOException {
        clearTool.rebaseDynamic(viewTag, baselineName);
    }

    private void unlockStream(ClearTool clearTool, String stream) throws IOException, InterruptedException {
        clearTool.unlock("Unlocked by Hudson", "stream:" + stream);
    }

    private boolean lockStream(ClearTool clearTool, String stream) throws IOException, InterruptedException {
        return clearTool.lock("Locked by Hudson", "stream:" + stream);
    }

    private List<Baseline> makeBaseline(ClearTool clearTool, String viewTag, VariableResolver<String> variableResolver) throws Exception {
        String baselineName = Util.replaceMacro((String)this.namePattern, variableResolver);
        String baselineComment = Util.replaceMacro((String)this.commentPattern, variableResolver);
        return clearTool.mkbl(baselineName, viewTag, baselineComment, this.fullBaseline, this.identical, this.readWriteComponents, null, null);
    }

    private void recommendBaseline(ClearTool clearTool, String stream) throws InterruptedException, IOException {
        clearTool.recommendBaseline(stream);
    }

    private void promoteBaselineToBuiltLevel(ClearTool clearTool, String baselineName) throws InterruptedException, IOException {
        clearTool.setBaselinePromotionLevel(baselineName, ClearTool.DefaultPromotionLevel.BUILT);
    }

    private void demoteBaselineToRejectedLevel(ClearTool clearTool, String baselineName) throws InterruptedException, IOException {
        clearTool.setBaselinePromotionLevel(baselineName, ClearTool.DefaultPromotionLevel.REJECTED);
    }

    private List<String> getReadWriteComponent(ClearTool clearTool, String viewTag) throws IOException, InterruptedException {
        String output = clearTool.lsproject(viewTag, "%[mod_comps]Xp");
        String prefix = "component:";
        if (StringUtils.startsWith((String)output, (String)"component:")) {
            String[] componentNamesSplit;
            ArrayList<String> componentNames = new ArrayList<String>();
            for (String componentName : componentNamesSplit = output.split(" ")) {
                String componentNameTrimmed = StringUtils.difference((String)"component:", (String)componentName).trim();
                if (!StringUtils.isNotEmpty((String)componentNameTrimmed)) continue;
                componentNames.add(componentNameTrimmed);
            }
            return componentNames;
        }
        throw new IOException(output);
    }

    private String getComponentforBaseline(ClearTool clearTool, String baselineName) throws InterruptedException, IOException {
        String prefix;
        String output = clearTool.lsbl(baselineName, "%[component]Xp");
        if (StringUtils.startsWith((String)output, (String)(prefix = "component:"))) {
            return StringUtils.difference((String)prefix, (String)output);
        }
        throw new IOException("Incorrect output. Received " + output);
    }

    private List<String> getLatestBaselineNames(ClearTool clearTool, String viewTag) throws Exception {
        String prefix;
        String output = clearTool.lsstream(null, viewTag, "%[latest_bls]Xp");
        if (StringUtils.startsWith((String)output, (String)(prefix = "baseline:"))) {
            String[] baselineNamesSplit;
            ArrayList<String> baselineNames = new ArrayList<String>();
            for (String baselineName : baselineNamesSplit = output.split(prefix)) {
                String blComp;
                String baselineNameTrimmed = baselineName.trim();
                if (!StringUtils.isNotEmpty((String)baselineNameTrimmed) || !this.readWriteComponents.contains(blComp = this.getComponentforBaseline(clearTool, baselineNameTrimmed))) continue;
                baselineNames.add(baselineNameTrimmed);
            }
            return baselineNames;
        }
        throw new Exception("Failed to get baselinename, reason: " + output);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(UcmMakeBaseline.class);
        }

        public String getDisplayName() {
            return "ClearCase UCM Makebaseline";
        }

        public Notifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            UcmMakeBaseline n = new UcmMakeBaseline(req.getParameter("mkbl.namepattern"), req.getParameter("mkbl.commentpattern"), req.getParameter("mkbl.lock") != null, req.getParameter("mkbl.recommend") != null, req.getParameter("mkbl.fullBaseline") != null, req.getParameter("mkbl.identical") != null, req.getParameter("mkbl.rebaseDynamicView") != null, req.getParameter("mkbl.dynamicViewName"));
            return n;
        }

        public String getHelpFile() {
            return "/plugin/clearcase/ucm/mkbl/help.html";
        }

        public boolean isApplicable(Class clazz) {
            return true;
        }
    }
}

