/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClearToolFormatHandler {
    private String format;
    private String patternStr;
    private int groupCount;
    private Pattern pattern;

    public ClearToolFormatHandler(String ... elements) {
        this.setPattern(elements);
    }

    public void setPattern(String ... elements) {
        StringBuilder formatBuilder = new StringBuilder();
        StringBuilder patternBuilder = new StringBuilder();
        for (String element : elements) {
            formatBuilder.append("\\\"");
            formatBuilder.append(element);
            formatBuilder.append("\\\" ");
            patternBuilder.append("\"(.*)\"\\s*");
        }
        formatBuilder.append("\\n");
        this.groupCount = elements.length;
        this.format = formatBuilder.toString();
        this.patternStr = patternBuilder.toString();
        this.pattern = Pattern.compile(this.patternStr);
    }

    public String getFormat() {
        return this.format;
    }

    public String getPattern() {
        return this.patternStr;
    }

    public Matcher checkLine(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == this.groupCount) {
            return matcher;
        }
        return null;
    }
}

