/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.AbstractClearCaseSCMRevisionState;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolDynamic;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.action.UcmDynamicCheckoutAction;
import hudson.plugins.clearcase.action.UcmSnapshotCheckoutAction;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.ucm.ClearCaseUCMSCMRevisionState;
import hudson.plugins.clearcase.ucm.FreezeCodeUcmHistoryAction;
import hudson.plugins.clearcase.ucm.UcmChangeLogParser;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.plugins.clearcase.ucm.UcmHistoryAction;
import hudson.plugins.clearcase.ucm.UcmSaveChangeLogAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCMRevisionState;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmSCM
extends AbstractClearCaseScm {
    private static final String STREAM_PREFIX = "stream:";
    private static final String AUTO_ALLOCATE_VIEW_NAME = "${STREAM}_${JOB_NAME}_bs_hudson_view";
    private final String stream;
    private final String overrideBranchName;
    private boolean allocateViewName;
    private boolean useManualLoadRules;

    @DataBoundConstructor
    public ClearCaseUcmSCM(String stream, String loadrules, String viewTag, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions, String multiSitePollBuffer, String overrideBranchName, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, boolean freezeCode, boolean recreateView, boolean allocateViewName, String viewPath, boolean useManualLoadRules) {
        super(viewTag, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, excludedRegions, usedynamicview, viewdrive, useManualLoadRules ? loadrules : null, multiSitePollBuffer, createDynView, winDynStorageDir, unixDynStorageDir, freezeCode, recreateView, viewPath);
        this.stream = this.shortenStreamName(stream);
        this.allocateViewName = allocateViewName;
        this.overrideBranchName = overrideBranchName;
        this.useManualLoadRules = useManualLoadRules ? useManualLoadRules : StringUtils.isNotBlank((String)loadrules);
        Validate.notEmpty((String)this.stream, (String)"The stream selector cannot be empty");
    }

    @Deprecated
    public ClearCaseUcmSCM(String stream, String loadrules, String viewTag, boolean usedynamicview, String viewdrive, String mkviewoptionalparam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename) {
        this(stream, loadrules, viewTag, usedynamicview, viewdrive, mkviewoptionalparam, filterOutDestroySubBranchEvent, useUpdate, rmviewonrename, "", null, "", false, null, null, false, false, false, viewTag, StringUtils.isBlank((String)loadrules));
    }

    public String getStream() {
        return this.stream;
    }

    public String getStream(VariableResolver<String> variableResolver) {
        return Util.replaceMacro((String)this.stream, variableResolver);
    }

    public boolean isAllocateViewName() {
        return this.allocateViewName;
    }

    public void setAllocateViewName(boolean allocateViewName) {
        this.allocateViewName = allocateViewName;
    }

    public String getOverrideBranchName() {
        return this.overrideBranchName;
    }

    public ClearCaseUcmScmDescriptor getDescriptor() {
        return PluginImpl.UCM_DESCRIPTOR;
    }

    public ChangeLogParser createChangeLogParser() {
        return new UcmChangeLogParser();
    }

    public boolean isUseManualLoadRules() {
        return this.useManualLoadRules;
    }

    public String[] getBranchNames(VariableResolver<String> variableResolver) {
        String override = Util.replaceMacro((String)this.overrideBranchName, variableResolver);
        if (StringUtils.isNotEmpty((String)override)) {
            return new String[]{override};
        }
        return new String[]{UcmCommon.getNoVob((String)this.getStream(variableResolver))};
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, this.getBuildTime(build));
    }

    public SCMRevisionState calcRevisionsFromPoll(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return this.createRevisionState(build, launcher, taskListener, new Date());
    }

    private AbstractClearCaseSCMRevisionState createRevisionState(AbstractBuild<?, ?> build, Launcher launcher, TaskListener taskListener, Date date) throws IOException, InterruptedException {
        ClearTool clearTool = this.createClearTool(build, launcher);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        String resolvedStream = this.getStream((VariableResolver)variableResolver);
        ClearCaseUCMSCMRevisionState revisionState = new ClearCaseUCMSCMRevisionState(UcmCommon.getFoundationBaselines((ClearTool)clearTool, (String)resolvedStream), date, resolvedStream);
        revisionState.setLoadRules(this.getViewPaths((VariableResolver)variableResolver, build, launcher));
        return revisionState;
    }

    protected boolean isFirstBuild(SCMRevisionState baseline) {
        return baseline == null || !(baseline instanceof ClearCaseUCMSCMRevisionState);
    }

    public String generateNormalizedViewName(VariableResolver<String> variableResolver, String modViewName) {
        if (this.allocateViewName) {
            modViewName = AUTO_ALLOCATE_VIEW_NAME.replace("${STREAM}", UcmCommon.getNoVob((String)this.getStream(variableResolver)));
        }
        return super.generateNormalizedViewName(variableResolver, modViewName);
    }

    protected CheckOutAction createCheckOutAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        Object action = this.isUseDynamicView() ? new UcmDynamicCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(variableResolver), this.isCreateDynView(), this.getNormalizedWinDynStorageDir(variableResolver), this.getNormalizedUnixDynStorageDir(variableResolver), build, this.isFreezeCode(), this.isRecreateView()) : new UcmSnapshotCheckoutAction(this.createClearTool(variableResolver, launcher), this.getStream(variableResolver), this.getViewPaths(variableResolver, build, launcher.getLauncher()), this.isUseUpdate(), this.getViewPath(variableResolver));
        return action;
    }

    protected HistoryAction createHistoryAction(VariableResolver<String> variableResolver, ClearToolLauncher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        ClearTool ct = this.createClearTool(variableResolver, launcher);
        ClearCaseUCMSCMRevisionState oldBaseline = null;
        ClearCaseUCMSCMRevisionState newBaseline = null;
        PrintStream logger = launcher.getListener().getLogger();
        if (build != null) {
            try {
                AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
                if (previousBuild != null) {
                    oldBaseline = (ClearCaseUCMSCMRevisionState)((AbstractBuild)build.getPreviousBuild()).getAction(ClearCaseUCMSCMRevisionState.class);
                }
                newBaseline = (ClearCaseUCMSCMRevisionState)this.calcRevisionsFromBuild(build, launcher.getLauncher(), launcher.getListener());
            }
            catch (IOException e) {
                Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.SEVERE, "IOException when calculating revisions'", e);
                e.printStackTrace(logger);
                return null;
            }
            catch (InterruptedException e) {
                Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.SEVERE, "InterruptedException when calculating revisions'", e);
                e.printStackTrace(logger);
                return null;
            }
        }
        Object action = this.isFreezeCode() ? new FreezeCodeUcmHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(variableResolver, build, launcher.getLauncher()), this.getStream(variableResolver), this.getViewDrive(), build, oldBaseline, newBaseline) : new UcmHistoryAction(ct, this.isUseDynamicView(), this.configureFilters(variableResolver, build, launcher.getLauncher()), oldBaseline, newBaseline);
        try {
            String pwv = ct.pwv(this.generateNormalizedViewName((VariableResolver)((BuildVariableResolver)variableResolver)));
            if (pwv != null) {
                pwv = pwv.contains("/") ? pwv + "/" : pwv + "\\";
                action.setExtendedViewPath(pwv);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ClearCaseUcmSCM.class.getName()).log(Level.WARNING, "Exception when running 'cleartool pwv'", e);
        }
        return action;
    }

    public String[] getViewPaths(VariableResolver<String> variableResolver, AbstractBuild build, Launcher launcher) throws IOException, InterruptedException {
        if (!this.useManualLoadRules) {
            String[] lr;
            AbstractClearCaseSCMRevisionState revisionState = (AbstractClearCaseSCMRevisionState)build.getAction(ClearCaseUCMSCMRevisionState.class);
            if (revisionState != null && (lr = revisionState.getLoadRules()) != null) {
                return lr;
            }
            ClearTool clearTool = this.createClearTool(build, launcher);
            List latest = UcmCommon.getLatestBaselines((ClearTool)clearTool, (String)this.getStream(variableResolver));
            return UcmCommon.generateLoadRulesFromBaselines((ClearTool)clearTool, (String)this.getStream(variableResolver), (List)latest);
        }
        return super.getViewPaths(variableResolver, build, launcher);
    }

    protected SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher launcher) {
        return new UcmSaveChangeLogAction();
    }

    public ClearTool createClearTool(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        if (this.isUseDynamicView()) {
            return new ClearToolDynamic(variableResolver, launcher, this.getViewDrive(), this.getMkviewOptionalParam());
        }
        return super.createClearTool(variableResolver, launcher);
    }

    public ClearTool createClearTool(AbstractBuild<?, ?> build, Launcher launcher) {
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher(launcher.getListener(), build.getWorkspace(), launcher);
        return this.createClearTool((VariableResolver)variableResolver, clearToolLauncher);
    }

    private String shortenStreamName(String longStream) {
        if (StringUtils.startsWith((String)longStream, (String)STREAM_PREFIX)) {
            return StringUtils.substringAfter((String)longStream, (String)STREAM_PREFIX);
        }
        return longStream;
    }
}

