/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.AbstractClearCaseSCMRevisionState;
import hudson.plugins.clearcase.ClearCaseDataAction;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ClearToolSnapshot;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.action.SaveChangeLogAction;
import hudson.plugins.clearcase.history.DefaultFilter;
import hudson.plugins.clearcase.history.DestroySubBranchFilter;
import hudson.plugins.clearcase.history.FieldFilter;
import hudson.plugins.clearcase.history.FileFilter;
import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.FilterChain;
import hudson.plugins.clearcase.history.HistoryAction;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.scm.ChangeLogSet;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.util.StreamTaskListener;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClearCaseScm
extends SCM {
    public static final String CLEARCASE_VIEWTAG_ENVSTR = "CLEARCASE_VIEWTAG";
    public static final String CLEARCASE_VIEWNAME_ENVSTR = "CLEARCASE_VIEWNAME";
    public static final String CLEARCASE_VIEWPATH_ENVSTR = "CLEARCASE_VIEWPATH";
    private String viewName;
    private final String mkviewOptionalParam;
    private final boolean filteringOutDestroySubBranchEvent;
    private transient ThreadLocal<String> normalizedViewName;
    private transient ThreadLocal<String> normalizedViewPath;
    private final boolean useUpdate;
    private final boolean removeViewOnRename;
    private String excludedRegions;
    private final String loadRules;
    private final boolean useDynamicView;
    private final String viewDrive;
    private int multiSitePollBuffer;
    private final boolean createDynView;
    private final String winDynStorageDir;
    private final String unixDynStorageDir;
    private final boolean freezeCode;
    private final boolean recreateView;
    private final String viewPath;

    private synchronized ThreadLocal<String> getNormalizedViewNameThreadLocalWrapper() {
        if (null == this.normalizedViewName) {
            this.normalizedViewName = new ThreadLocal();
        }
        return this.normalizedViewName;
    }

    private synchronized ThreadLocal<String> getNormalizedViewPathThreadLocalWrapper() {
        if (this.normalizedViewPath == null) {
            this.normalizedViewPath = new ThreadLocal();
        }
        return this.normalizedViewPath;
    }

    protected void setNormalizedViewName(String normalizedViewName) {
        this.getNormalizedViewNameThreadLocalWrapper().set(normalizedViewName);
    }

    protected String getNormalizedViewName() {
        return this.getNormalizedViewNameThreadLocalWrapper().get();
    }

    protected void setNormalizedViewPath(String normalizedViewPath) {
        this.getNormalizedViewPathThreadLocalWrapper().set(normalizedViewPath);
    }

    protected String getNormalizedViewPath() {
        return this.getNormalizedViewPathThreadLocalWrapper().get();
    }

    public AbstractClearCaseScm(String viewName, String mkviewOptionalParam, boolean filterOutDestroySubBranchEvent, boolean useUpdate, boolean rmviewonrename, String excludedRegions, boolean useDynamicView, String viewDrive, String loadRules, String multiSitePollBuffer, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, boolean freezeCode, boolean recreateView, String viewPath) {
        Validate.notNull((Object)viewName);
        this.viewName = viewName;
        this.mkviewOptionalParam = mkviewOptionalParam;
        this.filteringOutDestroySubBranchEvent = filterOutDestroySubBranchEvent;
        this.useUpdate = useUpdate;
        this.removeViewOnRename = rmviewonrename;
        this.excludedRegions = excludedRegions;
        this.useDynamicView = useDynamicView;
        this.viewDrive = viewDrive;
        this.loadRules = loadRules;
        if (multiSitePollBuffer != null) {
            try {
                this.multiSitePollBuffer = DecimalFormat.getIntegerInstance().parse(multiSitePollBuffer).intValue();
            }
            catch (ParseException e) {
                this.multiSitePollBuffer = 0;
            }
        } else {
            this.multiSitePollBuffer = 0;
        }
        this.createDynView = createDynView;
        this.winDynStorageDir = winDynStorageDir;
        this.unixDynStorageDir = unixDynStorageDir;
        this.freezeCode = freezeCode;
        this.recreateView = recreateView;
        this.viewPath = StringUtils.defaultIfEmpty((String)viewPath, (String)viewName);
    }

    protected abstract CheckOutAction createCheckOutAction(VariableResolver<String> var1, ClearToolLauncher var2, AbstractBuild<?, ?> var3) throws IOException, InterruptedException;

    protected abstract HistoryAction createHistoryAction(VariableResolver<String> var1, ClearToolLauncher var2, AbstractBuild<?, ?> var3) throws IOException, InterruptedException;

    protected abstract SaveChangeLogAction createSaveChangeLogAction(ClearToolLauncher var1);

    @Deprecated
    public String[] getBranchNames() {
        return this.getBranchNames((VariableResolver<String>)new VariableResolver.ByMap(new HashMap()));
    }

    public abstract String[] getBranchNames(VariableResolver<String> var1);

    public String[] getViewPaths(VariableResolver<String> variableResolver, AbstractBuild build, Launcher launcher) throws IOException, InterruptedException {
        String loadRules = this.getLoadRules();
        if (StringUtils.isBlank((String)loadRules)) {
            return null;
        }
        String[] rules = loadRules.split("[\\r\\n]+");
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i];
            if (rule.startsWith("load ")) {
                rule = rule.substring(5);
            }
            while (rule.startsWith("\\") || rule.startsWith("/")) {
                rule = rule.substring(1);
            }
            rules[i] = rule;
        }
        return rules;
    }

    public boolean isUseDynamicView() {
        return this.useDynamicView;
    }

    public int getMultiSitePollBuffer() {
        return this.multiSitePollBuffer;
    }

    public String getViewDrive() {
        return this.viewDrive;
    }

    public String getLoadRules() {
        return this.loadRules;
    }

    public boolean isCreateDynView() {
        return this.createDynView;
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return this.getModuleRoot(workspace, null);
    }

    public FilePath getModuleRoot(FilePath workspace, AbstractBuild build) {
        if (this.useDynamicView) {
            String normViewName = this.getNormalizedViewName();
            return new FilePath(workspace.getChannel(), this.viewDrive).child(normViewName);
        }
        String normViewPath = this.getNormalizedViewPath();
        if (normViewPath != null) {
            return workspace.child(normViewPath);
        }
        normViewPath = build == null ? this.getViewPath() : this.getViewPath(new BuildVariableResolver(build));
        if (normViewPath != null) {
            return workspace.child(normViewPath);
        }
        throw new IllegalStateException("View path name cannot be null. There is a bug inside AbstractClearCaseScm.");
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getViewName(VariableResolver<String> variableResolver) {
        String normalized = null;
        String v = this.getViewName();
        if (v != null) {
            normalized = Util.replaceMacro((String)v.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_"), variableResolver);
            this.setNormalizedViewName(normalized);
        }
        return normalized;
    }

    public String getWinDynStorageDir() {
        return this.winDynStorageDir;
    }

    public String getNormalizedWinDynStorageDir(VariableResolver<String> variableResolver) {
        if (variableResolver != null) {
            return Util.replaceMacro((String)this.getWinDynStorageDir(), variableResolver);
        }
        return this.getWinDynStorageDir();
    }

    public String getUnixDynStorageDir() {
        return this.unixDynStorageDir;
    }

    public String getNormalizedUnixDynStorageDir(VariableResolver<String> variableResolver) {
        if (variableResolver != null) {
            return Util.replaceMacro((String)this.getUnixDynStorageDir(), variableResolver);
        }
        return this.getUnixDynStorageDir();
    }

    public boolean isFreezeCode() {
        return this.freezeCode;
    }

    public boolean isRecreateView() {
        return this.recreateView;
    }

    public Computer getCurrentComputer() {
        return Computer.currentComputer();
    }

    public Computer getBuildComputer(AbstractBuild<?, ?> build) {
        return build.getBuiltOn().toComputer();
    }

    public String generateNormalizedViewName(AbstractBuild<?, ?> build) {
        return this.generateNormalizedViewName(new BuildVariableResolver(build));
    }

    public String generateNormalizedViewName(VariableResolver<String> variableResolver, String modViewName) {
        String generatedNormalizedViewName = Util.replaceMacro((String)modViewName, variableResolver);
        generatedNormalizedViewName = generatedNormalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
        this.setNormalizedViewName(generatedNormalizedViewName);
        return generatedNormalizedViewName;
    }

    public String generateNormalizedViewName(VariableResolver<String> variableResolver) {
        return this.generateNormalizedViewName(variableResolver, this.viewName);
    }

    public String getMkviewOptionalParam() {
        return this.mkviewOptionalParam;
    }

    public boolean isFilteringOutDestroySubBranchEvent() {
        return this.filteringOutDestroySubBranchEvent;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        VariableResolver.Union variableResolver = new VariableResolver.Union(new VariableResolver[]{new BuildVariableResolver(build, true), new VariableResolver.ByMap(env)});
        String normalizedViewName = this.getViewName((VariableResolver<String>)variableResolver);
        String normalizedViewPath = this.getViewPath((VariableResolver<String>)variableResolver);
        if (normalizedViewName != null) {
            env.put(CLEARCASE_VIEWTAG_ENVSTR, normalizedViewName);
        }
        if (normalizedViewPath != null) {
            env.put(CLEARCASE_VIEWNAME_ENVSTR, normalizedViewPath);
            if (this.isUseDynamicView()) {
                env.put("CLEARCASE_VIEWPATH_ENVSTR", this.viewDrive + File.separator + normalizedViewPath);
            } else {
                String workspace = env.get("WORKSPACE");
                if (workspace != null) {
                    env.put(CLEARCASE_VIEWPATH_ENVSTR, workspace + File.separator + normalizedViewPath);
                }
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        build.addAction((Action)this.calcRevisionsFromBuild(build, launcher, (TaskListener)listener));
        ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        CheckOutAction checkoutAction = this.createCheckOutAction(variableResolver, clearToolLauncher, build);
        SaveChangeLogAction saveChangeLogAction = this.createSaveChangeLogAction(clearToolLauncher);
        String coNormalizedViewName = this.getViewName(variableResolver);
        build.addAction((Action)new ClearCaseDataAction());
        boolean computeChangeLogAfterCheckout = false;
        boolean returnValue = true;
        if (build.getPreviousBuild() != null) {
            if (checkoutAction.isViewValid(launcher, workspace, coNormalizedViewName)) {
                returnValue = this.saveChangeLog(build, launcher, listener, changelogFile, clearToolLauncher, variableResolver, saveChangeLogAction, coNormalizedViewName, returnValue);
            } else {
                computeChangeLogAfterCheckout = true;
            }
        }
        if (!checkoutAction.checkout(launcher, workspace, coNormalizedViewName)) {
            throw new AbortException();
        }
        if (computeChangeLogAfterCheckout) {
            returnValue = this.saveChangeLog(build, launcher, listener, changelogFile, clearToolLauncher, variableResolver, saveChangeLogAction, coNormalizedViewName, returnValue);
        }
        return returnValue;
    }

    private boolean saveChangeLog(AbstractBuild build, Launcher launcher, BuildListener listener, File changelogFile, ClearToolLauncher clearToolLauncher, VariableResolver<String> variableResolver, SaveChangeLogAction saveChangeLogAction, String coNormalizedViewName, boolean returnValue) throws IOException, InterruptedException {
        Run prevBuild = build.getPreviousBuild();
        Date lastBuildTime = this.getBuildTime(prevBuild);
        HistoryAction historyAction = this.createHistoryAction(variableResolver, clearToolLauncher, build);
        List<? extends ChangeLogSet.Entry> changelogEntries = historyAction.getChanges(lastBuildTime, this.getViewPath(variableResolver), coNormalizedViewName, this.getBranchNames(variableResolver), this.getViewPaths(variableResolver, build, launcher));
        if (CollectionUtils.isEmpty(changelogEntries)) {
            returnValue = this.createEmptyChangeLog(changelogFile, listener, "changelog");
        } else {
            saveChangeLogAction.saveChangeLog(changelogFile, changelogEntries);
        }
        return returnValue;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        if (this.isFirstBuild(baseline)) {
            return PollingResult.BUILD_NOW;
        }
        AbstractClearCaseSCMRevisionState ccBaseline = (AbstractClearCaseSCMRevisionState)baseline;
        AbstractBuild build = project.getSomeBuildWithWorkspace();
        if (build == null) {
            return PollingResult.BUILD_NOW;
        }
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        HistoryAction historyAction = this.createHistoryAction(variableResolver, this.createClearToolLauncher(listener, workspace, launcher), build);
        String viewPath = this.getViewPath(variableResolver);
        String viewName = this.getViewName(variableResolver);
        String[] branchNames = this.getBranchNames(variableResolver);
        PollingResult.Change change = historyAction.hasChanges(ccBaseline.getBuildTime(), viewPath, viewName, branchNames, ccBaseline.getLoadRules()) ? PollingResult.Change.SIGNIFICANT : PollingResult.Change.NONE;
        return new PollingResult(baseline, this.calcRevisionsFromPoll(build, launcher, listener), change);
    }

    protected abstract boolean isFirstBuild(SCMRevisionState var1);

    public abstract SCMRevisionState calcRevisionsFromPoll(AbstractBuild<?, ?> var1, Launcher var2, TaskListener var3) throws IOException, InterruptedException;

    protected Date getBuildTime(Run<?, ?> lastBuild) {
        Date buildTime = lastBuild.getTimestamp().getTime();
        if (this.getMultiSitePollBuffer() != 0) {
            long lastBuildMilliSecs = lastBuild.getTimestamp().getTimeInMillis();
            buildTime = new Date(lastBuildMilliSecs - 60000L * (long)this.getMultiSitePollBuffer());
        }
        return buildTime;
    }

    public ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
        return new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), this.getDescriptor().getDisplayName(), listener, workspace, launcher);
    }

    protected ClearTool createClearTool(VariableResolver<String> variableResolver, ClearToolLauncher launcher) {
        return new ClearToolSnapshot(variableResolver, launcher, this.mkviewOptionalParam);
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) throws IOException, InterruptedException {
        if (node == null) {
            return true;
        }
        StreamTaskListener listener = StreamTaskListener.fromStdout();
        Launcher launcher = node.createLauncher((TaskListener)listener);
        ClearTool ct = this.createClearTool(null, this.createClearToolLauncher((TaskListener)listener, project.getSomeWorkspace().getParent().getParent(), launcher));
        try {
            if (this.isUseDynamicView() && !this.isCreateDynView()) {
                return true;
            }
            AbstractBuild latestBuildOnNode = null;
            for (AbstractBuild build : project.getBuilds()) {
                if (!node.equals(build.getBuiltOn())) continue;
                latestBuildOnNode = build;
                break;
            }
            if (latestBuildOnNode == null) {
                latestBuildOnNode = (AbstractBuild)project.getLastBuild();
            }
            BuildVariableResolver buildVariableResolver = new BuildVariableResolver(latestBuildOnNode);
            ct.rmviewtag(this.generateNormalizedViewName(buildVariableResolver));
        }
        catch (Exception e) {
            Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.WARNING, "Failed to remove ClearCase view", e);
        }
        return true;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public boolean isRemoveViewOnRename() {
        return this.removeViewOnRename;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    public Filter configureFilters(VariableResolver<String> variableResolver, AbstractBuild build, Launcher launcher) throws IOException, InterruptedException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new DefaultFilter());
        String[] excludedStrings = this.getExcludedRegionsNormalized();
        if (excludedStrings != null && excludedStrings.length > 0) {
            for (String s : excludedStrings) {
                if (s.equals("")) continue;
                filters.add(new FileFilter(FieldFilter.Type.DoesNotContainRegxp, s));
            }
        }
        String filterRegexp = "";
        String[] viewPaths = this.getViewPaths(variableResolver, build, launcher);
        if (viewPaths != null) {
            filterRegexp = AbstractClearCaseScm.getViewPathsRegexp(viewPaths, launcher.isUnix());
        }
        if (StringUtils.isNotEmpty((String)filterRegexp)) {
            filters.add(new FileFilter(FieldFilter.Type.ContainsRegxp, filterRegexp));
        }
        if (this.isFilteringOutDestroySubBranchEvent()) {
            filters.add(new DestroySubBranchFilter());
        }
        return new FilterChain(filters);
    }

    public static String getViewPathsRegexp(String[] loadRules, boolean isUnix) {
        String filterRegexp = "";
        if (loadRules != null) {
            String tempFilterRules = "";
            for (String loadRule : loadRules) {
                if (!StringUtils.isNotEmpty((String)loadRule)) continue;
                if (loadRule.endsWith("/") || loadRule.endsWith("\\")) {
                    loadRule = loadRule.substring(0, loadRule.length() - 1);
                }
                loadRule = PathUtil.convertPathForOS(loadRule, isUnix);
                tempFilterRules = tempFilterRules + "|" + Pattern.quote(loadRule + PathUtil.fileSepForOS(isUnix));
                tempFilterRules = tempFilterRules + "|" + Pattern.quote(loadRule) + "$";
            }
            if (StringUtils.isNotEmpty((String)tempFilterRules)) {
                filterRegexp = tempFilterRules.substring(1);
            }
        }
        return filterRegexp;
    }

    public String getViewPath() {
        return StringUtils.defaultString((String)this.viewPath, (String)this.viewName);
    }

    public String getViewPath(VariableResolver<String> variableResolver) {
        String normalized = null;
        String viewPath = StringUtils.defaultIfEmpty((String)this.getViewPath(), (String)this.getViewName());
        if (viewPath != null) {
            normalized = Util.replaceMacro((String)viewPath.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_"), variableResolver);
            this.setNormalizedViewPath(normalized);
        }
        return normalized;
    }
}

