/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseChangeLogEntry
extends ChangeLogSet.Entry {
    private static final String DATE_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private String user = "";
    private String dateStr = "";
    private Date date = null;
    private String comment = "";
    private List<FileElement> files = new ArrayList<FileElement>();

    public ClearCaseChangeLogEntry() {
    }

    public ClearCaseChangeLogEntry(Date date, String user, String action, String comment, String file, String version) {
        this(date, user, comment);
        this.files.add(new FileElement(file, version, action, ""));
    }

    public ClearCaseChangeLogEntry(Date date, String user, String comment) {
        this.date = (Date)date.clone();
        this.user = user;
        this.comment = comment;
    }

    public void addElement(FileElement element) {
        this.files.add(element);
    }

    public void addElements(Collection<FileElement> files) {
        this.files.addAll(files);
    }

    @Exported
    public List<FileElement> getElements() {
        return this.files;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Exported
    public String getDateStr() {
        if (this.date == null) {
            return this.dateStr;
        }
        return new SimpleDateFormat(DATE_FORMAT).format(this.date);
    }

    public void setDateStr(String date) {
        try {
            this.date = new SimpleDateFormat(DATE_FORMAT).parse(date);
        }
        catch (ParseException e) {
            this.dateStr = date;
        }
    }

    @Exported
    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = (Date)date.clone();
    }

    @Exported
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Deprecated
    public void setFile(String file) {
        if (this.files == null || this.files.size() == 0) {
            this.addElement(new FileElement(file, "", "", ""));
        } else {
            this.files.get(0).setFile(file);
        }
    }

    @Deprecated
    public void setVersion(String version) {
        if (this.files == null || this.files.size() == 0) {
            this.addElement(new FileElement("", version, "", ""));
        } else {
            this.files.get(0).setVersion(version);
        }
    }

    @Deprecated
    public void setAction(String action) {
        if (this.files == null || this.files.size() == 0) {
            this.addElement(new FileElement("", "", action, ""));
        } else {
            this.files.get(0).setAction(action);
        }
    }

    @Exported
    public User getAuthor() {
        return User.get((String)this.user);
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.files.size());
        for (FileElement file : this.files) {
            paths.add(file.getFile());
        }
        return paths;
    }

    @Exported
    public String getMsg() {
        return this.comment;
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    @ExportedBean(defaultVisibility=999)
    public static class FileElement {
        private String name = "";
        private String version = "";
        private String action = "";
        private String operation = "";

        public FileElement() {
        }

        public FileElement(String fileName, String version, String action, String operation) {
            this.name = fileName;
            this.version = version;
            this.action = action;
            this.operation = operation;
        }

        @Exported
        public String getFile() {
            return this.name;
        }

        public void setFile(String fileName) {
            this.name = fileName;
        }

        @Exported
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @Exported
        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        @Exported
        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String status) {
            this.operation = status;
        }

        @Exported
        public EditType getEditType() {
            if (this.operation.equalsIgnoreCase("mkelem")) {
                return EditType.ADD;
            }
            if (this.operation.equalsIgnoreCase("rmelem")) {
                return EditType.DELETE;
            }
            if (this.operation.equalsIgnoreCase("checkin")) {
                return EditType.EDIT;
            }
            return null;
        }
    }
}

