/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseInstallation
extends ToolInstallation
implements NodeSpecific<ClearCaseInstallation> {
    public static final String NAME = "ClearCase";
    public static final String CLEARTOOL_EXE = "bin/cleartool";
    public static final String CLEARTOOL_EXE_FALLBACK = "cleartool";

    @DataBoundConstructor
    public ClearCaseInstallation(String home) {
        super(NAME, home, Collections.EMPTY_LIST);
    }

    public ClearCaseInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new ClearCaseInstallation(this.translateFor(node, log));
    }

    public String getCleartoolExe(Node node, TaskListener listener) throws IOException, InterruptedException {
        ClearCaseInstallation installation = this;
        if (StringUtils.isNotBlank((String)(installation = installation.forNode(node, listener)).getHome())) {
            return PathUtil.convertPathForOS((String)(installation.getHome() + "/" + CLEARTOOL_EXE), (boolean)node.createLauncher(listener).decorateFor(node).isUnix());
        }
        return CLEARTOOL_EXE_FALLBACK;
    }
}

