/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.plugins.clearcase.Baseline;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClearToolExec
implements ClearTool {
    private transient Pattern viewListPattern;
    protected ClearToolLauncher launcher;
    protected VariableResolver<String> variableResolver;
    protected String optionalMkviewParameters;

    public ClearToolExec(VariableResolver<String> variableResolver, ClearToolLauncher launcher, String optionalMkviewParameters) {
        this.variableResolver = variableResolver;
        this.launcher = launcher;
        this.optionalMkviewParameters = optionalMkviewParameters;
    }

    public String catcs(String viewTag) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("catcs");
        cmd.add(new String[]{"-tag", viewTag});
        return this.runAndProcessOutput(cmd, null, null, false, null);
    }

    public Reader describe(String format, String objectSelector) throws IOException, InterruptedException {
        Validate.notNull((Object)objectSelector);
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("desc");
        if (StringUtils.isNotBlank((String)format)) {
            cmd.add(new String[]{"-fmt", format});
        }
        cmd.add(objectSelector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        baos.close();
        return reader;
    }

    public Reader diffbl(EnumSet<ClearTool.DiffBlOptions> type, String baseline1, String baseline2, String viewPath) throws IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("diffbl");
        if (type != null) {
            for (ClearTool.DiffBlOptions t : type) {
                cmd.add(this.getOption(t));
            }
        }
        cmd.add(baseline1);
        cmd.add(baseline2);
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("cleartool-diffbl", null);
        }
        catch (IOException e) {
            throw new IOException("Couldn't create a temporary file", e);
        }
        FileOutputStream out = new FileOutputStream(tmpFile);
        FilePath workingDirectory = this.launcher.getWorkspace();
        if (viewPath != null) {
            workingDirectory = workingDirectory.child(viewPath);
        }
        try {
            this.launcher.run(cmd.toCommandArray(), null, (OutputStream)out, workingDirectory);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ((OutputStream)out).close();
        return new InputStreamReader(new FileInputStream(tmpFile));
    }

    public boolean doesStreamExist(String streamSelector) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-short");
        cmd.add(streamSelector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        baos.close();
        String cleartoolResult = baos.toString();
        return !cleartoolResult.contains("stream not found");
    }

    public boolean doesViewExist(String viewTag) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        cmd.add(viewTag);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            return this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        }
        catch (IOException e) {
            return false;
        }
    }

    public void endView(String viewTag) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("endview");
        cmd.add(viewTag);
        String output = this.runAndProcessOutput(cmd, null, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to end view tag: " + output);
        }
    }

    private String fixLoadRule(String loadRule) {
        if (StringUtils.isBlank((String)loadRule)) {
            return loadRule;
        }
        String quotedLR = ConfigSpec.cleanLoadRule((String)loadRule, (boolean)this.getLauncher().getLauncher().isUnix());
        if (quotedLR.startsWith("\"") && quotedLR.endsWith("\"")) {
            return "\"" + quotedLR.substring(2);
        }
        return quotedLR.substring(1);
    }

    public ClearToolLauncher getLauncher() {
        return this.launcher;
    }

    private Pattern getListPattern() {
        if (this.viewListPattern == null) {
            this.viewListPattern = Pattern.compile("(.)\\s*(\\S*)\\s*(\\S*)");
        }
        return this.viewListPattern;
    }

    private String getOption(ClearTool.DiffBlOptions type) {
        switch (1.$SwitchMap$hudson$plugins$clearcase$ClearTool$DiffBlOptions[type.ordinal()]) {
            case 1: {
                return "-activities";
            }
            case 2: {
                return "-versions";
            }
            case 3: {
                return "-baselines";
            }
            case 4: {
                return "-first_only";
            }
            case 5: {
                return "-nrecurse";
            }
        }
        throw new IllegalArgumentException(type + " is not supported by this implementation");
    }

    private String getOption(ClearTool.SetcsOption option) {
        switch (1.$SwitchMap$hudson$plugins$clearcase$ClearTool$SetcsOption[option.ordinal()]) {
            case 1: {
                return null;
            }
            case 2: {
                return "-current";
            }
            case 3: {
                return "-stream";
            }
        }
        throw new IllegalArgumentException(option + " is not supported by this implementation");
    }

    protected abstract FilePath getRootViewPath(ClearToolLauncher var1);

    public Properties getViewData(String viewTag) throws IOException, InterruptedException {
        Properties resPrp = new Properties();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        cmd.add(new String[]{"-l", viewTag});
        Pattern uuidPattern = Pattern.compile("View uuid: (.*)");
        Pattern globalPathPattern = Pattern.compile("View server access path: (.*)");
        boolean res = true;
        Object exception = null;
        ArrayList exceptions = new ArrayList();
        String output = this.runAndProcessOutput(cmd, null, null, true, exceptions);
        if (!exceptions.isEmpty() && !output.contains("No matching entries found for view")) {
            throw (IOException)exceptions.get(0);
        }
        if (res && exception == null) {
            String[] lines;
            for (String line : lines = output.split("\n")) {
                Matcher matcher = uuidPattern.matcher(line);
                if (matcher.find() && matcher.groupCount() == 1) {
                    resPrp.put("UUID", matcher.group(1));
                }
                if (!(matcher = globalPathPattern.matcher(line)).find() || matcher.groupCount() != 1) continue;
                resPrp.put("STORAGE_DIR", matcher.group(1));
            }
        }
        return resPrp;
    }

    public boolean lock(String comment, String objectSelector) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lock");
        cmd.add(objectSelector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        String cleartoolResult = baos.toString();
        if (cleartoolResult.contains("cleartool: Error")) {
            return false;
        }
        baos.close();
        return true;
    }

    public void logRedundantCleartoolError(String[] cmd, Exception ex) {
        this.getLauncher().getListener().getLogger().println("Redundant Cleartool Error ");
        if (cmd != null) {
            this.getLauncher().getListener().getLogger().println("command: " + this.getLauncher().getCmdString(cmd));
        }
        this.getLauncher().getListener().getLogger().println(ex.getMessage());
    }

    public Reader lsactivity(String activity, String commandFormat, String viewPath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsactivity");
        cmd.add(new String[]{"-fmt", commandFormat});
        cmd.add(activity);
        FilePath filePath = this.getRootViewPath(this.launcher).child(viewPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        baos.close();
        return reader;
    }

    public String lsbl(String baselineName, String format) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        if (StringUtils.isNotEmpty((String)format)) {
            cmd.add("-fmt");
            cmd.add(format);
        }
        cmd.add(baselineName);
        return this.runAndProcessOutput(cmd, null, null, false, null);
    }

    public String lscurrentview(String viewPath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(new String[]{"lsview", "-cview", "-s"});
        ArrayList exceptions = new ArrayList();
        String output = this.runAndProcessOutput(cmd, null, this.getLauncher().getWorkspace().child(viewPath), true, exceptions);
        if (!exceptions.isEmpty()) {
            if (output.contains("cleartool: Error: Cannot get view info for current view: not a ClearCase object.")) {
                output = null;
            } else {
                throw (IOException)exceptions.get(0);
            }
        }
        return output;
    }

    public Reader lshistory(String format, Date lastBuildDate, String viewPath, String branch, String[] pathsInView, boolean getMinor) throws IOException, InterruptedException {
        Validate.notNull((Object)pathsInView);
        Validate.notNull((Object)viewPath);
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy.HH:mm:ss'UTC'Z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lshistory");
        cmd.add("-all");
        cmd.add(new String[]{"-since", formatter.format(lastBuildDate).toLowerCase()});
        cmd.add(new String[]{"-fmt", format});
        if (StringUtils.isNotEmpty((String)branch)) {
            cmd.add(new String[]{"-branch", "brtype:" + branch});
        }
        if (getMinor) {
            cmd.add("-minor");
        }
        cmd.add("-nco");
        FilePath filePath = this.getRootViewPath(this.launcher).child(viewPath);
        for (String path : pathsInView) {
            if ((path = path.replace("\n", "").replace("\r", "")).matches(".*\\s.*")) {
                cmd.addQuoted(path);
                continue;
            }
            cmd.add(path);
        }
        InputStreamReader returnReader = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        }
        catch (IOException e) {
            // empty catch block
        }
        returnReader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        baos.close();
        return returnReader;
    }

    public String lsproject(String viewTag, String format) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsproject");
        cmd.add("-view");
        cmd.add(viewTag);
        if (StringUtils.isNotEmpty((String)format)) {
            cmd.add("-fmt");
            cmd.add(format);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        }
        catch (IOException e) {
            // empty catch block
        }
        String output = baos.toString();
        baos.close();
        return output;
    }

    public String lsstream(String stream, String viewTag, String format) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        if (StringUtils.isNotEmpty((String)viewTag)) {
            cmd.add(new String[]{"-view", viewTag});
        }
        cmd.add("-fmt");
        cmd.add(format);
        if (StringUtils.isNotEmpty((String)stream)) {
            cmd.add(stream);
        }
        return this.runAndProcessOutput(cmd, null, null, false, null);
    }

    public List<String> lsview(boolean onlyActiveDynamicViews) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsview");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null)) {
            return this.parseListOutput((Reader)new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyActiveDynamicViews);
        }
        return new ArrayList<String>();
    }

    public List<String> lsvob(boolean onlyMounted) throws IOException, InterruptedException {
        this.viewListPattern = this.getListPattern();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsvob");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null)) {
            return this.parseListOutput((Reader)new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())), onlyMounted);
        }
        return new ArrayList<String>();
    }

    public List<Baseline> mkbl(String name, String viewTag, String comment, boolean fullBaseline, boolean identical, List<String> components, String dDependsOn, String aDependsOn) throws IOException, InterruptedException {
        Validate.notNull((Object)viewTag);
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkbl");
        if (identical) {
            cmd.add("-identical");
        }
        if (StringUtils.isNotBlank((String)comment)) {
            cmd.add(new String[]{"-comment", comment});
        }
        if (fullBaseline) {
            cmd.add("-full");
        } else {
            cmd.add("-incremental");
        }
        if (StringUtils.isNotEmpty((String)viewTag)) {
            cmd.add(new String[]{"-view", viewTag});
        }
        if (CollectionUtils.isNotEmpty(components)) {
            cmd.add(new String[]{"-comp", StringUtils.join(components, (char)',')});
        }
        if (StringUtils.isNotEmpty((String)dDependsOn)) {
            cmd.add(new String[]{"-ddepends_on", dDependsOn});
        }
        if (StringUtils.isNotEmpty((String)aDependsOn)) {
            cmd.add(new String[]{"-adepends_on", aDependsOn});
        }
        cmd.add(name);
        String output = this.runAndProcessOutput(cmd, null, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to make baseline, reason: " + output);
        }
        Pattern pattern = Pattern.compile("Created baseline \"(.+?)\" in component \"(.+?)\"");
        Matcher matcher = pattern.matcher(output);
        ArrayList<Baseline> createdBaselinesList = new ArrayList<Baseline>();
        while (matcher.find() && matcher.groupCount() == 2) {
            String baseline = matcher.group(1);
            String component = matcher.group(2);
            createdBaselinesList.add(new Baseline(baseline, component));
        }
        return createdBaselinesList;
    }

    public void mklabel(String viewName, String label) throws IOException, InterruptedException {
        throw new AbortException();
    }

    public void mkstream(String parentStream, String stream) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkstream");
        cmd.add("-in");
        cmd.add(parentStream);
        cmd.add(stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        baos.close();
    }

    public void mkview(String viewPath, String viewTag, String streamSelector) throws IOException, InterruptedException {
        Validate.notEmpty((String)viewPath);
        boolean isOptionalParamContainsHost = false;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkview");
        cmd.add("-snapshot");
        if (streamSelector != null) {
            cmd.add("-stream");
            cmd.add(streamSelector);
        }
        cmd.add("-tag");
        cmd.add(viewTag);
        if (this.optionalMkviewParameters != null && this.optionalMkviewParameters.length() > 0) {
            String variabledResolvedParams = Util.replaceMacro((String)this.optionalMkviewParameters, (VariableResolver)this.variableResolver);
            cmd.addTokenized(variabledResolvedParams);
            isOptionalParamContainsHost = this.optionalMkviewParameters.contains("-host");
        }
        if (!isOptionalParamContainsHost) {
            cmd.add(viewPath);
        }
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void mkview(String viewPath, String viewTag, String streamSelector, String defaultStorageDir) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkview");
        if (streamSelector != null) {
            cmd.add("-stream");
            cmd.add(streamSelector);
        }
        cmd.add("-tag");
        cmd.add(viewTag);
        boolean isOptionalParamContainsHost = false;
        if (StringUtils.isNotEmpty((String)this.optionalMkviewParameters)) {
            String variabledResolvedParams = Util.replaceMacro((String)this.optionalMkviewParameters, (VariableResolver)this.variableResolver);
            cmd.addTokenized(variabledResolvedParams);
            isOptionalParamContainsHost = this.optionalMkviewParameters.contains("-host");
        }
        if (!isOptionalParamContainsHost && StringUtils.isNotEmpty((String)defaultStorageDir)) {
            String viewStorageDir;
            String separator = PathUtil.fileSepForOS((boolean)this.getLauncher().getLauncher().isUnix());
            String base = viewStorageDir = defaultStorageDir + separator + viewTag;
            FilePath fp = new FilePath(this.getLauncher().getLauncher().getChannel(), viewStorageDir);
            int i = 1;
            while (fp.exists()) {
                viewStorageDir = base + "." + i++;
                fp = new FilePath(this.getLauncher().getLauncher().getChannel(), viewStorageDir);
                if (i != Integer.MAX_VALUE) continue;
                throw new IOException("Cannot determine a view storage dir.");
            }
            cmd.add(viewStorageDir);
        }
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mountVobs() throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mount");
        cmd.add("-all");
        try {
            this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        }
        catch (IOException ex) {
            this.logRedundantCleartoolError(cmd.toCommandArray(), (Exception)ex);
        }
        finally {
            baos.close();
        }
    }

    private List<String> parseListOutput(Reader consoleReader, boolean onlyStarMarked) throws IOException {
        ArrayList<String> views = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(consoleReader);
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = this.viewListPattern.matcher(line);
            if (matcher.find() && matcher.groupCount() == 3 && (!onlyStarMarked || onlyStarMarked && matcher.group(1).equals("*"))) {
                String vob = matcher.group(2);
                int pos = Math.max(vob.lastIndexOf(92), vob.lastIndexOf(47));
                if (pos != -1) {
                    vob = vob.substring(pos + 1);
                }
                views.add(vob);
            }
            line = reader.readLine();
        }
        reader.close();
        return views;
    }

    public void setBaselinePromotionLevel(String baselineName, ClearTool.DefaultPromotionLevel promotionLevel) throws IOException, InterruptedException {
        this.setBaselinePromotionLevel(baselineName, promotionLevel.toString());
    }

    public void setBaselinePromotionLevel(String baselineName, String promotionLevel) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-c");
        cmd.add("Hudson set baseline to promotion level " + promotionLevel);
        cmd.add("-level");
        cmd.add(promotionLevel);
        cmd.add(baselineName);
        this.runAndProcessOutput(cmd, null, null, false, null);
    }

    public String pwv(String viewPath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("pwv");
        cmd.add("-root");
        FilePath vp = this.getRootViewPath(this.launcher).child(viewPath);
        if (vp.exists()) {
            return this.runAndProcessOutput(cmd, null, vp, false, null);
        }
        return null;
    }

    public void rebaseDynamic(String viewTag, String baseline) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rebase");
        cmd.add(new String[]{"-baseline", baseline});
        cmd.add(new String[]{"-view", viewTag});
        cmd.add("-complete");
        cmd.add("-force");
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void recommendBaseline(String streamSelector) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chstream");
        cmd.add("-rec");
        cmd.add("-def");
        cmd.add(streamSelector);
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void rmview(String viewPath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add(viewPath);
        FilePath workspace = this.launcher.getWorkspace();
        String output = this.runAndProcessOutput(cmd, null, workspace, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to remove view: " + output);
        }
        FilePath viewFilePath = workspace.child(viewPath);
        if (viewFilePath.exists()) {
            this.launcher.getListener().getLogger().println("Removing view folder as it was not removed when the view was removed.");
            viewFilePath.deleteRecursive();
        }
    }

    public void rmviewtag(String viewTag) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add("-tag");
        cmd.add(viewTag);
        String output = this.runAndProcessOutput(cmd, null, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to remove view tag: " + output);
        }
    }

    public void rmtag(String viewTag) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmtag");
        cmd.add("-view");
        cmd.add(viewTag);
        String output = this.runAndProcessOutput(cmd, null, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to remove view tag: " + output);
        }
    }

    public void rmviewUuid(String viewUuid) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add("-avobs");
        cmd.add("-uuid");
        cmd.add(viewUuid);
        String output = this.runAndProcessOutput(cmd, null, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to remove view: " + output);
        }
    }

    protected String runAndProcessOutput(ArgumentListBuilder cmd, InputStream in, FilePath workFolder, boolean catchExceptions, List<IOException> exceptions) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.launcher.run(cmd.toCommandArray(), in, (OutputStream)baos, workFolder);
        }
        catch (IOException e) {
            if (!catchExceptions) {
                throw e;
            }
            exceptions.add(e);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        baos.close();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
            line = reader.readLine();
        }
        reader.close();
        return builder.toString();
    }

    public void setcs(String viewPath, ClearTool.SetcsOption option, String configSpec) throws IOException, InterruptedException {
        this.setcs(null, viewPath, option, configSpec);
    }

    private void setcs(String viewTag, String viewPath, ClearTool.SetcsOption option, String configSpec) throws IOException, InterruptedException {
        String optionStr;
        if (option == ClearTool.SetcsOption.CONFIGSPEC) {
            Validate.notNull((Object)configSpec, (String)"Using option CONFIGSPEC, you must provide a non-null config spec");
        } else {
            Validate.isTrue((configSpec == null ? 1 : 0) != 0, (String)"Not using option CONFIGSPEC, you must provide a null config spec");
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        if (viewTag != null) {
            cmd.add("-tag");
            cmd.add(viewTag);
        }
        if ((optionStr = this.getOption(option)) != null) {
            cmd.add(optionStr);
        }
        FilePath configSpecFile = null;
        if (option == ClearTool.SetcsOption.CONFIGSPEC) {
            configSpecFile = this.launcher.getWorkspace().createTextTempFile("configspec", ".txt", configSpec);
            cmd.add(PathUtil.convertPathForOS((String)configSpecFile.absolutize().getRemote(), (boolean)this.launcher.getLauncher().isUnix()));
        }
        FilePath workingDirectory = null;
        if (viewPath != null) {
            workingDirectory = new FilePath(this.getRootViewPath(this.launcher), viewPath);
        }
        String output = this.runAndProcessOutput(cmd, (InputStream)new ByteArrayInputStream("yes".getBytes()), workingDirectory, false, null);
        if (configSpecFile != null) {
            configSpecFile.delete();
        }
        if (output.contains("cleartool: Warning: An update is already in progress for view")) {
            throw new IOException("View update failed: " + output);
        }
    }

    public void setcsCurrent(String viewPath) throws IOException, InterruptedException {
        this.setcs(viewPath, ClearTool.SetcsOption.CURRENT, null);
    }

    public void setcsTag(String viewTag, ClearTool.SetcsOption option, String configSpec) throws IOException, InterruptedException {
        this.setcs(viewTag, null, option, configSpec);
    }

    public void startView(String viewTags) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("startview");
        cmd.addTokenized(viewTags);
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void unlock(String comment, String objectSelector) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("unlock");
        cmd.add(objectSelector);
        this.launcher.run(cmd.toCommandArray(), null, null, null);
    }

    public void unregisterView(String uuid) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("unregister");
        cmd.add("-view");
        cmd.add("-uuid");
        cmd.add(uuid);
        String output = this.runAndProcessOutput(cmd, null, null, false, null);
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to unregister view: " + output);
        }
    }

    public void update(String viewPath, String[] loadRules) throws IOException, InterruptedException {
        String output;
        FilePath filePath = this.getLauncher().getWorkspace().child(viewPath);
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("update");
        cmd.add("-force");
        cmd.add("-overwrite");
        cmd.add(new String[]{"-log", "NUL"});
        if (!ArrayUtils.isEmpty((Object[])loadRules)) {
            cmd.add("-add_loadrules");
            for (String loadRule : loadRules) {
                cmd.add(this.fixLoadRule(loadRule));
            }
        }
        if ((output = this.runAndProcessOutput(cmd, (InputStream)new ByteArrayInputStream("yes".getBytes()), filePath, false, null)).contains("cleartool: Warning: An update is already in progress for view")) {
            throw new IOException("View update failed: " + output);
        }
    }
}

