/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.ucm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.ucm.UcmCommon;
import hudson.plugins.clearcase.ucm.UcmMakeBaselineComposite;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.SCM;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcmMakeBaselineComposite
extends Notifier {
    private final String compositeNamePattern;
    private final String compositeStreamSelector;
    private final String compositeComponentName;
    private final boolean extractInfoFile;
    private final String fileName;

    public String getCompositeNamePattern() {
        return this.compositeNamePattern;
    }

    public String getCompositeStreamSelector() {
        return this.compositeStreamSelector;
    }

    public String getCompositeComponentName() {
        return this.compositeComponentName;
    }

    public boolean isExtractInfoFile() {
        return this.extractInfoFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private UcmMakeBaselineComposite(String compositeNamePattern, String compositeStreamSelector, String compositeComponentName, boolean extractInfoFile, String fileName) {
        this.compositeNamePattern = compositeNamePattern.trim();
        this.compositeStreamSelector = compositeStreamSelector.trim();
        this.compositeComponentName = compositeComponentName.trim();
        this.extractInfoFile = extractInfoFile;
        this.fileName = fileName.trim();
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof ClearCaseUcmSCM)) {
            listener.getLogger().println("Not a UCM clearcase SCM, cannot create baseline composite");
            return false;
        }
        ClearCaseUcmSCM ucm = (ClearCaseUcmSCM)scm;
        FilePath workspace = build.getWorkspace();
        ClearToolLauncher clearToolLauncher = ucm.createClearToolLauncher((TaskListener)listener, workspace, launcher);
        BuildVariableResolver variableResolver = new BuildVariableResolver(build);
        ClearTool clearTool = ucm.createClearTool((VariableResolver)variableResolver, clearToolLauncher);
        if (!build.getResult().equals(Result.SUCCESS)) {
            listener.getLogger().println("Build has failed, cannot create baseline composite");
            return false;
        }
        try {
            String compositeBaselineName = Util.replaceMacro((String)this.compositeNamePattern, (VariableResolver)new BuildVariableResolver(build));
            String pvob = UcmCommon.getVob((String)this.compositeStreamSelector);
            this.makeCompositeBaseline(clearTool, compositeBaselineName, this.compositeStreamSelector, this.compositeComponentName, pvob);
            this.promoteCompositeBaselineToBuiltLevel(clearTool, compositeBaselineName, pvob);
            if (!this.extractInfoFile) return true;
            this.processExtractInfoFile(clearTool, this.compositeComponentName, pvob, compositeBaselineName, this.fileName);
            return true;
        }
        catch (Exception ex) {
            listener.getLogger().println("Failed to create baseline: " + ex);
            return false;
        }
    }

    private List<String> getComponentList(ClearTool clearTool, String stream) throws IOException, InterruptedException {
        String output = clearTool.lsstream(stream, null, "\"%[components]XCp\"");
        String[] comp = output.split(",\\s");
        ArrayList<String> result = new ArrayList<String>();
        String prefix = "component:";
        for (String c : comp) {
            if (!StringUtils.startsWith((String)c, (String)"component:")) {
                throw new IOException("Invalid format for component in output. Must starts with 'component:' : " + c);
            }
            result.add(StringUtils.difference((String)"component:", (String)c));
        }
        return result;
    }

    private String getOneViewFromStream(ClearTool clearTool, String stream) throws IOException, InterruptedException {
        String output = clearTool.lsstream(stream, null, "\"%[views]p\"");
        String[] resultLines = output.split("\n");
        if (resultLines.length == 0) {
            throw new IOException("There is no view attached to the stream '" + stream + "'");
        }
        String viewsLines = resultLines[resultLines.length - 1];
        return viewsLines.split(" ")[0];
    }

    private void makeCompositeBaseline(ClearTool clearTool, String compositeBaselineName, String compositeStream, String compositeComponent, String pvob) throws Exception {
        String compositeView = this.getOneViewFromStream(clearTool, this.compositeStreamSelector);
        List componentList = this.getComponentList(clearTool, this.compositeStreamSelector);
        StringBuffer sb = new StringBuffer();
        for (String comp : componentList) {
            if (comp.contains(compositeComponent)) continue;
            sb.append(",").append(comp);
        }
        sb.delete(0, 1);
        String dependsOn = sb.toString();
        clearTool.mkbl(compositeBaselineName, compositeView, null, true, false, Arrays.asList(compositeComponent), dependsOn, dependsOn);
    }

    private void promoteCompositeBaselineToBuiltLevel(ClearTool clearTool, String compositeBaselineName, String pvob) throws InterruptedException, IOException {
        clearTool.setBaselinePromotionLevel(compositeBaselineName + "@" + pvob, ClearTool.DefaultPromotionLevel.BUILT);
    }

    private String getComponent(ClearTool clearTool, String baseline) throws IOException, InterruptedException {
        String output = clearTool.lsbl(baseline, "\"%[component]p\"");
        if (output.contains("cleartool: Error")) {
            throw new IOException("Failed to make baseline, reason: " + output);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExtractInfoFile(ClearTool clearTool, String compositeComponnentName, String pvob, String compositeBaselineName, String fileName) throws Exception {
        String output = clearTool.lsbl(compositeBaselineName + "@" + pvob, "\"%[depends_on]p\"");
        if (output.contains("cleartool: Error")) {
            throw new Exception("Failed to make baseline, reason: " + output);
        }
        String[] baselinesComp = output.split(" ");
        List<String> baselineList = Arrays.asList(baselinesComp);
        Collections.sort(baselineList);
        Writer writer = null;
        try {
            FilePath fp = new FilePath(clearTool.getLauncher().getLauncher().getChannel(), fileName);
            OutputStream outputStream = fp.write();
            writer = new OutputStreamWriter(outputStream);
            writer.write("The composite baseline is '" + compositeBaselineName + "'");
            for (String baseLine : baselineList) {
                writer.write("\nThe  baseline of component '" + this.getComponent(clearTool, baseLine) + "' is :" + baseLine);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

