/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearCaseSCM;
import hudson.plugins.clearcase.Messages;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseInstallation
extends ToolInstallation
implements NodeSpecific<ClearCaseInstallation> {
    public static final String NAME = "ClearCase";
    public static final String CLEARTOOL_EXE = "bin/cleartool";
    public static final String CLEARTOOL_EXE_FALLBACK = "cleartool";

    @DataBoundConstructor
    public ClearCaseInstallation(String home) {
        super(NAME, home, Collections.EMPTY_LIST);
    }

    public ClearCaseInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new ClearCaseInstallation(this.translateFor(node, log));
    }

    public String getCleartoolExe(Node node, TaskListener listener) throws IOException, InterruptedException {
        ClearCaseInstallation installation = this;
        if (StringUtils.isNotBlank((String)(installation = installation.forNode(node, listener)).getHome())) {
            return PathUtil.convertPathForOS(installation.getHome() + "/" + CLEARTOOL_EXE, node.createLauncher(listener).decorateFor(node).isUnix());
        }
        return CLEARTOOL_EXE_FALLBACK;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<ClearCaseInstallation> {
        private transient ClearCaseSCM.ClearCaseScmDescriptor desc;

        public DescriptorImpl() {
            this.setInstallations(new ClearCaseInstallation[0]);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ClearCaseSCM.ClearCaseScmDescriptor desc = (ClearCaseSCM.ClearCaseScmDescriptor)Hudson.getInstance().getDescriptorByType(ClearCaseSCM.ClearCaseScmDescriptor.class);
            if (desc == null) {
                desc = new ClearCaseSCM.ClearCaseScmDescriptor();
            }
            desc.configure(req, formData);
            desc.save();
            this.setInstallations(req.bindJSONToList(ClearCaseInstallation.class, formData.get("clearcaseinstall")).toArray(new ClearCaseInstallation[0]));
            this.save();
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter String value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            File clearCaseHome = new File(Util.replaceMacro((String)value, (Map)EnvVars.masterEnvVars));
            if (clearCaseHome.getPath().equals("")) {
                return FormValidation.ok((String)Messages.ClearCaseInstallation_CleartoolWillBeCalledFromPath());
            }
            if (!clearCaseHome.isDirectory()) {
                return FormValidation.error((String)Messages.ClearCaseInstallation_NotAFolder(value));
            }
            String cleartool = ClearCaseInstallation.CLEARTOOL_EXE;
            if (Functions.isWindows()) {
                cleartool = cleartool + ".exe";
            }
            if (!new File(clearCaseHome, cleartool).exists()) {
                return FormValidation.error((String)Messages.ClearCaseInstallation_NotAClearCaseInstallationFolder(value));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.ClearCaseInstallation_DisplayName();
        }

        public ClearCaseInstallation getInstallation() {
            ClearCaseInstallation[] installations = (ClearCaseInstallation[])this.getInstallations();
            if (installations.length > 0) {
                return installations[0];
            }
            return null;
        }

        public String getDefaultViewName() {
            return this.getCCDescriptor().getDefaultViewName();
        }

        public String getDefaultViewPath() {
            return this.getCCDescriptor().getDefaultViewPath();
        }

        public String getDefaultWinDynStorageDir() {
            return this.getCCDescriptor().getDefaultWinDynStorageDir();
        }

        public String getDefaultUnixDynStorageDir() {
            return this.getCCDescriptor().getDefaultUnixDynStorageDir();
        }

        public int getLogMergeTimeWindow() {
            return this.getCCDescriptor().getLogMergeTimeWindow();
        }

        private ClearCaseSCM.ClearCaseScmDescriptor getCCDescriptor() {
            if (this.desc == null) {
                this.desc = (ClearCaseSCM.ClearCaseScmDescriptor)Hudson.getInstance().getDescriptorByType(ClearCaseSCM.ClearCaseScmDescriptor.class);
                if (this.desc == null) {
                    this.desc = new ClearCaseSCM.ClearCaseScmDescriptor();
                }
                this.desc.load();
            }
            return this.desc;
        }
    }
}

