/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.history;

import hudson.plugins.clearcase.history.Filter;
import hudson.plugins.clearcase.history.HistoryEntry;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public abstract class OperationFilter
implements Filter {
    private static final Pattern PATTERN_OBJECT_NAME = Pattern.compile("^[^\"]*\"(.*)\"[^\"]*$");
    protected ArrayList<Pattern> namePatterns;

    protected abstract String[] getApplicableOperations();

    protected abstract boolean getAllowOtherOperations();

    public OperationFilter(String ... namePatterns) {
        if (namePatterns != null) {
            this.namePatterns = new ArrayList(namePatterns.length);
            for (String name : namePatterns) {
                this.namePatterns.add(Pattern.compile(name));
            }
        }
    }

    public boolean accept(HistoryEntry entry) {
        if (!ArrayUtils.contains((Object[])this.getApplicableOperations(), (Object)entry.getOperation())) {
            return this.getAllowOtherOperations();
        }
        if (this.namePatterns == null) {
            return true;
        }
        String objectName = this.getObjectName(entry);
        for (Pattern pattern : this.namePatterns) {
            if (!pattern.matcher(objectName).matches()) continue;
            return true;
        }
        return false;
    }

    protected String getObjectName(HistoryEntry entry) {
        Matcher matcher = PATTERN_OBJECT_NAME.matcher(entry.getEvent());
        return matcher.matches() ? matcher.group(1) : "";
    }
}

