/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.plugins.clearcase.AbstractClearCaseScm;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ItemListenerImpl;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import hudson.util.VariableResolver;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@Extension
public class ItemListenerImpl
extends ItemListener {
    public void onRenamed(Item item, String oldName, String newName) {
        AbstractProject project;
        SCM scm;
        Hudson hudson = this.getHudsonFromItem(item);
        if (item instanceof AbstractProject && (scm = (project = (AbstractProject)item).getScm()) instanceof AbstractClearCaseScm) {
            try {
                AbstractClearCaseScm ccScm = (AbstractClearCaseScm)scm;
                if (!ccScm.isRemoveViewOnRename()) {
                    return;
                }
                StreamTaskListener listener = StreamTaskListener.fromStdout();
                Launcher launcher = hudson.createLauncher((TaskListener)listener);
                AbstractBuild build = project.getSomeBuildWithWorkspace();
                if (build != null) {
                    JobNameOverrideBuildVariableResolver variableResolver = new JobNameOverrideBuildVariableResolver(oldName, build, ccScm.getBuildComputer(build));
                    String normalizedViewName = ccScm.generateNormalizedViewName((VariableResolver)variableResolver);
                    FilePath workspace = this.isFreeStyleProjectAndHasCustomWorkspace(project) ? new FilePath(launcher.getChannel(), ((FreeStyleProject)project).getCustomWorkspace()) : (build.getBuiltOn() == hudson ? build.getWorkspace().getParent().getParent().child(newName).child("workspace") : build.getWorkspace());
                    ClearTool ct = ccScm.createClearTool(null, ccScm.createClearToolLauncher((TaskListener)listener, workspace, launcher));
                    if (ct.doesViewExist(normalizedViewName)) {
                        String viewPath = ccScm.getViewPath((VariableResolver)new VariableResolver.ByMap((Map)build.getEnvironment((TaskListener)listener)));
                        if (workspace.child(viewPath).exists()) {
                            ct.rmview(viewPath);
                        } else {
                            ct.rmviewtag(normalizedViewName);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.WARNING, "Failed to remove ClearCase view", e);
            }
        }
    }

    private boolean isFreeStyleProjectAndHasCustomWorkspace(AbstractProject project) {
        if (project instanceof FreeStyleProject) {
            FreeStyleProject fsProject = (FreeStyleProject)project;
            return StringUtils.isNotEmpty((String)fsProject.getCustomWorkspace());
        }
        return false;
    }

    private Hudson getHudsonFromItem(Item item) {
        ItemGroup itemGroup = item.getParent();
        Hudson hudson = null;
        while (hudson == null) {
            if (itemGroup instanceof Hudson) {
                hudson = (Hudson)itemGroup;
                continue;
            }
            if (itemGroup instanceof TopLevelItem) {
                hudson = ((TopLevelItem)itemGroup).getParent();
                continue;
            }
            itemGroup = ((Item)itemGroup).getParent();
        }
        return hudson;
    }

    public void onDeleted(Item item) {
        AbstractProject project;
        SCM scm;
        Hudson hudson = this.getHudsonFromItem(item);
        if (item instanceof AbstractProject && (scm = (project = (AbstractProject)item).getScm()) instanceof AbstractClearCaseScm) {
            try {
                AbstractClearCaseScm ccScm = (AbstractClearCaseScm)scm;
                if (!ccScm.isCreateDynView()) {
                    return;
                }
                StreamTaskListener listener = StreamTaskListener.fromStdout();
                Launcher launcher = hudson.createLauncher((TaskListener)listener);
                ClearTool ct = ccScm.createClearTool(null, ccScm.createClearToolLauncher((TaskListener)listener, project.getSomeWorkspace().getParent().getParent(), launcher));
                if (project.getLastBuild() != null) {
                    BuildVariableResolver variableResolver = new BuildVariableResolver((AbstractBuild)project.getLastBuild());
                    String normalizedViewName = ccScm.generateNormalizedViewName((VariableResolver)variableResolver);
                    ct.rmviewtag(normalizedViewName);
                }
            }
            catch (Exception e) {
                Logger.getLogger(AbstractClearCaseScm.class.getName()).log(Level.WARNING, "Failed to remove ClearCase view", e);
            }
        }
    }
}

