/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import hudson.plugins.clearcase.action.CheckOutAction;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheckoutAction
implements CheckOutAction {
    protected final ClearTool cleartool;
    protected final String[] loadRules;
    protected final boolean useUpdate;
    protected final String viewPath;

    public AbstractCheckoutAction(ClearTool cleartool, String[] loadRules, boolean useUpdate, String viewPath) {
        Validate.notNull((Object)cleartool);
        this.cleartool = cleartool;
        this.loadRules = loadRules;
        this.useUpdate = useUpdate;
        this.viewPath = viewPath;
    }

    public boolean isViewValid(Launcher launcher, FilePath workspace, String viewTag) throws IOException, InterruptedException {
        return this.cleartool.doesViewExist(viewTag) && viewTag.equals(this.cleartool.lscurrentview(this.viewPath));
    }

    protected boolean cleanAndCreateViewIfNeeded(FilePath workspace, String viewTag, String viewPath, String streamSelector) throws IOException, InterruptedException {
        Validate.notEmpty((String)viewPath);
        FilePath filePath = new FilePath(workspace, viewPath);
        boolean viewPathExists = filePath.exists();
        boolean doViewCreation = true;
        if (this.cleartool.doesViewExist(viewTag)) {
            if (viewPathExists) {
                if (viewTag.equals(this.cleartool.lscurrentview(viewPath))) {
                    if (this.useUpdate) {
                        doViewCreation = false;
                    } else {
                        this.cleartool.rmview(viewPath);
                    }
                } else {
                    filePath.renameTo(this.getUnusedFilePath(workspace, viewPath));
                    this.rmviewtag(viewTag);
                }
            } else {
                this.rmviewtag(viewTag);
            }
        } else if (viewPathExists) {
            filePath.renameTo(this.getUnusedFilePath(workspace, viewPath));
        }
        if (doViewCreation) {
            this.cleartool.mkview(viewPath, viewTag, streamSelector);
        }
        return doViewCreation;
    }

    private void rmviewtag(String viewTag) throws InterruptedException, IOException {
        try {
            this.cleartool.rmviewtag(viewTag);
        }
        catch (IOException e) {
            this.cleartool.rmtag(viewTag);
        }
    }

    protected LoadRulesDelta getLoadRulesDelta(Set<String> configSpecLoadRules, Launcher launcher) {
        LinkedHashSet<String> removedLoadRules = new LinkedHashSet<String>(configSpecLoadRules);
        LinkedHashSet<String> addedLoadRules = new LinkedHashSet<String>();
        if (!ArrayUtils.isEmpty((Object[])this.loadRules)) {
            for (String loadRule : this.loadRules) {
                addedLoadRules.add(ConfigSpec.cleanLoadRule((String)loadRule, (boolean)launcher.isUnix()));
            }
            removedLoadRules.removeAll(addedLoadRules);
            addedLoadRules.removeAll(configSpecLoadRules);
            PrintStream logger = launcher.getListener().getLogger();
            for (String removedLoadRule : removedLoadRules) {
                logger.println("Removed load rule : " + removedLoadRule);
            }
            for (String addedLoadRule : addedLoadRules) {
                logger.println("Added load rule : " + addedLoadRule);
            }
        }
        return new LoadRulesDelta(removedLoadRules, addedLoadRules);
    }

    private FilePath getUnusedFilePath(FilePath workspace, String viewName) throws IOException, InterruptedException {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            FilePath result = new FilePath(workspace, viewName + ".keep." + i);
            if (result.exists()) continue;
            return result;
        }
        return null;
    }
}

