/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.util;

import hudson.plugins.clearcase.ClearCaseChangeLogEntry;
import hudson.plugins.clearcase.util.ChangeLogEntryMerger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ChangeLogEntryMerger {
    private Map<String, List<MergedLogEntry>> userEntries = new HashMap();
    private transient int maxTimeDifference;

    public ChangeLogEntryMerger() {
        this(0);
    }

    public ChangeLogEntryMerger(int maxTimeDifferenceMillis) {
        this.maxTimeDifference = maxTimeDifferenceMillis + 1000;
    }

    public List<ClearCaseChangeLogEntry> getMergedList(List<ClearCaseChangeLogEntry> orgList) {
        this.userEntries.clear();
        for (ClearCaseChangeLogEntry entry : orgList) {
            boolean wasMerged = false;
            List entries = this.getUserEntries(entry.getUser());
            for (MergedLogEntry storedEntry : entries) {
                if (!this.canBeMerged(storedEntry, entry)) continue;
                storedEntry.merge(entry);
                wasMerged = true;
                break;
            }
            if (wasMerged) continue;
            entries.add(new MergedLogEntry(entry));
        }
        List list = this.getList();
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        return list;
    }

    private List<ClearCaseChangeLogEntry> getList() {
        ArrayList<ClearCaseChangeLogEntry> list = new ArrayList<ClearCaseChangeLogEntry>();
        Set users = this.userEntries.keySet();
        for (String user : users) {
            List userList = (List)this.userEntries.get(user);
            for (MergedLogEntry entry : userList) {
                MergedLogEntry.access$100((MergedLogEntry)entry).setDate(MergedLogEntry.access$000((MergedLogEntry)entry));
                list.add(MergedLogEntry.access$100((MergedLogEntry)entry));
            }
        }
        return list;
    }

    private List<MergedLogEntry> getUserEntries(String user) {
        if (!this.userEntries.containsKey(user)) {
            this.userEntries.put(user, new ArrayList());
        }
        return (List)this.userEntries.get(user);
    }

    private boolean canBeMerged(MergedLogEntry entryOne, ClearCaseChangeLogEntry entryTwo) {
        if (MergedLogEntry.access$100((MergedLogEntry)entryOne).getComment().equals(entryTwo.getComment())) {
            long oldestDiff = Math.abs(MergedLogEntry.access$000((MergedLogEntry)entryOne).getTime() - entryTwo.getDate().getTime());
            long newestDiff = Math.abs(MergedLogEntry.access$200((MergedLogEntry)entryOne).getTime() - entryTwo.getDate().getTime());
            return oldestDiff < (long)this.maxTimeDifference || newestDiff < (long)this.maxTimeDifference;
        }
        return false;
    }
}

