/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.util.ForkOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HudsonClearToolLauncher
implements ClearToolLauncher {
    private final TaskListener listener;
    private final FilePath workspace;
    private final Launcher launcher;
    private final String scmName;
    private final String executable;

    public HudsonClearToolLauncher(String executable, String scmName, TaskListener listener, FilePath workspace, Launcher launcher) {
        this.executable = executable;
        this.scmName = scmName;
        this.listener = listener;
        this.workspace = workspace;
        this.launcher = launcher;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public FilePath getWorkspace() {
        return this.workspace;
    }

    public boolean run(String[] cmd, FilePath filePath) throws IOException, InterruptedException {
        return this.run(cmd, null, null, filePath);
    }

    public boolean run(String[] cmd, InputStream inputStream, OutputStream outputStream, FilePath filePath) throws IOException, InterruptedException {
        return this.run(cmd, inputStream, outputStream, filePath, false);
    }

    public boolean run(String[] cmd, InputStream inputStream, OutputStream outputStream, FilePath filePath, boolean logCommand) throws IOException, InterruptedException {
        String ccVerbose = System.getenv("HUDSON_CLEARCASE_VERBOSE");
        ccVerbose = ccVerbose != null ? ccVerbose : "";
        logCommand = logCommand || ccVerbose.equals("1");
        OutputStream out = outputStream;
        FilePath path = filePath;
        String[] env = new String[]{};
        if (path == null) {
            path = this.workspace;
        }
        out = out == null ? this.listener.getLogger() : new ForkOutputStream(out, (OutputStream)this.listener.getLogger());
        if (logCommand) {
            String logStr = "\nRunning ClearCase command: " + this.getCmdString(cmd) + "\n\n";
            this.listener.getLogger().write(logStr.getBytes());
        }
        String[] cmdWithExec = new String[cmd.length + 1];
        cmdWithExec[0] = this.executable;
        for (int i = 0; i < cmd.length; ++i) {
            cmdWithExec[i + 1] = cmd[i];
        }
        int r = this.getLaunchedProc(cmdWithExec, env, inputStream, out, path).join();
        if (r != 0) {
            this.listener.fatalError(this.scmName + " failed. exit code=" + r);
            throw new IOException("cleartool did not return the expected exit code. Command line=\"" + this.getCmdString(cmd) + "\", actual exit code=" + r);
        }
        if (logCommand) {
            String logStr = "\n=============================================================== \n";
            this.listener.getLogger().write(logStr.getBytes());
        }
        return true;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public Proc getLaunchedProc(String[] cmdWithExec, String[] env, InputStream inputStream, OutputStream out, FilePath path) throws IOException {
        return this.getLauncher().launch().cmds(cmdWithExec).envs(env).stdin(inputStream).stdout(out).pwd(path).start();
    }

    public String getCmdString(String[] cmd) {
        StringBuilder builder = new StringBuilder();
        for (String cmdParam : cmd) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(cmdParam);
        }
        return builder.toString();
    }
}

