/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.plugins.clearcase.ClearCaseDataAction;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.action.CheckOutAction;
import hudson.plugins.clearcase.util.PathUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicCheckoutAction
implements CheckOutAction {
    private ClearTool cleartool;
    private String configSpec;
    private boolean doNotUpdateConfigSpec;
    private boolean useTimeRule;
    private boolean createDynView;
    private String winDynStorageDir;
    private String unixDynStorageDir;
    private AbstractBuild<?, ?> build;

    public DynamicCheckoutAction(ClearTool cleartool, String configSpec, boolean doNotUpdateConfigSpec, boolean useTimeRule, boolean createDynView, String winDynStorageDir, String unixDynStorageDir, AbstractBuild<?, ?> build) {
        this.cleartool = cleartool;
        this.configSpec = configSpec;
        this.doNotUpdateConfigSpec = doNotUpdateConfigSpec;
        this.useTimeRule = useTimeRule;
        this.createDynView = createDynView;
        this.winDynStorageDir = winDynStorageDir;
        this.unixDynStorageDir = unixDynStorageDir;
        this.build = build;
    }

    @Override
    public boolean checkout(Launcher launcher, FilePath workspace, String viewTag) throws IOException, InterruptedException {
        if (this.createDynView) {
            if (this.cleartool.doesViewExist(viewTag)) {
                try {
                    this.cleartool.rmview(viewTag);
                }
                catch (Exception ex) {
                    this.cleartool.logRedundantCleartoolError(null, ex);
                }
            }
            String dynStorageDir = this.cleartool.getLauncher().getLauncher().isUnix() ? this.unixDynStorageDir : this.winDynStorageDir;
            this.cleartool.mkview(viewTag, viewTag, null, dynStorageDir);
        }
        this.cleartool.startView(viewTag);
        String currentConfigSpec = this.cleartool.catcs(viewTag).trim();
        String effectiveConfigSpec = "";
        String tempConfigSpec = this.useTimeRule ? PathUtil.convertPathForOS("time " + this.getTimeRule() + "\n" + this.configSpec + "\nend time\n", launcher) : PathUtil.convertPathForOS(this.configSpec, launcher);
        if (!this.doNotUpdateConfigSpec) {
            if (!tempConfigSpec.trim().replaceAll("\r\n", "\n").equals(currentConfigSpec)) {
                this.cleartool.setcs(viewTag, ClearTool.SetcsOption.CONFIGSPEC, tempConfigSpec);
                effectiveConfigSpec = tempConfigSpec;
            } else {
                this.cleartool.setcs(viewTag, ClearTool.SetcsOption.CURRENT, null);
                effectiveConfigSpec = currentConfigSpec;
            }
        } else {
            effectiveConfigSpec = currentConfigSpec;
        }
        ClearCaseDataAction dataAction = (ClearCaseDataAction)this.build.getAction(ClearCaseDataAction.class);
        if (dataAction != null) {
            dataAction.setCspec(effectiveConfigSpec);
        }
        return true;
    }

    public String getTimeRule() {
        return this.getTimeRule(new Date());
    }

    public String getTimeRule(Date nowDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yy.HH:mm:ss'UTC'Z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(nowDate).toLowerCase();
    }

    @Override
    public boolean isViewValid(Launcher launcher, FilePath workspace, String viewTag) throws IOException, InterruptedException {
        if (this.cleartool.doesViewExist(viewTag)) {
            this.cleartool.startView(viewTag);
            return true;
        }
        return false;
    }
}

