/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clearcase.action;

import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearTool;
import hudson.plugins.clearcase.ConfigSpec;
import hudson.plugins.clearcase.action.AbstractCheckoutAction;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;

public class UcmSnapshotCheckoutAction
extends AbstractCheckoutAction {
    private final String streamSelector;

    public UcmSnapshotCheckoutAction(ClearTool cleartool, String streamSelector, String[] loadRules, boolean useUpdate, String viewPath) {
        super(cleartool, loadRules, useUpdate, viewPath);
        this.streamSelector = streamSelector;
    }

    public boolean checkout(Launcher launcher, FilePath workspace, String viewTag) throws IOException, InterruptedException {
        boolean viewCreated = this.cleanAndCreateViewIfNeeded(workspace, viewTag, this.viewPath, this.streamSelector);
        if (viewCreated) {
            try {
                this.cleartool.update(this.viewPath, this.loadRules);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        ConfigSpec viewConfigSpec = new ConfigSpec(this.cleartool.catcs(viewTag), launcher.isUnix());
        AbstractCheckoutAction.LoadRulesDelta loadRulesDelta = this.getLoadRulesDelta(viewConfigSpec.getLoadRules(), launcher);
        if (!ArrayUtils.isEmpty((Object[])loadRulesDelta.getRemoved())) {
            try {
                this.cleartool.setcs(this.viewPath, ClearTool.SetcsOption.CONFIGSPEC, viewConfigSpec.setLoadRules(this.loadRules).getRaw());
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        Object[] addedLoadRules = loadRulesDelta.getAdded();
        if (!ArrayUtils.isEmpty((Object[])addedLoadRules)) {
            try {
                this.cleartool.update(this.viewPath, (String[])addedLoadRules);
            }
            catch (IOException e) {
                launcher.getListener().fatalError(e.toString());
                return false;
            }
        }
        try {
            this.cleartool.update(this.viewPath, null);
        }
        catch (IOException e) {
            launcher.getListener().fatalError(e.toString());
            return false;
        }
        return true;
    }
}

